/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.loader.util;

public final class Penalty {
    public static final Penalty ZERO_PENALTY = new Penalty(0);
    public static final Penalty INFINITE_PENALTY = new Penalty(Integer.MAX_VALUE);
    private final int value;

    public static Penalty toPenalty(int n) {
        switch (n) {
            case 0: {
                return ZERO_PENALTY;
            }
            case 0x7FFFFFFF: {
                return INFINITE_PENALTY;
            }
        }
        return new Penalty(n);
    }

    private Penalty(int n) {
        this.value = n;
    }

    public Penalty add(Penalty penalty) {
        return this.add(penalty.getValue());
    }

    public Penalty add(int n) {
        long l = (long)this.getValue() + (long)n;
        return Penalty.toPenalty(Penalty.truncate(l));
    }

    public int getValue() {
        return this.value;
    }

    public boolean isInfinitePenalty() {
        return this.value == Integer.MAX_VALUE;
    }

    public String toString() {
        return "Penalty: " + (this.isInfinitePenalty() ? "INF" : Integer.toString(this.getValue()));
    }

    public static int truncate(long l) {
        l = Math.min(Integer.MAX_VALUE, l);
        l = Math.max(Integer.MIN_VALUE, l);
        return (int)l;
    }
}

