/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.generator.qdox.model.annotation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.hamcrest.generator.qdox.model.Annotation;
import org.hamcrest.generator.qdox.model.JavaClass;
import org.hamcrest.generator.qdox.model.JavaField;
import org.hamcrest.generator.qdox.model.annotation.AnnotationAdd;
import org.hamcrest.generator.qdox.model.annotation.AnnotationAnd;
import org.hamcrest.generator.qdox.model.annotation.AnnotationCast;
import org.hamcrest.generator.qdox.model.annotation.AnnotationConstant;
import org.hamcrest.generator.qdox.model.annotation.AnnotationDivide;
import org.hamcrest.generator.qdox.model.annotation.AnnotationEquals;
import org.hamcrest.generator.qdox.model.annotation.AnnotationExclusiveOr;
import org.hamcrest.generator.qdox.model.annotation.AnnotationFieldRef;
import org.hamcrest.generator.qdox.model.annotation.AnnotationGreaterEquals;
import org.hamcrest.generator.qdox.model.annotation.AnnotationGreaterThan;
import org.hamcrest.generator.qdox.model.annotation.AnnotationLessEquals;
import org.hamcrest.generator.qdox.model.annotation.AnnotationLessThan;
import org.hamcrest.generator.qdox.model.annotation.AnnotationLogicalAnd;
import org.hamcrest.generator.qdox.model.annotation.AnnotationLogicalNot;
import org.hamcrest.generator.qdox.model.annotation.AnnotationLogicalOr;
import org.hamcrest.generator.qdox.model.annotation.AnnotationMinusSign;
import org.hamcrest.generator.qdox.model.annotation.AnnotationMultiply;
import org.hamcrest.generator.qdox.model.annotation.AnnotationNot;
import org.hamcrest.generator.qdox.model.annotation.AnnotationNotEquals;
import org.hamcrest.generator.qdox.model.annotation.AnnotationOr;
import org.hamcrest.generator.qdox.model.annotation.AnnotationParenExpression;
import org.hamcrest.generator.qdox.model.annotation.AnnotationPlusSign;
import org.hamcrest.generator.qdox.model.annotation.AnnotationQuery;
import org.hamcrest.generator.qdox.model.annotation.AnnotationRemainder;
import org.hamcrest.generator.qdox.model.annotation.AnnotationShiftLeft;
import org.hamcrest.generator.qdox.model.annotation.AnnotationShiftRight;
import org.hamcrest.generator.qdox.model.annotation.AnnotationSubtract;
import org.hamcrest.generator.qdox.model.annotation.AnnotationTypeRef;
import org.hamcrest.generator.qdox.model.annotation.AnnotationUnsignedShiftRight;
import org.hamcrest.generator.qdox.model.annotation.AnnotationValue;
import org.hamcrest.generator.qdox.model.annotation.AnnotationValueList;
import org.hamcrest.generator.qdox.model.annotation.AnnotationVisitor;

public abstract class EvaluatingVisitor
implements AnnotationVisitor {
    public Object getValue(Annotation annotation, String string) {
        Object object = null;
        AnnotationValue annotationValue = annotation.getProperty(string);
        if (annotationValue != null) {
            object = annotationValue.accept(this);
        }
        return object;
    }

    public List getListValue(Annotation annotation, String string) {
        Object object = this.getValue(annotation, string);
        List<Object> list = null;
        if (object != null) {
            list = object instanceof List ? (List<Object>)object : Collections.singletonList(object);
        }
        return list;
    }

    protected static Class resultType(Object object, Object object2) {
        Class<Object> clazz = Void.TYPE;
        if (object instanceof String || object2 instanceof String) {
            clazz = String.class;
        } else if (object instanceof Number && object2 instanceof Number) {
            clazz = object instanceof Double || object2 instanceof Double ? Double.class : (object instanceof Float || object2 instanceof Float ? Float.class : (object instanceof Long || object2 instanceof Long ? Long.class : Integer.class));
        }
        return clazz;
    }

    protected static Class numericResultType(Object object, Object object2) {
        Class<Object> clazz = Void.TYPE;
        if (object instanceof Number && object2 instanceof Number) {
            if (object instanceof Long || object2 instanceof Long) {
                clazz = Long.class;
            } else if (object instanceof Integer || object2 instanceof Integer) {
                clazz = Integer.class;
            }
        }
        return clazz;
    }

    protected static Class unaryNumericResultType(Object clazz) {
        Class<Object> clazz2 = Void.TYPE;
        if (clazz instanceof Byte || clazz instanceof Short || clazz instanceof Character || clazz instanceof Integer) {
            clazz2 = Integer.class;
        } else if (clazz instanceof Long) {
            clazz = Long.class;
        }
        return clazz2;
    }

    protected static Class unaryResultType(Object clazz) {
        Class clazz2 = EvaluatingVisitor.unaryNumericResultType(clazz);
        if (clazz2 == Void.TYPE) {
            if (clazz instanceof Float) {
                clazz = Float.class;
            } else if (clazz instanceof Double) {
                clazz = Double.class;
            }
        }
        return clazz2;
    }

    @Override
    public Object visitAnnotation(Annotation annotation) {
        throw new UnsupportedOperationException("Illegal annotation value '" + annotation + "'.");
    }

    @Override
    public Object visitAnnotationAdd(AnnotationAdd annotationAdd) {
        Object object;
        Object object2;
        Object object3 = annotationAdd.getLeft().accept(this);
        Class clazz = EvaluatingVisitor.resultType(object3, object2 = annotationAdd.getRight().accept(this));
        if (clazz == String.class) {
            object = object3.toString() + object2.toString();
        } else if (clazz == Double.class) {
            object = new Double(((Number)object3).doubleValue() + ((Number)object2).doubleValue());
        } else if (clazz == Float.class) {
            object = new Float(((Number)object3).floatValue() + ((Number)object2).floatValue());
        } else if (clazz == Long.class) {
            object = new Long(((Number)object3).longValue() + ((Number)object2).longValue());
        } else if (clazz == Integer.class) {
            object = new Integer(((Number)object3).intValue() + ((Number)object2).intValue());
        } else {
            throw new IllegalArgumentException("Cannot evaluate '" + annotationAdd + "'.");
        }
        return object;
    }

    @Override
    public Object visitAnnotationConstant(AnnotationConstant annotationConstant) {
        return annotationConstant.getValue();
    }

    @Override
    public Object visitAnnotationDivide(AnnotationDivide annotationDivide) {
        Number number;
        Object object;
        Object object2 = annotationDivide.getLeft().accept(this);
        Class clazz = EvaluatingVisitor.resultType(object2, object = annotationDivide.getRight().accept(this));
        if (clazz == Double.class) {
            number = new Double(((Number)object2).doubleValue() / ((Number)object).doubleValue());
        } else if (clazz == Float.class) {
            number = new Float(((Number)object2).floatValue() / ((Number)object).floatValue());
        } else if (clazz == Long.class) {
            number = new Long(((Number)object2).longValue() / ((Number)object).longValue());
        } else if (clazz == Integer.class) {
            number = new Integer(((Number)object2).intValue() / ((Number)object).intValue());
        } else {
            throw new IllegalArgumentException("Cannot evaluate '" + annotationDivide + "'.");
        }
        return number;
    }

    @Override
    public Object visitAnnotationFieldRef(AnnotationFieldRef annotationFieldRef) {
        JavaField javaField = annotationFieldRef.getField();
        if (javaField == null) {
            throw new IllegalArgumentException("Cannot resolve field reference '" + annotationFieldRef + "'.");
        }
        if (!javaField.isFinal() || !javaField.isStatic()) {
            throw new IllegalArgumentException("Field reference '" + annotationFieldRef + "' must be static and final.");
        }
        Object object = this.getFieldReferenceValue(javaField);
        return object;
    }

    protected abstract Object getFieldReferenceValue(JavaField var1);

    @Override
    public Object visitAnnotationGreaterThan(AnnotationGreaterThan annotationGreaterThan) {
        boolean bl;
        Object object;
        Object object2 = annotationGreaterThan.getLeft().accept(this);
        Class clazz = EvaluatingVisitor.resultType(object2, object = annotationGreaterThan.getRight().accept(this));
        if (clazz == Double.class) {
            bl = ((Number)object2).doubleValue() > ((Number)object).doubleValue();
        } else if (clazz == Float.class) {
            bl = ((Number)object2).floatValue() > ((Number)object).floatValue();
        } else if (clazz == Long.class) {
            bl = ((Number)object2).longValue() > ((Number)object).longValue();
        } else if (clazz == Integer.class) {
            bl = ((Number)object2).intValue() > ((Number)object).intValue();
        } else {
            throw new IllegalArgumentException("Cannot evaluate '" + annotationGreaterThan + "'.");
        }
        return bl ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public Object visitAnnotationLessThan(AnnotationLessThan annotationLessThan) {
        boolean bl;
        Object object;
        Object object2 = annotationLessThan.getLeft().accept(this);
        Class clazz = EvaluatingVisitor.resultType(object2, object = annotationLessThan.getRight().accept(this));
        if (clazz == Double.class) {
            bl = ((Number)object2).doubleValue() < ((Number)object).doubleValue();
        } else if (clazz == Float.class) {
            bl = ((Number)object2).floatValue() < ((Number)object).floatValue();
        } else if (clazz == Long.class) {
            bl = ((Number)object2).longValue() < ((Number)object).longValue();
        } else if (clazz == Integer.class) {
            bl = ((Number)object2).intValue() < ((Number)object).intValue();
        } else {
            throw new IllegalArgumentException("Cannot evaluate '" + annotationLessThan + "'.");
        }
        return bl ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public Object visitAnnotationMultiply(AnnotationMultiply annotationMultiply) {
        Number number;
        Object object;
        Object object2 = annotationMultiply.getLeft().accept(this);
        Class clazz = EvaluatingVisitor.resultType(object2, object = annotationMultiply.getRight().accept(this));
        if (clazz == Double.class) {
            number = new Double(((Number)object2).doubleValue() * ((Number)object).doubleValue());
        } else if (clazz == Float.class) {
            number = new Float(((Number)object2).floatValue() * ((Number)object).floatValue());
        } else if (clazz == Long.class) {
            number = new Long(((Number)object2).longValue() * ((Number)object).longValue());
        } else if (clazz == Integer.class) {
            number = new Integer(((Number)object2).intValue() * ((Number)object).intValue());
        } else {
            throw new IllegalArgumentException("Cannot evaluate '" + annotationMultiply + "'.");
        }
        return number;
    }

    @Override
    public Object visitAnnotationParenExpression(AnnotationParenExpression annotationParenExpression) {
        return annotationParenExpression.getValue().accept(this);
    }

    @Override
    public Object visitAnnotationSubtract(AnnotationSubtract annotationSubtract) {
        Number number;
        Object object;
        Object object2 = annotationSubtract.getLeft().accept(this);
        Class clazz = EvaluatingVisitor.resultType(object2, object = annotationSubtract.getRight().accept(this));
        if (clazz == Double.class) {
            number = new Double(((Number)object2).doubleValue() - ((Number)object).doubleValue());
        } else if (clazz == Float.class) {
            number = new Float(((Number)object2).floatValue() - ((Number)object).floatValue());
        } else if (clazz == Long.class) {
            number = new Long(((Number)object2).longValue() - ((Number)object).longValue());
        } else if (clazz == Integer.class) {
            number = new Integer(((Number)object2).intValue() - ((Number)object).intValue());
        } else {
            throw new IllegalArgumentException("Cannot evaluate '" + annotationSubtract + "'.");
        }
        return number;
    }

    @Override
    public Object visitAnnotationTypeRef(AnnotationTypeRef annotationTypeRef) {
        JavaClass javaClass = annotationTypeRef.getType().getJavaClass();
        return javaClass;
    }

    @Override
    public Object visitAnnotationValueList(AnnotationValueList annotationValueList) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ListIterator listIterator = annotationValueList.getValueList().listIterator();
        while (listIterator.hasNext()) {
            AnnotationValue annotationValue = (AnnotationValue)listIterator.next();
            Object object = annotationValue.accept(this);
            arrayList.add(object);
        }
        return arrayList;
    }

    @Override
    public Object visitAnnotationAnd(AnnotationAnd annotationAnd) {
        Number number;
        Object object;
        Object object2 = annotationAnd.getLeft().accept(this);
        Class clazz = EvaluatingVisitor.numericResultType(object2, object = annotationAnd.getRight().accept(this));
        if (clazz == Long.class) {
            number = new Long(((Number)object2).longValue() & ((Number)object).longValue());
        } else if (clazz == Integer.class) {
            number = new Integer(((Number)object2).intValue() & ((Number)object).intValue());
        } else {
            throw new IllegalArgumentException("Cannot evaluate '" + annotationAnd + "'.");
        }
        return number;
    }

    @Override
    public Object visitAnnotationGreaterEquals(AnnotationGreaterEquals annotationGreaterEquals) {
        boolean bl;
        Object object;
        Object object2 = annotationGreaterEquals.getLeft().accept(this);
        Class clazz = EvaluatingVisitor.resultType(object2, object = annotationGreaterEquals.getRight().accept(this));
        if (clazz == Double.class) {
            bl = ((Number)object2).doubleValue() >= ((Number)object).doubleValue();
        } else if (clazz == Float.class) {
            bl = ((Number)object2).floatValue() >= ((Number)object).floatValue();
        } else if (clazz == Long.class) {
            bl = ((Number)object2).longValue() >= ((Number)object).longValue();
        } else if (clazz == Integer.class) {
            bl = ((Number)object2).intValue() >= ((Number)object).intValue();
        } else {
            throw new IllegalArgumentException("Cannot evaluate '" + annotationGreaterEquals + "'.");
        }
        return bl ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public Object visitAnnotationLessEquals(AnnotationLessEquals annotationLessEquals) {
        boolean bl;
        Object object;
        Object object2 = annotationLessEquals.getLeft().accept(this);
        Class clazz = EvaluatingVisitor.resultType(object2, object = annotationLessEquals.getRight().accept(this));
        if (clazz == Double.class) {
            bl = ((Number)object2).doubleValue() <= ((Number)object).doubleValue();
        } else if (clazz == Float.class) {
            bl = ((Number)object2).floatValue() <= ((Number)object).floatValue();
        } else if (clazz == Long.class) {
            bl = ((Number)object2).longValue() <= ((Number)object).longValue();
        } else if (clazz == Integer.class) {
            bl = ((Number)object2).intValue() <= ((Number)object).intValue();
        } else {
            throw new IllegalArgumentException("Cannot evaluate '" + annotationLessEquals + "'.");
        }
        return bl ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public Object visitAnnotationLogicalAnd(AnnotationLogicalAnd annotationLogicalAnd) {
        Object object = annotationLogicalAnd.getLeft().accept(this);
        Object object2 = annotationLogicalAnd.getRight().accept(this);
        if (!(object instanceof Boolean) || !(object2 instanceof Boolean)) {
            throw new IllegalArgumentException("Cannot evaluate '" + annotationLogicalAnd + "'.");
        }
        boolean bl = (Boolean)object != false && (Boolean)object2 != false;
        return bl ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public Object visitAnnotationLogicalNot(AnnotationLogicalNot annotationLogicalNot) {
        Object object = annotationLogicalNot.getValue().accept(this);
        if (!(object instanceof Boolean)) {
            throw new IllegalArgumentException("Cannot evaluate '" + annotationLogicalNot + "'.");
        }
        boolean bl = (Boolean)object == false;
        return bl ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public Object visitAnnotationLogicalOr(AnnotationLogicalOr annotationLogicalOr) {
        Object object = annotationLogicalOr.getLeft().accept(this);
        Object object2 = annotationLogicalOr.getRight().accept(this);
        if (!(object instanceof Boolean) || !(object2 instanceof Boolean)) {
            throw new IllegalArgumentException("Cannot evaluate '" + annotationLogicalOr + "'.");
        }
        boolean bl = (Boolean)object != false || (Boolean)object2 != false;
        return bl ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public Object visitAnnotationMinusSign(AnnotationMinusSign annotationMinusSign) {
        Number number;
        Object object = annotationMinusSign.getValue().accept(this);
        Class clazz = EvaluatingVisitor.unaryResultType(object);
        if (clazz == Integer.class) {
            number = new Integer(-((Integer)object).intValue());
        } else if (clazz == Long.class) {
            number = new Long(-((Long)object).longValue());
        } else if (clazz == Float.class) {
            number = new Float(-((Float)object).floatValue());
        } else if (clazz == Double.class) {
            number = new Double(-((Double)object).intValue());
        } else {
            throw new IllegalArgumentException("Cannot evaluate '" + annotationMinusSign + "'.");
        }
        return number;
    }

    @Override
    public Object visitAnnotationNot(AnnotationNot annotationNot) {
        Number number;
        Object object = annotationNot.getValue().accept(this);
        Class clazz = EvaluatingVisitor.unaryNumericResultType(object);
        if (clazz == Long.class) {
            number = new Long((long)((Long)object ^ 0xFFFFFFFFFFFFFFFFL));
        } else if (clazz == Integer.class) {
            number = new Integer(~((Integer)object).intValue());
        } else {
            throw new IllegalArgumentException("Cannot evaluate '" + annotationNot + "'.");
        }
        return number;
    }

    @Override
    public Object visitAnnotationOr(AnnotationOr annotationOr) {
        Number number;
        Object object;
        Object object2 = annotationOr.getLeft().accept(this);
        Class clazz = EvaluatingVisitor.numericResultType(object2, object = annotationOr.getRight().accept(this));
        if (clazz == Long.class) {
            number = new Long(((Number)object2).longValue() | ((Number)object).longValue());
        } else if (clazz == Integer.class) {
            number = new Integer(((Number)object2).intValue() | ((Number)object).intValue());
        } else {
            throw new IllegalArgumentException("Cannot evaluate '" + annotationOr + "'.");
        }
        return number;
    }

    @Override
    public Object visitAnnotationPlusSign(AnnotationPlusSign annotationPlusSign) {
        Object object = annotationPlusSign.getValue().accept(this);
        if (!(object instanceof Number)) {
            throw new IllegalArgumentException("Cannot evaluate '" + annotationPlusSign + "'.");
        }
        Object object2 = object;
        return object2;
    }

    @Override
    public Object visitAnnotationRemainder(AnnotationRemainder annotationRemainder) {
        Number number;
        Object object;
        Object object2 = annotationRemainder.getLeft().accept(this);
        Class clazz = EvaluatingVisitor.resultType(object2, object = annotationRemainder.getRight().accept(this));
        if (clazz == Double.class) {
            number = new Double(((Number)object2).doubleValue() % ((Number)object).doubleValue());
        } else if (clazz == Float.class) {
            number = new Float(((Number)object2).floatValue() % ((Number)object).floatValue());
        } else if (clazz == Long.class) {
            number = new Long(((Number)object2).longValue() % ((Number)object).longValue());
        } else if (clazz == Integer.class) {
            number = new Integer(((Number)object2).intValue() % ((Number)object).intValue());
        } else {
            throw new IllegalArgumentException("Cannot evaluate '" + annotationRemainder + "'.");
        }
        return number;
    }

    @Override
    public Object visitAnnotationShiftLeft(AnnotationShiftLeft annotationShiftLeft) {
        Number number;
        Object object;
        Object object2 = annotationShiftLeft.getLeft().accept(this);
        Class clazz = EvaluatingVisitor.numericResultType(object2, object = annotationShiftLeft.getRight().accept(this));
        if (clazz == Long.class) {
            number = new Long(((Number)object2).longValue() << (int)((Number)object).longValue());
        } else if (clazz == Integer.class) {
            number = new Integer(((Number)object2).intValue() << ((Number)object).intValue());
        } else {
            throw new IllegalArgumentException("Cannot evaluate '" + annotationShiftLeft + "'.");
        }
        return number;
    }

    @Override
    public Object visitAnnotationShiftRight(AnnotationShiftRight annotationShiftRight) {
        Number number;
        Object object;
        Object object2 = annotationShiftRight.getLeft().accept(this);
        Class clazz = EvaluatingVisitor.numericResultType(object2, object = annotationShiftRight.getRight().accept(this));
        if (clazz == Long.class) {
            number = new Long(((Number)object2).longValue() >> (int)((Number)object).longValue());
        } else if (clazz == Integer.class) {
            number = new Integer(((Number)object2).intValue() >> ((Number)object).intValue());
        } else {
            throw new IllegalArgumentException("Cannot evaluate '" + annotationShiftRight + "'.");
        }
        return number;
    }

    @Override
    public Object visitAnnotationUnsignedShiftRight(AnnotationUnsignedShiftRight annotationUnsignedShiftRight) {
        Number number;
        Object object;
        Object object2 = annotationUnsignedShiftRight.getLeft().accept(this);
        Class clazz = EvaluatingVisitor.numericResultType(object2, object = annotationUnsignedShiftRight.getRight().accept(this));
        if (clazz == Long.class) {
            number = new Long(((Number)object2).longValue() >>> (int)((Number)object).longValue());
        } else if (clazz == Integer.class) {
            number = new Integer(((Number)object2).intValue() >>> ((Number)object).intValue());
        } else {
            throw new IllegalArgumentException("Cannot evaluate '" + annotationUnsignedShiftRight + "'.");
        }
        return number;
    }

    @Override
    public Object visitAnnotationEquals(AnnotationEquals annotationEquals) {
        Object object;
        Object object2 = annotationEquals.getLeft().accept(this);
        Class clazz = EvaluatingVisitor.resultType(object2, object = annotationEquals.getRight().accept(this));
        boolean bl = clazz == Double.class ? ((Number)object2).doubleValue() == ((Number)object).doubleValue() : (clazz == Float.class ? ((Number)object2).floatValue() == ((Number)object).floatValue() : (clazz == Long.class ? ((Number)object2).longValue() == ((Number)object).longValue() : (clazz == Integer.class ? ((Number)object2).intValue() == ((Number)object).intValue() : object2 == object)));
        return bl ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public Object visitAnnotationExclusiveOr(AnnotationExclusiveOr annotationExclusiveOr) {
        Number number;
        Object object;
        Object object2 = annotationExclusiveOr.getLeft().accept(this);
        Class clazz = EvaluatingVisitor.numericResultType(object2, object = annotationExclusiveOr.getRight().accept(this));
        if (clazz == Long.class) {
            number = new Long(((Number)object2).longValue() ^ ((Number)object).longValue());
        } else if (clazz == Integer.class) {
            number = new Integer(((Number)object2).intValue() ^ ((Number)object).intValue());
        } else {
            throw new IllegalArgumentException("Cannot evaluate '" + annotationExclusiveOr + "'.");
        }
        return number;
    }

    @Override
    public Object visitAnnotationNotEquals(AnnotationNotEquals annotationNotEquals) {
        Object object;
        Object object2 = annotationNotEquals.getLeft().accept(this);
        Class clazz = EvaluatingVisitor.resultType(object2, object = annotationNotEquals.getRight().accept(this));
        boolean bl = clazz == Double.class ? ((Number)object2).doubleValue() != ((Number)object).doubleValue() : (clazz == Float.class ? ((Number)object2).floatValue() != ((Number)object).floatValue() : (clazz == Long.class ? ((Number)object2).longValue() != ((Number)object).longValue() : (clazz == Integer.class ? ((Number)object2).intValue() != ((Number)object).intValue() : object2 == object)));
        return bl ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public Object visitAnnotationQuery(AnnotationQuery annotationQuery) {
        Object object = annotationQuery.getCondition().accept(this);
        if (object == null || !(object instanceof Boolean)) {
            throw new IllegalArgumentException("Cannot evaluate '" + annotationQuery + "'.");
        }
        AnnotationValue annotationValue = (Boolean)object != false ? annotationQuery.getTrueExpression() : annotationQuery.getFalseExpression();
        return annotationValue.accept(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object visitAnnotationCast(AnnotationCast annotationCast) {
        Object object = annotationCast.getValue().accept(this);
        String string = annotationCast.getType().getJavaClass().getFullyQualifiedName();
        if (object instanceof Number) {
            Number number = (Number)object;
            if (string.equals("byte")) {
                return new Byte(number.byteValue());
            }
            if (string.equals("char")) {
                return new Character((char)number.intValue());
            }
            if (string.equals("short")) {
                return new Short(number.shortValue());
            }
            if (string.equals("int")) {
                return new Integer(number.intValue());
            }
            if (string.equals("long")) {
                return new Long(number.longValue());
            }
            if (string.equals("float")) {
                return new Float(number.floatValue());
            }
            if (!string.equals("double")) throw new IllegalArgumentException("Cannot evaluate '" + annotationCast + "'.");
            return new Double(number.doubleValue());
        }
        if (!(object instanceof String)) throw new IllegalArgumentException("Cannot evaluate '" + annotationCast + "'.");
        if (!string.equals("java.lang.String")) throw new IllegalArgumentException("Cannot evaluate '" + annotationCast + "'.");
        return object;
    }
}

