/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.telnet;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.net.telnet.TelnetClient;

final class TelnetOutputStream
extends OutputStream {
    private final TelnetClient __client;
    private final boolean __convertCRtoCRLF = true;
    private boolean __lastWasCR = false;

    TelnetOutputStream(TelnetClient telnetClient) {
        this.__client = telnetClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int n) throws IOException {
        TelnetClient telnetClient = this.__client;
        synchronized (telnetClient) {
            n &= 0xFF;
            if (this.__client._requestedWont(0)) {
                if (this.__lastWasCR) {
                    this.__client._sendByte(10);
                    if (n == 10) {
                        this.__lastWasCR = false;
                        return;
                    }
                }
                switch (n) {
                    case 13: {
                        this.__client._sendByte(13);
                        this.__lastWasCR = true;
                        break;
                    }
                    case 10: {
                        if (!this.__lastWasCR) {
                            this.__client._sendByte(13);
                        }
                        this.__client._sendByte(n);
                        this.__lastWasCR = false;
                        break;
                    }
                    case 255: {
                        this.__client._sendByte(255);
                        this.__client._sendByte(255);
                        this.__lastWasCR = false;
                        break;
                    }
                    default: {
                        this.__client._sendByte(n);
                        this.__lastWasCR = false;
                        break;
                    }
                }
            } else if (n == 255) {
                this.__client._sendByte(n);
                this.__client._sendByte(255);
            } else {
                this.__client._sendByte(n);
            }
        }
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        TelnetClient telnetClient = this.__client;
        synchronized (telnetClient) {
            while (n2-- > 0) {
                this.write(byArray[n++]);
            }
        }
    }

    @Override
    public void flush() throws IOException {
        this.__client._flushOutputStream();
    }

    @Override
    public void close() throws IOException {
        this.__client._closeOutputStream();
    }
}

