/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.exec;

import org.apache.commons.exec.TimeoutObserver;
import org.apache.commons.exec.Watchdog;
import org.apache.commons.exec.util.DebugUtils;

public class ExecuteWatchdog
implements TimeoutObserver {
    public static final long INFINITE_TIMEOUT = -1L;
    private Process process;
    private final boolean hasWatchdog;
    private boolean watch = false;
    private Exception caught;
    private boolean killedProcess = false;
    private final Watchdog watchdog;
    private volatile boolean processStarted;

    public ExecuteWatchdog(long l) {
        this.hasWatchdog = l != -1L;
        this.processStarted = false;
        if (this.hasWatchdog) {
            this.watchdog = new Watchdog(l);
            this.watchdog.addTimeoutObserver(this);
        } else {
            this.watchdog = null;
        }
    }

    public synchronized void start(Process process) {
        if (process == null) {
            throw new NullPointerException("process is null.");
        }
        if (this.process != null) {
            throw new IllegalStateException("Already running.");
        }
        this.caught = null;
        this.killedProcess = false;
        this.watch = true;
        this.process = process;
        this.processStarted = true;
        this.notifyAll();
        if (this.hasWatchdog) {
            this.watchdog.start();
        }
    }

    public synchronized void stop() {
        if (this.hasWatchdog) {
            this.watchdog.stop();
        }
        this.watch = false;
        this.process = null;
    }

    public synchronized void destroyProcess() {
        this.ensureStarted();
        this.timeoutOccured(null);
        this.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void timeoutOccured(Watchdog watchdog) {
        try {
            try {
                if (this.process != null) {
                    this.process.exitValue();
                }
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                if (this.watch) {
                    this.killedProcess = true;
                    this.process.destroy();
                }
            }
        }
        catch (Exception exception) {
            this.caught = exception;
            DebugUtils.handleException("Getting the exit value of the process failed", exception);
        }
        finally {
            this.cleanUp();
        }
    }

    public synchronized void checkException() throws Exception {
        if (this.caught != null) {
            throw this.caught;
        }
    }

    public synchronized boolean isWatching() {
        this.ensureStarted();
        return this.watch;
    }

    public synchronized boolean killedProcess() {
        return this.killedProcess;
    }

    protected synchronized void cleanUp() {
        this.watch = false;
        this.process = null;
    }

    void setProcessNotStarted() {
        this.processStarted = false;
    }

    private void ensureStarted() {
        while (!this.processStarted) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException.getMessage());
            }
        }
    }
}

