/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorOutputStream;
import org.apache.commons.compress.compressors.CompressorStreamProvider;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.apache.commons.compress.compressors.deflate.DeflateCompressorInputStream;
import org.apache.commons.compress.compressors.deflate.DeflateCompressorOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.compress.compressors.lzma.LZMACompressorInputStream;
import org.apache.commons.compress.compressors.lzma.LZMACompressorOutputStream;
import org.apache.commons.compress.compressors.lzma.LZMAUtils;
import org.apache.commons.compress.compressors.pack200.Pack200CompressorInputStream;
import org.apache.commons.compress.compressors.pack200.Pack200CompressorOutputStream;
import org.apache.commons.compress.compressors.snappy.FramedSnappyCompressorInputStream;
import org.apache.commons.compress.compressors.snappy.SnappyCompressorInputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorInputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorOutputStream;
import org.apache.commons.compress.compressors.xz.XZUtils;
import org.apache.commons.compress.compressors.z.ZCompressorInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.compress.utils.ServiceLoaderIterator;
import org.apache.commons.compress.utils.Sets;

public class CompressorStreamFactory
implements CompressorStreamProvider {
    private static final CompressorStreamFactory SINGLETON = new CompressorStreamFactory();
    public static final String BZIP2 = "bzip2";
    public static final String GZIP = "gz";
    public static final String PACK200 = "pack200";
    public static final String XZ = "xz";
    public static final String LZMA = "lzma";
    public static final String SNAPPY_FRAMED = "snappy-framed";
    public static final String SNAPPY_RAW = "snappy-raw";
    public static final String Z = "z";
    public static final String DEFLATE = "deflate";
    private final Boolean decompressUntilEOF;
    private SortedMap<String, CompressorStreamProvider> compressorInputStreamProviders;
    private SortedMap<String, CompressorStreamProvider> compressorOutputStreamProviders;
    private volatile boolean decompressConcatenated = false;

    public static SortedMap<String, CompressorStreamProvider> findAvailableCompressorInputStreamProviders() {
        return AccessController.doPrivileged(new PrivilegedAction<SortedMap<String, CompressorStreamProvider>>(){

            @Override
            public SortedMap<String, CompressorStreamProvider> run() {
                TreeMap<String, CompressorStreamProvider> treeMap = new TreeMap<String, CompressorStreamProvider>();
                CompressorStreamFactory.putAll(SINGLETON.getInputStreamCompressorNames(), SINGLETON, treeMap);
                for (CompressorStreamProvider compressorStreamProvider : CompressorStreamFactory.findCompressorStreamProviders()) {
                    CompressorStreamFactory.putAll(compressorStreamProvider.getInputStreamCompressorNames(), compressorStreamProvider, treeMap);
                }
                return treeMap;
            }
        });
    }

    public static SortedMap<String, CompressorStreamProvider> findAvailableCompressorOutputStreamProviders() {
        return AccessController.doPrivileged(new PrivilegedAction<SortedMap<String, CompressorStreamProvider>>(){

            @Override
            public SortedMap<String, CompressorStreamProvider> run() {
                TreeMap<String, CompressorStreamProvider> treeMap = new TreeMap<String, CompressorStreamProvider>();
                CompressorStreamFactory.putAll(SINGLETON.getOutputStreamCompressorNames(), SINGLETON, treeMap);
                for (CompressorStreamProvider compressorStreamProvider : CompressorStreamFactory.findCompressorStreamProviders()) {
                    CompressorStreamFactory.putAll(compressorStreamProvider.getOutputStreamCompressorNames(), compressorStreamProvider, treeMap);
                }
                return treeMap;
            }
        });
    }

    private static ArrayList<CompressorStreamProvider> findCompressorStreamProviders() {
        return Lists.newArrayList(CompressorStreamFactory.serviceLoaderIterator());
    }

    public static String getBzip2() {
        return BZIP2;
    }

    public static String getDeflate() {
        return DEFLATE;
    }

    public static String getGzip() {
        return GZIP;
    }

    public static String getLzma() {
        return LZMA;
    }

    public static String getPack200() {
        return PACK200;
    }

    public static CompressorStreamFactory getSingleton() {
        return SINGLETON;
    }

    public static String getSnappyFramed() {
        return SNAPPY_FRAMED;
    }

    public static String getSnappyRaw() {
        return SNAPPY_RAW;
    }

    public static String getXz() {
        return XZ;
    }

    public static String getZ() {
        return Z;
    }

    static void putAll(Set<String> set, CompressorStreamProvider compressorStreamProvider, TreeMap<String, CompressorStreamProvider> treeMap) {
        for (String string : set) {
            treeMap.put(CompressorStreamFactory.toKey(string), compressorStreamProvider);
        }
    }

    private static Iterator<CompressorStreamProvider> serviceLoaderIterator() {
        return new ServiceLoaderIterator<CompressorStreamProvider>(CompressorStreamProvider.class);
    }

    private static String toKey(String string) {
        return string.toUpperCase(Locale.ROOT);
    }

    public CompressorStreamFactory() {
        this.decompressUntilEOF = null;
    }

    public CompressorStreamFactory(boolean bl) {
        this.decompressUntilEOF = bl;
        this.decompressConcatenated = bl;
    }

    public CompressorInputStream createCompressorInputStream(InputStream inputStream) throws CompressorException {
        if (inputStream == null) {
            throw new IllegalArgumentException("Stream must not be null.");
        }
        if (!inputStream.markSupported()) {
            throw new IllegalArgumentException("Mark is not supported.");
        }
        byte[] byArray = new byte[12];
        inputStream.mark(byArray.length);
        try {
            int n = IOUtils.readFully(inputStream, byArray);
            inputStream.reset();
            if (BZip2CompressorInputStream.matches(byArray, n)) {
                return new BZip2CompressorInputStream(inputStream, this.decompressConcatenated);
            }
            if (GzipCompressorInputStream.matches(byArray, n)) {
                return new GzipCompressorInputStream(inputStream, this.decompressConcatenated);
            }
            if (Pack200CompressorInputStream.matches(byArray, n)) {
                return new Pack200CompressorInputStream(inputStream);
            }
            if (FramedSnappyCompressorInputStream.matches(byArray, n)) {
                return new FramedSnappyCompressorInputStream(inputStream);
            }
            if (ZCompressorInputStream.matches(byArray, n)) {
                return new ZCompressorInputStream(inputStream);
            }
            if (DeflateCompressorInputStream.matches(byArray, n)) {
                return new DeflateCompressorInputStream(inputStream);
            }
            if (XZUtils.matches(byArray, n) && XZUtils.isXZCompressionAvailable()) {
                return new XZCompressorInputStream(inputStream, this.decompressConcatenated);
            }
            if (LZMAUtils.matches(byArray, n) && LZMAUtils.isLZMACompressionAvailable()) {
                return new LZMACompressorInputStream(inputStream);
            }
        }
        catch (IOException iOException) {
            throw new CompressorException("Failed to detect Compressor from InputStream.", iOException);
        }
        throw new CompressorException("No Compressor found for the stream signature.");
    }

    public CompressorInputStream createCompressorInputStream(String string, InputStream inputStream) throws CompressorException {
        return this.createCompressorInputStream(string, inputStream, this.decompressConcatenated);
    }

    @Override
    public CompressorInputStream createCompressorInputStream(String string, InputStream inputStream, boolean bl) throws CompressorException {
        if (string == null || inputStream == null) {
            throw new IllegalArgumentException("Compressor name and stream must not be null.");
        }
        try {
            if (GZIP.equalsIgnoreCase(string)) {
                return new GzipCompressorInputStream(inputStream, bl);
            }
            if (BZIP2.equalsIgnoreCase(string)) {
                return new BZip2CompressorInputStream(inputStream, bl);
            }
            if (XZ.equalsIgnoreCase(string)) {
                return new XZCompressorInputStream(inputStream, bl);
            }
            if (LZMA.equalsIgnoreCase(string)) {
                return new LZMACompressorInputStream(inputStream);
            }
            if (PACK200.equalsIgnoreCase(string)) {
                return new Pack200CompressorInputStream(inputStream);
            }
            if (SNAPPY_RAW.equalsIgnoreCase(string)) {
                return new SnappyCompressorInputStream(inputStream);
            }
            if (SNAPPY_FRAMED.equalsIgnoreCase(string)) {
                return new FramedSnappyCompressorInputStream(inputStream);
            }
            if (Z.equalsIgnoreCase(string)) {
                return new ZCompressorInputStream(inputStream);
            }
            if (DEFLATE.equalsIgnoreCase(string)) {
                return new DeflateCompressorInputStream(inputStream);
            }
        }
        catch (IOException iOException) {
            throw new CompressorException("Could not create CompressorInputStream.", iOException);
        }
        CompressorStreamProvider compressorStreamProvider = (CompressorStreamProvider)this.getCompressorInputStreamProviders().get(CompressorStreamFactory.toKey(string));
        if (compressorStreamProvider != null) {
            return compressorStreamProvider.createCompressorInputStream(string, inputStream, bl);
        }
        throw new CompressorException("Compressor: " + string + " not found.");
    }

    @Override
    public CompressorOutputStream createCompressorOutputStream(String string, OutputStream outputStream) throws CompressorException {
        if (string == null || outputStream == null) {
            throw new IllegalArgumentException("Compressor name and stream must not be null.");
        }
        try {
            if (GZIP.equalsIgnoreCase(string)) {
                return new GzipCompressorOutputStream(outputStream);
            }
            if (BZIP2.equalsIgnoreCase(string)) {
                return new BZip2CompressorOutputStream(outputStream);
            }
            if (XZ.equalsIgnoreCase(string)) {
                return new XZCompressorOutputStream(outputStream);
            }
            if (PACK200.equalsIgnoreCase(string)) {
                return new Pack200CompressorOutputStream(outputStream);
            }
            if (LZMA.equalsIgnoreCase(string)) {
                return new LZMACompressorOutputStream(outputStream);
            }
            if (DEFLATE.equalsIgnoreCase(string)) {
                return new DeflateCompressorOutputStream(outputStream);
            }
        }
        catch (IOException iOException) {
            throw new CompressorException("Could not create CompressorOutputStream", iOException);
        }
        CompressorStreamProvider compressorStreamProvider = (CompressorStreamProvider)this.getCompressorOutputStreamProviders().get(CompressorStreamFactory.toKey(string));
        if (compressorStreamProvider != null) {
            return compressorStreamProvider.createCompressorOutputStream(string, outputStream);
        }
        throw new CompressorException("Compressor: " + string + " not found.");
    }

    public SortedMap<String, CompressorStreamProvider> getCompressorInputStreamProviders() {
        if (this.compressorInputStreamProviders == null) {
            this.compressorInputStreamProviders = Collections.unmodifiableSortedMap(CompressorStreamFactory.findAvailableCompressorInputStreamProviders());
        }
        return this.compressorInputStreamProviders;
    }

    public SortedMap<String, CompressorStreamProvider> getCompressorOutputStreamProviders() {
        if (this.compressorOutputStreamProviders == null) {
            this.compressorOutputStreamProviders = Collections.unmodifiableSortedMap(CompressorStreamFactory.findAvailableCompressorOutputStreamProviders());
        }
        return this.compressorOutputStreamProviders;
    }

    boolean getDecompressConcatenated() {
        return this.decompressConcatenated;
    }

    public Boolean getDecompressUntilEOF() {
        return this.decompressUntilEOF;
    }

    @Override
    public Set<String> getInputStreamCompressorNames() {
        return Sets.newHashSet(GZIP, BZIP2, XZ, LZMA, PACK200, SNAPPY_RAW, SNAPPY_FRAMED, Z, DEFLATE);
    }

    @Override
    public Set<String> getOutputStreamCompressorNames() {
        return Sets.newHashSet(GZIP, BZIP2, XZ, LZMA, PACK200, DEFLATE);
    }

    @Deprecated
    public void setDecompressConcatenated(boolean bl) {
        if (this.decompressUntilEOF != null) {
            throw new IllegalStateException("Cannot override the setting defined by the constructor");
        }
        this.decompressConcatenated = bl;
    }
}

