/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import org.apache.commons.compress.archivers.zip.PKWareExtraHeader;
import org.apache.commons.compress.archivers.zip.ZipLong;
import org.apache.commons.compress.archivers.zip.ZipShort;

public class X0017_StrongEncryptionHeader
extends PKWareExtraHeader {
    private int format;
    private PKWareExtraHeader.EncryptionAlgorithm algId;
    private int bitlen;
    private int flags;
    private long rcount;
    private PKWareExtraHeader.HashAlgorithm hashAlg;
    private int hashSize;
    private byte[] ivData;
    private byte[] erdData;
    private byte[] recipientKeyHash;
    private byte[] keyBlob;
    private byte[] vData;
    private byte[] vCRC32;

    public X0017_StrongEncryptionHeader() {
        super(new ZipShort(23));
    }

    public long getRecordCount() {
        return this.rcount;
    }

    public PKWareExtraHeader.HashAlgorithm getHashAlgorithm() {
        return this.hashAlg;
    }

    public PKWareExtraHeader.EncryptionAlgorithm getEncryptionAlgorithm() {
        return this.algId;
    }

    public void parseCentralDirectoryFormat(byte[] byArray, int n, int n2) {
        this.format = ZipShort.getValue(byArray, n);
        this.algId = PKWareExtraHeader.EncryptionAlgorithm.getAlgorithmByCode(ZipShort.getValue(byArray, n + 2));
        this.bitlen = ZipShort.getValue(byArray, n + 4);
        this.flags = ZipShort.getValue(byArray, n + 6);
        this.rcount = ZipLong.getValue(byArray, n + 8);
        if (this.rcount > 0L) {
            this.hashAlg = PKWareExtraHeader.HashAlgorithm.getAlgorithmByCode(ZipShort.getValue(byArray, n + 12));
            this.hashSize = ZipShort.getValue(byArray, n + 14);
            int n3 = 0;
            while ((long)n3 < this.rcount) {
                for (int i = 0; i < this.hashSize; ++i) {
                }
                ++n3;
            }
        }
    }

    public void parseFileFormat(byte[] byArray, int n, int n2) {
        int n3 = ZipShort.getValue(byArray, n);
        this.ivData = new byte[n3];
        System.arraycopy(byArray, n + 4, this.ivData, 0, n3);
        this.format = ZipShort.getValue(byArray, n + n3 + 6);
        this.algId = PKWareExtraHeader.EncryptionAlgorithm.getAlgorithmByCode(ZipShort.getValue(byArray, n + n3 + 8));
        this.bitlen = ZipShort.getValue(byArray, n + n3 + 10);
        this.flags = ZipShort.getValue(byArray, n + n3 + 12);
        int n4 = ZipShort.getValue(byArray, n + n3 + 14);
        this.erdData = new byte[n4];
        System.arraycopy(byArray, n + n3 + 16, this.erdData, 0, n4);
        this.rcount = ZipLong.getValue(byArray, n + n3 + 16 + n4);
        System.out.println("rcount: " + this.rcount);
        if (this.rcount == 0L) {
            int n5 = ZipShort.getValue(byArray, n + n3 + 20 + n4);
            this.vData = new byte[n5 - 4];
            this.vCRC32 = new byte[4];
            System.arraycopy(byArray, n + n3 + 22 + n4, this.vData, 0, n5 - 4);
            System.arraycopy(byArray, n + n3 + 22 + n4 + n5 - 4, this.vCRC32, 0, 4);
        } else {
            this.hashAlg = PKWareExtraHeader.HashAlgorithm.getAlgorithmByCode(ZipShort.getValue(byArray, n + n3 + 20 + n4));
            this.hashSize = ZipShort.getValue(byArray, n + n3 + 22 + n4);
            int n6 = ZipShort.getValue(byArray, n + n3 + 24 + n4);
            this.recipientKeyHash = new byte[this.hashSize];
            this.keyBlob = new byte[n6 - this.hashSize];
            System.arraycopy(byArray, n + n3 + 24 + n4, this.recipientKeyHash, 0, this.hashSize);
            System.arraycopy(byArray, n + n3 + 24 + n4 + this.hashSize, this.keyBlob, 0, n6 - this.hashSize);
            int n7 = ZipShort.getValue(byArray, n + n3 + 26 + n4 + n6);
            this.vData = new byte[n7 - 4];
            this.vCRC32 = new byte[4];
            System.arraycopy(byArray, n + n3 + 22 + n4 + n6, this.vData, 0, n7 - 4);
            System.arraycopy(byArray, n + n3 + 22 + n4 + n6 + n7 - 4, this.vCRC32, 0, 4);
        }
    }

    @Override
    public void parseFromLocalFileData(byte[] byArray, int n, int n2) {
        super.parseFromLocalFileData(byArray, n, n2);
        this.parseFileFormat(byArray, n, n2);
    }

    @Override
    public void parseFromCentralDirectoryData(byte[] byArray, int n, int n2) {
        super.parseFromCentralDirectoryData(byArray, n, n2);
        this.parseCentralDirectoryFormat(byArray, n, n2);
    }
}

