/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.runtime.html.browser;

import java.net.Authenticator;
import java.net.ProxySelector;
import java.net.URL;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import net.sourceforge.jnlp.browser.BrowserAwareProxySelector;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.runtime.html.browser.HtmlBrowserPanel;
import net.sourceforge.jnlp.runtime.html.browser.LinksPanel;
import net.sourceforge.jnlp.security.JNLPAuthenticator;
import net.sourceforge.jnlp.util.logging.JavaConsole;

public class LinkingBrowser
extends JTabbedPane {
    private final HtmlBrowserPanel browser;
    private final LinksPanel linksPanel = new LinksPanel();

    public LinkingBrowser(URL url) {
        this(url, false);
    }

    public LinkingBrowser(String url) {
        this(url, false);
    }

    public LinkingBrowser(URL url, boolean socket) {
        this.browser = new HtmlBrowserPanel(url, socket);
        this.createGui(this.browser);
    }

    public LinkingBrowser(String url, boolean socket) {
        this.browser = new HtmlBrowserPanel(url, socket);
        this.createGui(this.browser);
    }

    private void createGui(HtmlBrowserPanel lBrowser) {
        this.linksPanel.addressChangeded(lBrowser.getUrl());
        this.linksPanel.parseAndAdd(lBrowser.getCurrentSource());
        this.linksPanel.setInternalBrowser(lBrowser);
        lBrowser.addDocumentChangedListener(this.linksPanel);
        this.addTab("html", lBrowser);
        this.addTab("links", new JScrollPane(this.linksPanel));
    }

    public static void showStandAloneWindow(String url, boolean socket) {
        if (JavaConsole.canShowOnStartup(true)) {
            JavaConsole.getConsole().showConsoleLater();
        }
        Authenticator.setDefault(new JNLPAuthenticator());
        BrowserAwareProxySelector proxySelector = new BrowserAwareProxySelector(JNLPRuntime.getConfiguration());
        proxySelector.initialize();
        ProxySelector.setDefault(proxySelector);
        HtmlBrowserPanel.warn();
        JFrame f = new JFrame();
        f.add(new LinkingBrowser(url, socket));
        f.pack();
        f.setDefaultCloseOperation(3);
        f.setVisible(true);
    }

    public HtmlBrowserPanel getBrowser() {
        return this.browser;
    }

    public LinksPanel getLinksPanel() {
        return this.linksPanel;
    }
}

