/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.fcp;

import freenet.clients.fcp.FCPConnectionHandler;
import freenet.clients.fcp.FCPMessage;
import freenet.clients.fcp.MessageInvalidException;
import freenet.clients.fcp.PersistentRequestClient;
import freenet.clients.fcp.ProtocolErrorMessage;
import freenet.node.Node;
import freenet.support.SimpleFieldSet;

public class WatchGlobal
extends FCPMessage {
    final boolean enabled;
    final int verbosityMask;
    static final String NAME = "WatchGlobal";

    public WatchGlobal(SimpleFieldSet fs) throws MessageInvalidException {
        this.enabled = fs.getBoolean("Enabled", true);
        String s = fs.get("VerbosityMask");
        if (s != null) {
            try {
                this.verbosityMask = Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                throw new MessageInvalidException(6, e.toString(), null, false);
            }
        } else {
            this.verbosityMask = Integer.MAX_VALUE;
        }
    }

    @Override
    public SimpleFieldSet getFieldSet() {
        SimpleFieldSet fs = new SimpleFieldSet(true);
        fs.put("Enabled", this.enabled);
        fs.put("VerbosityMask", this.verbosityMask);
        return fs;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void run(FCPConnectionHandler handler, Node node) throws MessageInvalidException {
        PersistentRequestClient client;
        if (!handler.getRebootClient().setWatchGlobal(this.enabled, this.verbosityMask, node.clientCore.getFCPServer())) {
            ProtocolErrorMessage err = new ProtocolErrorMessage(33, false, "Persistence disabled", null, true);
            handler.outputHandler.queue(err);
        }
        if ((client = handler.getForeverClient()) != null) {
            client.setWatchGlobal(this.enabled, this.verbosityMask, handler.server);
        }
    }
}

