/*
 * Decompiled with CFR 0.152.
 */
package org.spaceroots.mantissa.utilities;

import org.spaceroots.mantissa.utilities.ArraySliceMappable;

public class MappableArray
implements ArraySliceMappable {
    double[] internalArray;

    public MappableArray(int dimension) {
        this.internalArray = new double[dimension];
        for (int i = 0; i < dimension; ++i) {
            this.internalArray[i] = 0.0;
        }
    }

    public MappableArray(double[] array) {
        this.internalArray = (double[])array.clone();
    }

    public double[] getArray() {
        return (double[])this.internalArray.clone();
    }

    @Override
    public int getStateDimension() {
        return this.internalArray.length;
    }

    @Override
    public void mapStateFromArray(int start, double[] array) {
        System.arraycopy(array, start, this.internalArray, 0, this.internalArray.length);
    }

    @Override
    public void mapStateToArray(int start, double[] array) {
        System.arraycopy(this.internalArray, 0, array, start, this.internalArray.length);
    }
}

