/*
 * Decompiled with CFR 0.152.
 */
package org.spaceroots.mantissa.fitting;

import java.io.Serializable;
import org.spaceroots.mantissa.fitting.AbstractCurveFitter;
import org.spaceroots.mantissa.functions.ExhaustedSampleException;
import org.spaceroots.mantissa.functions.FunctionException;
import org.spaceroots.mantissa.functions.vectorial.SampledFunctionIterator;
import org.spaceroots.mantissa.functions.vectorial.VectorialValuedPair;

class FFPIterator
implements SampledFunctionIterator,
Serializable {
    private AbstractCurveFitter.FitMeasurement[] measurements;
    private int nextIndex;
    private AbstractCurveFitter.FitMeasurement previous;
    private double previousY;
    private AbstractCurveFitter.FitMeasurement current;
    private double nextY;
    private AbstractCurveFitter.FitMeasurement next;
    private double currentY;
    private static final long serialVersionUID = -3187229691615380125L;

    public FFPIterator(AbstractCurveFitter.FitMeasurement[] measurements) {
        this.measurements = measurements;
        this.current = measurements[0];
        this.currentY = this.current.getMeasuredValue();
        this.next = measurements[1];
        this.nextY = this.next.getMeasuredValue();
        this.nextIndex = 2;
    }

    @Override
    public int getDimension() {
        return 2;
    }

    @Override
    public boolean hasNext() {
        return this.nextIndex < this.measurements.length;
    }

    @Override
    public VectorialValuedPair nextSamplePoint() throws ExhaustedSampleException, FunctionException {
        if (this.nextIndex >= this.measurements.length) {
            throw new ExhaustedSampleException(this.measurements.length);
        }
        this.previous = this.current;
        this.previousY = this.currentY;
        this.current = this.next;
        this.currentY = this.nextY;
        this.next = this.measurements[this.nextIndex++];
        this.nextY = this.next.getMeasuredValue();
        double[] table = new double[]{this.currentY, (this.nextY - this.previousY) / (this.next.x - this.previous.x)};
        return new VectorialValuedPair(this.current.x, table);
    }
}

