/*
 * Decompiled with CFR 0.152.
 */
package com.onionnetworks.util;

import com.onionnetworks.util.Buffer;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;

public class BlockDigestInputStream
extends FilterInputStream {
    protected MessageDigest md;
    protected int blockSize;
    protected int byteCount;
    ArrayList digestList = new ArrayList();
    Buffer[] digests = null;

    public BlockDigestInputStream(InputStream is, String algorithm, int blockSize) throws NoSuchAlgorithmException {
        super(is);
        if (blockSize <= 0) {
            throw new IllegalArgumentException("blockSize must be > 0");
        }
        this.md = MessageDigest.getInstance(algorithm);
        this.blockSize = blockSize;
    }

    @Override
    public int read() throws IOException {
        byte[] b = new byte[1];
        if (this.read(b, 0, 1) == -1) {
            return -1;
        }
        return b[0] & 0xFF;
    }

    @Override
    public long skip(long n) throws IOException {
        long l;
        int c;
        byte[] b = new byte[n < 1024L ? (int)n : 1024];
        for (l = n; l > 0L && (c = this.read(b, 0, l < 1024L ? (int)l : 1024)) != -1; l -= (long)c) {
        }
        return n - l;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int left = this.blockSize - this.byteCount;
        int c = this.in.read(b, off, len < left ? len : left);
        if (c == -1) {
            return -1;
        }
        this.md.update(b, off, c);
        this.byteCount += c;
        if (this.byteCount == this.blockSize) {
            this.digestList.add(new Buffer(this.md.digest()));
            this.byteCount = 0;
        }
        return c;
    }

    public void finish() {
        if (this.byteCount != 0) {
            this.digestList.add(new Buffer(this.md.digest()));
        }
        this.digests = this.digestList.toArray(new Buffer[0]);
        this.digestList = null;
    }

    @Override
    public void close() throws IOException {
        if (this.digestList != null) {
            this.finish();
        }
        this.in.close();
    }

    public Buffer[] getBlockDigests() {
        if (this.digests == null) {
            throw new IllegalStateException("Must call finish or close first");
        }
        return this.digests;
    }
}

