/*
 * Decompiled with CFR 0.152.
 */
package org.spaceroots.mantissa.algebra;

import org.spaceroots.mantissa.algebra.CoefficientsGenerator;
import org.spaceroots.mantissa.algebra.OrthogonalPolynomial;
import org.spaceroots.mantissa.algebra.RationalNumber;

public class Laguerre
extends OrthogonalPolynomial {
    private static final CoefficientsGenerator generator = new CoefficientsGenerator(new RationalNumber(1L), new RationalNumber(1L), new RationalNumber(-1L)){

        @Override
        public void setRecurrenceCoefficients(int k) {
            long kP1 = k + 1;
            this.setRecurrenceCoefficients(new RationalNumber(2 * k + 1, kP1), new RationalNumber(-1L, kP1), new RationalNumber(k, kP1));
        }
    };
    private static final long serialVersionUID = 3213856667479179710L;

    public Laguerre() {
        super(0, generator);
    }

    public Laguerre(int degree) {
        super(degree, generator);
    }
}

