/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import freenet.support.CurrentTimeUTC;
import freenet.support.LRUMap;

public final class LRUCache<Key extends Comparable<Key>, Value> {
    private final int mSizeLimit;
    private final long mExpirationDelay;
    private final LRUMap<Key, Entry> mCache = LRUMap.createSafeMap();

    public LRUCache(int sizeLimit) {
        this.mSizeLimit = sizeLimit;
        this.mExpirationDelay = Long.MAX_VALUE;
    }

    public LRUCache(int sizeLimit, long expirationDelay) {
        this.mSizeLimit = sizeLimit;
        this.mExpirationDelay = expirationDelay;
    }

    private void freeCapacity(int capacity) {
        assert (capacity <= this.mSizeLimit);
        int limit = this.mSizeLimit - capacity;
        while (this.mCache.size() > limit) {
            this.mCache.popValue();
        }
    }

    public void put(Key key, Value value) {
        this.mCache.push(key, new Entry(value));
        this.freeCapacity(0);
    }

    public Value get(Key key) {
        Entry entry = this.mCache.get(key);
        if (entry == null) {
            return null;
        }
        if (this.mExpirationDelay < Long.MAX_VALUE && entry.expired()) {
            this.mCache.removeKey(key);
            return null;
        }
        this.mCache.push(key, entry);
        return entry.getValue();
    }

    public void clear() {
        this.mCache.clear();
    }

    private final class Entry {
        private final Value mValue;
        private final long mExpirationDate;

        public Entry(Value myValue) {
            this.mValue = myValue;
            this.mExpirationDate = LRUCache.this.mExpirationDelay < Long.MAX_VALUE ? CurrentTimeUTC.getInMillis() + LRUCache.this.mExpirationDelay : Long.MAX_VALUE;
        }

        public boolean expired(long time) {
            return this.mExpirationDate < time;
        }

        public boolean expired() {
            return this.expired(CurrentTimeUTC.getInMillis());
        }

        public Value getValue() {
            return this.mValue;
        }
    }
}

