/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.internal;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.easymock.internal.Injection;

public class InjectionPlan {
    private final List<Field> testSubjectFields = new ArrayList<Field>(1);
    private final List<Injection> qualifiedInjections = new ArrayList<Injection>(5);
    private final List<Injection> unqualifiedInjections = new ArrayList<Injection>(5);
    private final Set<String> qualifiers = new HashSet<String>();

    public void addInjection(Injection injection) {
        String string = injection.getAnnotation().fieldName();
        if (string.length() != 0) {
            this.blockDuplicateQualifiers(string);
            this.qualifiedInjections.add(injection);
        } else {
            this.unqualifiedInjections.add(injection);
        }
    }

    private void blockDuplicateQualifiers(String string) {
        if (!this.qualifiers.add(string)) {
            throw new RuntimeException(String.format("At least two mocks have fieldName qualifier '%s'", string));
        }
    }

    public void addTestSubjectField(Field field) {
        this.testSubjectFields.add(field);
    }

    public List<Field> getTestSubjectFields() {
        return this.testSubjectFields;
    }

    public List<Injection> getQualifiedInjections() {
        return this.qualifiedInjections;
    }

    public List<Injection> getUnqualifiedInjections() {
        return this.unqualifiedInjections;
    }
}

