/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.score;

import blue.BlueSystem;
import blue.score.TimeState;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class ScoreMouseWheelListener
implements MouseWheelListener {
    JScrollPane scrollPane;
    MouseWheelListener[] listeners;
    TimeState timeState = null;

    public ScoreMouseWheelListener(JScrollPane scrollPane) {
        this.scrollPane = scrollPane;
        this.listeners = scrollPane.getMouseWheelListeners();
        for (int i = 0; i < this.listeners.length; ++i) {
            scrollPane.removeMouseWheelListener(this.listeners[i]);
        }
        scrollPane.addMouseWheelListener(this);
    }

    public void setTimeState(TimeState timeState) {
        this.timeState = timeState;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        int shortcutKey = BlueSystem.getMenuShortcutKey();
        if (e.isAltDown()) {
            if (this.timeState == null) {
                return;
            }
            double value = e.getPreciseWheelRotation();
            int xLoc = e.getX();
            float timeVal = (float)xLoc / (float)this.timeState.getPixelSecond();
            if (value > 0.0) {
                this.timeState.raisePixelSecond();
            } else {
                this.timeState.lowerPixelSecond();
            }
            SwingUtilities.invokeLater(() -> {
                int newVal = (int)(timeVal * (float)this.timeState.getPixelSecond());
                if ((newVal -= xLoc) > 0) {
                    this.scrollPane.getHorizontalScrollBar().setValue(newVal);
                }
            });
            e.consume();
        } else if (e.isShiftDown()) {
            double value = e.getPreciseWheelRotation();
            JScrollBar scrollBar = this.scrollPane.getHorizontalScrollBar();
            scrollBar.setValue(scrollBar.getValue() + (int)(value * (double)scrollBar.getBlockIncrement()));
            e.consume();
        } else {
            double value = e.getPreciseWheelRotation();
            JScrollBar scrollBar = this.scrollPane.getVerticalScrollBar();
            scrollBar.setValue(scrollBar.getValue() + (int)(value * (double)scrollBar.getBlockIncrement()));
            e.consume();
        }
    }
}

