/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.mixer;

import blue.Arrangement;
import blue.ArrangementEvent;
import blue.ArrangementListener;
import blue.BlueData;
import blue.mixer.Channel;
import blue.mixer.ChannelList;
import blue.mixer.Mixer;
import blue.projects.BlueProject;
import blue.projects.BlueProjectManager;
import blue.ui.core.mixer.ChannelListLayout;
import blue.ui.core.mixer.ChannelListPanel;
import blue.ui.core.mixer.ChannelPanel;
import blue.ui.core.mixer.EffectEditorManager;
import blue.ui.core.mixer.MixerChannelsColumnHeader;
import blue.ui.core.mixer.SendEditorManager;
import blue.ui.core.mixer.SubChannelListPanel;
import blue.util.ObservableListListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="MixerTopComponent", persistenceType=0)
public final class MixerTopComponent
extends TopComponent
implements ArrangementListener {
    private static MixerTopComponent instance;
    private Mixer mixer;
    private Arrangement arrangement;
    private Integer dividerLocationReset;
    private final ObservableListListener<ChannelList> listChangeListener;
    MixerChannelsColumnHeader header;
    private JPanel channelGroupsPanel;
    private ChannelListPanel channelsPanel;
    private JCheckBox enabled;
    private JTextField extraRenderText;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private ChannelPanel masterPanel;
    private SubChannelListPanel subChannelsPanel;

    private MixerTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(MixerTopComponent.class, (String)"CTL_MixerTopComponent"));
        this.setToolTipText(NbBundle.getMessage(MixerTopComponent.class, (String)"HINT_MixerTopComponent"));
        BlueProjectManager.getInstance().addPropertyChangeListener(evt -> {
            if ("currentProject".equals(evt.getPropertyName())) {
                SwingUtilities.invokeLater(this::reinitialize);
            }
        });
        this.channelGroupsPanel.setLayout(new ChannelListLayout());
        this.listChangeListener = listEvent -> {
            int index = listEvent.getStartIndex();
            int index2 = listEvent.getEndIndex();
            switch (listEvent.getType()) {
                case 0: {
                    for (ChannelList list : listEvent.getAffectedItems()) {
                        ChannelListPanel panel = new ChannelListPanel();
                        this.channelGroupsPanel.add((Component)panel, index);
                        panel.setChannelList(list, this.mixer.getSubChannels());
                        panel.revalidate();
                        ++index;
                    }
                    break;
                }
                case 1: {
                    for (int i = 0; i <= index2 - index2; ++i) {
                        this.channelGroupsPanel.remove(index);
                    }
                    break;
                }
                case 2: {
                    this.reinitialize();
                }
            }
        };
        this.header = new MixerChannelsColumnHeader(this.channelGroupsPanel);
        this.jScrollPane1.setColumnHeaderView(this.header);
        this.reinitialize();
    }

    protected void reinitialize() {
        BlueProject project = BlueProjectManager.getInstance().getCurrentProject();
        BlueData data = null;
        this.channelGroupsPanel.removeAll();
        if (project != null) {
            data = project.getData();
            for (ChannelList list : data.getMixer().getChannelListGroups()) {
                ChannelListPanel panel = new ChannelListPanel();
                this.channelGroupsPanel.add(panel);
                panel.setChannelList(list, data.getMixer().getSubChannels());
                panel.revalidate();
            }
            this.channelGroupsPanel.add(this.channelsPanel);
            this.channelGroupsPanel.add(this.subChannelsPanel);
            this.setMixer(data.getMixer());
            this.setArrangement(data.getArrangement());
        }
        this.channelGroupsPanel.revalidate();
        this.channelGroupsPanel.repaint();
    }

    protected void updateExtraRenderValue() {
        String val = this.extraRenderText.getText();
        try {
            double value = Double.parseDouble(val);
            if (value < 0.0) {
                value = 0.0;
            }
            this.mixer.setExtraRenderTime(value);
        }
        catch (NumberFormatException nfe) {
            this.extraRenderText.setText(Double.toString(this.mixer.getExtraRenderTime()));
        }
    }

    public void setMixer(Mixer mixer) {
        if (this.mixer != null) {
            this.mixer.getChannelListGroups().removeListener(this.listChangeListener);
        }
        this.mixer = null;
        this.enabled.setSelected(mixer.isEnabled());
        this.extraRenderText.setEnabled(mixer.isEnabled());
        this.extraRenderText.setText(Double.toString(mixer.getExtraRenderTime()));
        this.channelsPanel.setChannelList(mixer.getChannels(), mixer.getSubChannels());
        this.subChannelsPanel.setChannelList(mixer.getSubChannels());
        this.masterPanel.clear();
        this.masterPanel.setChannel(mixer.getMaster());
        this.mixer = mixer;
        this.mixer.getChannelListGroups().addListener(this.listChangeListener);
        EffectEditorManager.getInstance().clear();
        SendEditorManager.getInstance().clear();
        this.header.setMixer(mixer);
    }

    public void setArrangement(Arrangement arrangement) {
        if (this.arrangement != null) {
            arrangement.removeArrangementListener((ArrangementListener)this);
            this.arrangement = null;
        }
        this.arrangement = arrangement;
        this.reconcileWithArrangement();
        arrangement.addArrangementListener((ArrangementListener)this);
    }

    public void arrangementChanged(ArrangementEvent arrEvt) {
        switch (arrEvt.getType()) {
            case 0: {
                this.reconcileWithArrangement();
                break;
            }
            case 1: {
                this.switchMixerId(arrEvt.getOldId(), arrEvt.getNewId());
            }
        }
    }

    private void switchMixerId(String oldId, String newId) {
        Channel channel;
        int i;
        ChannelList channels = this.mixer.getChannels();
        int oldIdCount = 0;
        int newIdCount = 0;
        for (i = 0; i < this.arrangement.size(); ++i) {
            String instrId = this.arrangement.getInstrumentAssignment((int)i).arrangementId;
            if (instrId.equals(oldId)) {
                ++oldIdCount;
                continue;
            }
            if (!instrId.equals(newId)) continue;
            ++newIdCount;
        }
        if (oldIdCount == 0 && newIdCount == 1) {
            for (i = 0; i < channels.size(); ++i) {
                channel = (Channel)channels.get(i);
                if (!channel.getName().equals(oldId)) continue;
                channel.setName(newId);
                break;
            }
        } else if (oldIdCount == 0 && newIdCount > 1) {
            for (i = 0; i < channels.size(); ++i) {
                channel = (Channel)channels.get(i);
                if (!channel.getName().equals(oldId)) continue;
                channels.remove((Object)channel);
                break;
            }
        } else if (oldIdCount > 0 && newIdCount == 1) {
            Channel channel2 = new Channel();
            channel2.setName(newId);
            channels.add((Object)channel2);
        }
    }

    private void reconcileWithArrangement() {
        this.channelsPanel.sort();
    }

    private void initComponents() {
        this.channelsPanel = new ChannelListPanel();
        this.subChannelsPanel = new SubChannelListPanel();
        this.enabled = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.extraRenderText = new JTextField();
        this.masterPanel = new ChannelPanel();
        this.jScrollPane1 = new JScrollPane();
        this.channelGroupsPanel = new JPanel();
        Mnemonics.setLocalizedText((AbstractButton)this.enabled, (String)NbBundle.getMessage(MixerTopComponent.class, (String)"MixerTopComponent.enabled.text"));
        this.enabled.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MixerTopComponent.this.enabledActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(MixerTopComponent.class, (String)"MixerTopComponent.jLabel1.text"));
        this.extraRenderText.setText(NbBundle.getMessage(MixerTopComponent.class, (String)"MixerTopComponent.extraRenderText.text"));
        this.extraRenderText.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MixerTopComponent.this.extraRenderTextFocusLost(evt);
            }
        });
        this.extraRenderText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MixerTopComponent.this.extraRenderTextActionPerformed(evt);
            }
        });
        this.masterPanel.setBorder(null);
        this.masterPanel.setMaster(true);
        this.channelGroupsPanel.setBackground(new Color(0, 0, 0));
        this.channelGroupsPanel.setLayout(null);
        this.jScrollPane1.setViewportView(this.channelGroupsPanel);
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.enabled).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 188, Short.MAX_VALUE).addComponent(this.jLabel1)).addComponent(this.jScrollPane1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.extraRenderText).addComponent(this.masterPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.extraRenderText, -2, -1, -2).addComponent(this.jLabel1).addComponent(this.enabled)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.masterPanel, -1, 293, Short.MAX_VALUE).addContainerGap()).addComponent(this.jScrollPane1))));
    }

    private void enabledActionPerformed(ActionEvent evt) {
        if (this.mixer != null) {
            this.mixer.setEnabled(this.enabled.isSelected());
            this.extraRenderText.setEnabled(this.enabled.isSelected());
        }
    }

    private void extraRenderTextActionPerformed(ActionEvent evt) {
        this.updateExtraRenderValue();
    }

    private void extraRenderTextFocusLost(FocusEvent evt) {
        this.updateExtraRenderValue();
    }

    public void componentOpened() {
    }

    public void componentClosed() {
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
    }
}

