/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.editor.ceciliaModule;

import blue.soundObject.CeciliaModule;
import blue.soundObject.ceciliaModule.CFileIn;
import blue.soundObject.ceciliaModule.CeciliaObject;
import blue.soundObject.editor.ceciliaModule.CFilePanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class FileInputPanel
extends JComponent {
    private HashMap interfaceObjectMap = new HashMap();
    int myNextItemRow = 0;

    public FileInputPanel() {
        this.setLayout(new GridBagLayout());
        this.addSpacer();
    }

    private void addSpacer() {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 99;
        constraints.insets = new Insets(10, 0, 0, 0);
        constraints.weighty = 1.0;
        constraints.fill = 3;
        JLabel verticalFillLabel = new JLabel();
        this.add((Component)verticalFillLabel, constraints);
    }

    public void clearFileInputs() {
        this.removeAll();
        this.addSpacer();
        this.interfaceObjectMap.clear();
        this.myNextItemRow = 0;
    }

    public void addFileInput(String objectName, boolean isAudio) {
        CFilePanel cfPanel = new CFilePanel(objectName, isAudio);
        GridBagConstraints labelConstraints = new GridBagConstraints();
        labelConstraints.gridx = 0;
        labelConstraints.gridy = this.myNextItemRow++;
        labelConstraints.weightx = 1.0;
        labelConstraints.insets = new Insets(10, 10, 0, 10);
        labelConstraints.anchor = 17;
        labelConstraints.fill = 2;
        this.add((Component)cfPanel, labelConstraints);
        this.interfaceObjectMap.put(objectName, cfPanel);
    }

    public void editCeciliaModule(CeciliaModule cm) {
        this.clearFileInputs();
        String tk_interface = cm.getModuleDefinition().tk_interface;
        StringTokenizer st = new StringTokenizer(tk_interface, "\n");
        while (st.hasMoreTokens()) {
            StringTokenizer objectTokenizer;
            String line = st.nextToken().trim();
            if (line.length() == 0 || (objectTokenizer = new StringTokenizer(line)).countTokens() < 2) continue;
            String objectType = objectTokenizer.nextToken();
            String objectName = objectTokenizer.nextToken();
            if (!objectType.equals("cfilein")) continue;
            boolean isAudio = true;
            while (objectTokenizer.hasMoreTokens()) {
                String token = objectTokenizer.nextToken().trim();
                if (!token.equals("-type") || !objectTokenizer.hasMoreTokens() || objectTokenizer.nextToken().trim().equals("audio")) continue;
                isAudio = false;
            }
            this.addFileInput(objectName, isAudio);
        }
        for (CeciliaObject element : cm.getStateData().values()) {
            if (!(element instanceof CFileIn)) continue;
            CFileIn cfileIn = (CFileIn)element;
            CFilePanel cfPanel = (CFilePanel)this.interfaceObjectMap.get(cfileIn.getObjectName());
            cfPanel.setCFileIn(cfileIn);
        }
    }
}

