/*
 * Decompiled with CFR 0.152.
 */
package blue.settings;

import blue.ProjectProperties;
import blue.settings.GeneralSettings;
import blue.settings.RealtimeRenderSettings;

public class ProjectPropertiesUtil {
    public static String getRealtimeCommandLine(ProjectProperties props) {
        if (props.completeOverride) {
            String retVal = props.advancedSettings;
            if (!GeneralSettings.getInstance().isMessageColorsEnabled()) {
                retVal = retVal + " -+msg_color=false ";
            }
            return retVal;
        }
        StringBuffer buffer = new StringBuffer();
        RealtimeRenderSettings settings = RealtimeRenderSettings.getInstance();
        buffer.append(settings.getCommandLine(props.useAudioOut, props.useAudioIn, props.useMidiIn, props.useMidiOut)).append(" ");
        buffer.append(ProjectPropertiesUtil.getMessageLevelFlag(props)).append(" ");
        buffer.append(props.advancedSettings);
        return buffer.toString();
    }

    protected static String getMessageLevelFlag(ProjectProperties props) {
        int val = 0;
        if (props.noteAmpsEnabled) {
            ++val;
        }
        if (props.outOfRangeEnabled) {
            val += 2;
        }
        if (props.warningsEnabled) {
            val += 4;
        }
        if (props.benchmarkEnabled) {
            val += 128;
        }
        return "-m" + val;
    }
}

