/*
 * Decompiled with CFR 0.152.
 */
package blue.undo;

import blue.BlueSystem;
import blue.undo.NoStyleChangeUndoManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.JMenuItem;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

public class BlueUndoManager {
    private static HashMap<String, UndoManager> undoGroup;
    private static UndoManager undo;
    private static JMenuItem undoMenuItem;
    private static JMenuItem redoMenuItem;
    private static ActionListener al;

    public static ActionListener getMenuActionListener() {
        return al;
    }

    public static void setUndoGroup(HashMap<String, UndoManager> _undoGroup) {
        undoGroup = _undoGroup;
    }

    public static void setUndoManager(String tab) {
        UndoManager obj = undoGroup.get(tab);
        if (obj == null) {
            NoStyleChangeUndoManager manager = new NoStyleChangeUndoManager();
            manager.setLimit(1000);
            undoGroup.put(tab, manager);
            obj = manager;
        }
        undo = obj;
        BlueUndoManager.checkMenus();
    }

    public static UndoManager getUndoManager() {
        return undo;
    }

    public static void setUndoMenuItem(JMenuItem _undoMenuItem) {
        undoMenuItem = _undoMenuItem;
    }

    public static void setRedoMenuItem(JMenuItem _redoMenuItem) {
        redoMenuItem = _redoMenuItem;
    }

    public static void addEdit(UndoableEdit edit) {
        if (undo != null) {
            undo.addEdit(edit);
            BlueUndoManager.checkMenus();
        }
    }

    private static void checkMenus() {
        if (undo == null) {
            return;
        }
        if (undoMenuItem != null) {
            if (undo.canUndo()) {
                undoMenuItem.setEnabled(true);
                undoMenuItem.setText(undo.getUndoPresentationName());
            } else {
                undoMenuItem.setEnabled(false);
                undoMenuItem.setText(BlueSystem.getString("undo.undo"));
            }
        }
        if (redoMenuItem != null) {
            if (undo.canRedo()) {
                redoMenuItem.setEnabled(true);
                redoMenuItem.setText(undo.getRedoPresentationName());
            } else {
                redoMenuItem.setEnabled(false);
                redoMenuItem.setText(BlueSystem.getString("undo.redo"));
            }
        }
    }

    static {
        al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == undoMenuItem) {
                    if (undo.canUndo()) {
                        undo.undo();
                        BlueUndoManager.checkMenus();
                    }
                } else if (e.getSource() == redoMenuItem && undo.canRedo()) {
                    undo.redo();
                    BlueUndoManager.checkMenus();
                }
            }
        };
    }
}

