/*
 * Decompiled with CFR 0.152.
 */
package blue;

import blue.soundObject.Instance;
import blue.soundObject.SoundObject;
import blue.utility.ObjectUtilities;
import electric.xml.Element;
import electric.xml.Elements;
import java.rmi.dgc.VMID;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class SoundObjectLibrary
extends ArrayList<SoundObject> {
    private boolean initializing = false;
    private transient ArrayList<ChangeListener> listeners = new ArrayList();

    public SoundObjectLibrary() {
    }

    public SoundObjectLibrary(SoundObjectLibrary sObjLib) {
        super(sObjLib.size());
        for (SoundObject sObj : sObjLib) {
            this.add(sObj.deepCopy());
        }
    }

    public void addSoundObject(SoundObject sObj) {
        sObj.setStartTime(0.0);
        this.add(sObj);
        this.fireChangeEvent();
    }

    public SoundObject getSoundObject(int index) {
        return (SoundObject)this.get(index);
    }

    public boolean removeSoundObject(SoundObject sObj) {
        if (this.contains(sObj)) {
            this.remove(sObj);
            this.fireChangeEvent();
            return true;
        }
        return false;
    }

    public void addChangeListener(ChangeListener cl) {
        this.listeners.add(cl);
    }

    public void removeChangeListener(ChangeListener cl) {
        this.listeners.remove(cl);
    }

    public void fireChangeEvent() {
        ChangeEvent ce = new ChangeEvent(this);
        for (ChangeListener cl : this.listeners) {
            cl.stateChanged(ce);
        }
    }

    public static SoundObjectLibrary loadFromXML(Element data, Map<String, Object> objRefMap) throws Exception {
        SoundObjectLibrary sObjLib = new SoundObjectLibrary();
        sObjLib.setInitializing(true);
        Elements sObjects = data.getElements("soundObject");
        int index = 0;
        while (sObjects.hasMoreElements()) {
            Element node = sObjects.next();
            if ("blue.soundObject.Instance".equals(node.getAttributeValue("type"))) {
                ++index;
                continue;
            }
            SoundObject sObj = (SoundObject)ObjectUtilities.loadFromXML(node, objRefMap);
            sObjLib.add(sObj);
            if (node.getAttribute("objRefId") != null) {
                objRefMap.put(node.getAttributeValue("objRefId"), sObj);
                continue;
            }
            objRefMap.put(Integer.toString(index++), sObj);
        }
        sObjLib.setInitializing(false);
        return sObjLib;
    }

    public Element saveAsXML(Map<Object, String> objRefMap) {
        Element retVal = new Element("soundObjectLibrary");
        for (SoundObject sObj : this) {
            String objRefId = Integer.toString(new VMID().hashCode());
            objRefMap.put(sObj, objRefId);
            Element elem = sObj.saveAsXML(objRefMap);
            elem.setAttribute("objRefId", objRefId);
            retVal.addElement(elem);
        }
        return retVal;
    }

    public boolean isInitializing() {
        return this.initializing;
    }

    public void setInitializing(boolean initializing) {
        this.initializing = initializing;
    }

    public void checkAndAddInstanceSoundObjects(List<Instance> instanceSoundObjects) {
        HashMap<SoundObject, SoundObject> originalToCopyMap = new HashMap<SoundObject, SoundObject>();
        for (Instance instance : instanceSoundObjects) {
            SoundObject copy;
            SoundObject instanceSObj = instance.getSoundObject();
            if (this.contains(instanceSObj)) continue;
            if (originalToCopyMap.containsKey(instanceSObj)) {
                copy = (SoundObject)originalToCopyMap.get(instanceSObj);
            } else {
                copy = instance.getSoundObject().deepCopy();
                this.addSoundObject(copy);
                originalToCopyMap.put(instanceSObj, copy);
            }
            instance.setSoundObject(copy);
        }
    }
}

