;
; "Timewave Canon"
; by Dave Seidel
;
; A kind of mensuration canon, based on a naive sonification
; of the tri-level bidirectional form of Terence McKenna's TimeWave
; Zero.  Thanks to John Sheliak for his work on this subject.
; 
; Copyright (c) 2006, Dave Seidel.  Some rights reserved. This
; work is licensed under a Creative Commons Attribution License
; (see http://creativecommons.org/licenses/by/2.5/).
;
; Generated by blue 0.106.0_beta3 (http://csounds.com/stevenyi/blue/index.html)
;

<CsoundSynthesizer>

<CsInstruments>
sr=48000
ksmps=100
nchnls=2


ga_bluemix_1_0	init	0
ga_bluemix_1_1	init	0
ga_bluemix_2_0	init	0
ga_bluemix_2_1	init	0
ga_bluemix_3_0	init	0
ga_bluemix_3_1	init	0
ga_bluemix_4_0	init	0
ga_bluemix_4_1	init	0





	opcode blueEffect0,aa,aa

ain1,ain2	xin
aout1, aout2  reverbsc ain1, ain2, 0.6, 8012.0

aout1 = (ain1 * 0.75) + (aout1 * (1 - 0.75))
aout2 = (ain2 * 0.75) + (aout2 * (1 - 0.75))


xout	aout1,aout2


	endop


	instr 1	;Default Bank 30 - SOFTSPACE4
                idur 	= abs(p3) 
p3 = p3 + 4                           ;turn on note indefinitely
        idur    =       idur
        ibase   =       (p4 < 15 ? cpspch(p4) : p4)              ;p4 is keyboard pitch
        iroct   =       (p4 < 15 ? octpch(p4) : p4)
        irbase  =       octpch(4.09)            ;base of rate scl table
        irrange =       octpch(13.06)-irbase
        iveloc  =       p5                      ;0 <= p5 <= 127
        iop1fn  =       12                     ;param tables for ops
        iop2fn  =       13
        iop3fn  =       14
        iop4fn  =       15
        iop5fn  =       16
        iop6fn  =       17
        iampfn  =       2                     ;amp/level map function
        ipkamp  =       5000                     ;scale for converter
        irsfn   =       3                     ;rate scaling function
        idevfn  =       8                     ;level/pkdev map func
        irisefn =       4                     ;eg rise rate fn
        idecfn  =       6                     ;eg decay rate fn
        ivsfn   =       10                     ;vel sensitivity fn
        ivelfn  =       9                     ;vel/amp fac map fn
        iveloc  table   iveloc,ivelfn           ;map this note's veloc
        ifeedfn =       11
        ifeed   table   0,ifeedfn             ;0 <= p25 <= 7 (feedbk)
        ifeed   =       ifeed/(2 * 3.14159)     ;dev in radians
        idetfac =       4                       ;max detuning divisor
        imap128 =       127/99                  ;mapping constant 99->127
        irscl   table   (iroct-irbase)/irrange*127,irsfn
        irscl   =       irscl*6
        iop     =       1                       ;start loop with op1
        iopfn   =       iop1fn
loop:
;---------------------------------read operator parameters
        ilvl    table   0,iopfn
        ivel    table   1,iopfn
        iegr1   table   2,iopfn
        iegr2   table   3,iopfn
        iegr3   table   4,iopfn
        iegr4   table   5,iopfn
        iegl1   table   6,iopfn
        iegl2   table   7,iopfn
        iegl3   table   8,iopfn
        iegl4   table   9,iopfn
        iams    table   10,iopfn
        imode   table   11,iopfn
        ifreq   table   12,iopfn
        idet    table   13,iopfn
        irss    table   14,iopfn
;----------------------------------initialize operator
        ihz     =       (imode > 0 ? ifreq : ibase * ifreq) + idet/idetfac
 iamp	=	ilvl/99		;rescale to 0 -> 1
        ivfac   table   ivel,ivsfn
        iegl1   =       iamp*iegl1
        iegl2   =       iamp*iegl2
        iegl3   =       iamp*iegl3
        iegl4   =       iamp*iegl4
        iegl1   =       iegl1*(1-ivfac)+iegl1*ivfac*iveloc
        iegl2   =       iegl2*(1-ivfac)+iegl2*ivfac*iveloc
        iegl3   =       iegl3*(1-ivfac)+iegl3*ivfac*iveloc
        iegl4   =       iegl4*(1-ivfac)+iegl4*ivfac*iveloc
        irs     =       irscl*irss
        iegr1   =       (iegr1+irs > 99 ? 99 : iegr1+irs)
        iegr2   =       (iegr2+irs > 99 ? 99 : iegr2+irs)
        iegr3   =       (iegr3+irs > 99 ? 99 : iegr3+irs)
        iegr4   =       (iegr4+irs > 99 ? 99 : iegr4+irs)
        irfn    =       (iegl1 > iegl4 ? irisefn : idecfn)
        iegd1   table   iegr1,irfn               ;convert rate->dur
        ipct1   table   iegl4,irfn+1             ;pct fn is next one
        ipct2   table   iegl1,irfn+1
        iegd1   =       abs(iegd1*ipct1-iegd1*ipct2)
        iegd1   =       (iegd1 == 0 ? .001 : iegd1)
        irfn    =       (iegl2 > iegl1 ? irisefn : idecfn)
        iegd2   table   iegr2,irfn
        ipct1   table   iegl1,irfn+1
        ipct2   table   iegl2,irfn+1
        iegd2   =       abs(iegd2*ipct1-iegd2*ipct2)
        iegd2   =       (iegd2 == 0 ? .001 : iegd2)
        irfn    =       (iegl3 > iegl2 ? irisefn : idecfn)
        iegd3   table   iegr3,irfn
        ipct1   table   iegl2,irfn+1
        ipct2   table   iegl3,irfn+1
        iegd3   =       abs(iegd3*ipct1-iegd3*ipct2)
        iegd3   =       (iegd3 == 0 ? .001 : iegd3)
        iegd4   table   iegr4,idecfn
                if      (iegl3 <= iegl4) igoto continue
        ipct1   table   iegl3,irfn+1
        ipct2   table   iegl4,irfn+1
        iegd4   =       abs(iegd4*ipct1-iegd4*ipct2)
        iegd4   =       (iegd4 == 0 ? .001 : iegd4)
continue:
                if      (iop > 1) igoto op2
op1:
        i1egd1  =       iegd1
        i1egd2  =       iegd2
        i1egd3  =       iegd3
        i1egd4  =       iegd4
        i1egl1  =       iegl1
        i1egl2  =       iegl2
        i1egl3  =       iegl3
        i1egl4  =       iegl4
        i1ams   =       iams
        i1hz    =       ihz
        iop     =       iop + 1
        iopfn   =       iop2fn
                igoto   loop
op2:            if      (iop > 2) igoto op3
        i2egd1  =       iegd1
        i2egd2  =       iegd2
        i2egd3  =       iegd3
        i2egd4  =       iegd4
        i2egl1  =       iegl1
        i2egl2  =       iegl2
        i2egl3  =       iegl3
        i2egl4  =       iegl4
        i2ams   =       iams
        i2hz    =       ihz
        iop     =       iop + 1
        iopfn   =       iop3fn
                igoto   loop
op3:            if      (iop > 3) igoto op4
        i3egd1  =       iegd1
        i3egd2  =       iegd2
        i3egd3  =       iegd3
        i3egd4  =       iegd4
        i3egl1  =       iegl1
        i3egl2  =       iegl2
        i3egl3  =       iegl3
        i3egl4  =       iegl4
        i3ams   =       iams
        i3hz    =       ihz
        iop     =       iop + 1
        iopfn   =       iop4fn
                igoto   loop
op4:            if      (iop > 4) igoto op5
        i4egd1  =       iegd1
        i4egd2  =       iegd2
        i4egd3  =       iegd3
        i4egd4  =       iegd4
        i4egl1  =       iegl1
        i4egl2  =       iegl2
        i4egl3  =       iegl3
        i4egl4  =       iegl4
        i4ams   =       iams
        i4hz    =       ihz
        iop     =       iop + 1
        iopfn   =       iop5fn
                igoto   loop
op5:            if      (iop > 5) igoto op6
        i5egd1  =       iegd1
        i5egd2  =       iegd2
        i5egd3  =       iegd3
        i5egd4  =       iegd4
        i5egl1  =       iegl1
        i5egl2  =       iegl2
        i5egl3  =       iegl3
        i5egl4  =       iegl4
        i5ams   =       iams
        i5hz    =       ihz
        iop     =       iop + 1
        iopfn   =       iop6fn
                igoto   loop
op6:
        i6egd1  =       iegd1
        i6egd2  =       iegd2
        i6egd3  =       iegd3
        i6egd4  =       iegd4
        i6egl1  =       iegl1
        i6egl2  =       iegl2
        i6egl3  =       iegl3
        i6egl4  =       iegl4
        i6ams   =       iams
        i6hz    =       ihz
;=====================================================================
                timout  idur,999,final          ;skip during final decay
        k1sus   linseg  i1egl4,i1egd1,i1egl1,i1egd2,i1egl2,i1egd3,i1egl3,1,i1egl3
        k2sus   linseg  i2egl4,i2egd1,i2egl1,i2egd2,i2egl2,i2egd3,i2egl3,1,i2egl3
        k3sus   linseg  i3egl4,i3egd1,i3egl1,i3egd2,i3egl2,i3egd3,i3egl3,1,i3egl3
        k4sus   linseg  i4egl4,i4egd1,i4egl1,i4egd2,i4egl2,i4egd3,i4egl3,1,i4egl3
        k5sus   linseg  i5egl4,i5egd1,i5egl1,i5egd2,i5egl2,i5egd3,i5egl3,1,i5egl3
        k6sus   linseg  i6egl4,i6egd1,i6egl1,i6egd2,i6egl2,i6egd3,i6egl3,1,i6egl3
        k1phs   =       k1sus
        k2phs   =       k2sus
        k3phs   =       k3sus
        k4phs   =       k4sus
        k5phs   =       k5sus
        k6phs   =       k6sus
                kgoto   output
final:
        k1fin   linseg  1,i1egd4,0,1,0
        k1phs   =       i1egl4+(k1sus-i1egl4)*k1fin
        k2fin   linseg  1,i2egd4,0,1,0
        k2phs   =       i2egl4+(k2sus-i2egl4)*k2fin
        k3fin   linseg  1,i3egd4,0,1,0
        k3phs   =       i3egl4+(k3sus-i3egl4)*k3fin
        k4fin   linseg  1,i4egd4,0,1,0
        k4phs   =       i4egl4+(k4sus-i4egl4)*k4fin
        k5fin   linseg  1,i5egd4,0,1,0
        k5phs   =       i5egl4+(k5sus-i5egl4)*k5fin
        k6fin   linseg  1,i6egd4,0,1,0
        k6phs   =       i6egl4+(k6sus-i6egl4)*k6fin
;------------------------------Algorithm 1---------------------------------;
                if      (k1fin+k3fin) > 0 kgoto output  ;test carrier sigs
                turnoff                 ;when carrier oscil(s) done, turn off.
output:
        k1gate  tablei  k1phs,iampfn                ;use iampfn for carriers
        k2gate  tablei  k2phs,idevfn                ;use idevfn for modulators
 	k3gate	tablei	k3phs,iampfn
 	k4gate	tablei	k4phs,idevfn
        k5gate  tablei  k5phs,idevfn
 	k6gate	tablei	k6phs,idevfn
	
        a6sig   init    0               ;initialize for feedback
        a6phs   phasor  i6hz            ;ops to be modulated must use phase...
        a6sig   tablei  a6phs+a6sig*(.2*ifeed),1,1,0,1 ; ...modulation, not fm!
        a6sig   =       a6sig*k6gate
        a5phs   phasor  i5hz
        a5sig   tablei  a5phs+a6sig,1,1,0,1
        a5sig   =       a5sig*k5gate
        a4phs   phasor  i4hz
        a4sig   tablei  a4phs+a5sig,1,1,0,1
        a4sig   =       a4sig*k4gate
        a3phs   phasor  i3hz
        a3sig   tablei  a3phs+a4sig,1,1,0,1
        a3sig   =       a3sig*k3gate
        a2sig   oscili  k2gate,i2hz,1
        a1phs   phasor  i1hz
        a1sig   tablei  a1phs+a2sig,1,1,0,1
        a1sig   =       a1sig*k1gate
                aout =  (a1sig+a3sig)*ipkamp
               
ga_bluemix_1_0 = ga_bluemix_1_0 +  aout
ga_bluemix_1_1 = ga_bluemix_1_1 +  aout

	endin

	instr 2	;Default Bank 9 - UNCLE BENS
                idur 	= abs(p3) 
p3 = p3 + 4                           ;turn on note indefinitely
        idur    =       idur
        ibase   =       (p4 < 15 ? cpspch(p4) : p4)              ;p4 is keyboard pitch
        iroct   =       (p4 < 15 ? octpch(p4) : p4)
        irbase  =       octpch(4.09)            ;base of rate scl table
        irrange =       octpch(13.06)-irbase
        iveloc  =       p5                      ;0 <= p5 <= 127
        iop1fn  =       18                     ;param tables for ops
        iop2fn  =       19
        iop3fn  =       20
        iop4fn  =       21
        iop5fn  =       22
        iop6fn  =       23
        iampfn  =       2                     ;amp/level map function
        ipkamp  =       5000                     ;scale for converter
        irsfn   =       3                     ;rate scaling function
        idevfn  =       8                     ;level/pkdev map func
        irisefn =       4                     ;eg rise rate fn
        idecfn  =       6                     ;eg decay rate fn
        ivsfn   =       10                     ;vel sensitivity fn
        ivelfn  =       9                     ;vel/amp fac map fn
        iveloc  table   iveloc,ivelfn           ;map this note's veloc
        ifeedfn =       11
        ifeed   table   0,ifeedfn             ;0 <= p25 <= 7 (feedbk)
        ifeed   =       ifeed/(2 * 3.14159)     ;dev in radians
        idetfac =       4                       ;max detuning divisor
        imap128 =       127/99                  ;mapping constant 99->127
        irscl   table   (iroct-irbase)/irrange*127,irsfn
        irscl   =       irscl*6
        iop     =       1                       ;start loop with op1
        iopfn   =       iop1fn
loop:
;---------------------------------read operator parameters
        ilvl    table   0,iopfn
        ivel    table   1,iopfn
        iegr1   table   2,iopfn
        iegr2   table   3,iopfn
        iegr3   table   4,iopfn
        iegr4   table   5,iopfn
        iegl1   table   6,iopfn
        iegl2   table   7,iopfn
        iegl3   table   8,iopfn
        iegl4   table   9,iopfn
        iams    table   10,iopfn
        imode   table   11,iopfn
        ifreq   table   12,iopfn
        idet    table   13,iopfn
        irss    table   14,iopfn
;----------------------------------initialize operator
        ihz     =       (imode > 0 ? ifreq : ibase * ifreq) + idet/idetfac
 iamp	=	ilvl/99		;rescale to 0 -> 1
        ivfac   table   ivel,ivsfn
        iegl1   =       iamp*iegl1
        iegl2   =       iamp*iegl2
        iegl3   =       iamp*iegl3
        iegl4   =       iamp*iegl4
        iegl1   =       iegl1*(1-ivfac)+iegl1*ivfac*iveloc
        iegl2   =       iegl2*(1-ivfac)+iegl2*ivfac*iveloc
        iegl3   =       iegl3*(1-ivfac)+iegl3*ivfac*iveloc
        iegl4   =       iegl4*(1-ivfac)+iegl4*ivfac*iveloc
        irs     =       irscl*irss
        iegr1   =       (iegr1+irs > 99 ? 99 : iegr1+irs)
        iegr2   =       (iegr2+irs > 99 ? 99 : iegr2+irs)
        iegr3   =       (iegr3+irs > 99 ? 99 : iegr3+irs)
        iegr4   =       (iegr4+irs > 99 ? 99 : iegr4+irs)
        irfn    =       (iegl1 > iegl4 ? irisefn : idecfn)
        iegd1   table   iegr1,irfn               ;convert rate->dur
        ipct1   table   iegl4,irfn+1             ;pct fn is next one
        ipct2   table   iegl1,irfn+1
        iegd1   =       abs(iegd1*ipct1-iegd1*ipct2)
        iegd1   =       (iegd1 == 0 ? .001 : iegd1)
        irfn    =       (iegl2 > iegl1 ? irisefn : idecfn)
        iegd2   table   iegr2,irfn
        ipct1   table   iegl1,irfn+1
        ipct2   table   iegl2,irfn+1
        iegd2   =       abs(iegd2*ipct1-iegd2*ipct2)
        iegd2   =       (iegd2 == 0 ? .001 : iegd2)
        irfn    =       (iegl3 > iegl2 ? irisefn : idecfn)
        iegd3   table   iegr3,irfn
        ipct1   table   iegl2,irfn+1
        ipct2   table   iegl3,irfn+1
        iegd3   =       abs(iegd3*ipct1-iegd3*ipct2)
        iegd3   =       (iegd3 == 0 ? .001 : iegd3)
        iegd4   table   iegr4,idecfn
                if      (iegl3 <= iegl4) igoto continue
        ipct1   table   iegl3,irfn+1
        ipct2   table   iegl4,irfn+1
        iegd4   =       abs(iegd4*ipct1-iegd4*ipct2)
        iegd4   =       (iegd4 == 0 ? .001 : iegd4)
continue:
                if      (iop > 1) igoto op2
op1:
        i1egd1  =       iegd1
        i1egd2  =       iegd2
        i1egd3  =       iegd3
        i1egd4  =       iegd4
        i1egl1  =       iegl1
        i1egl2  =       iegl2
        i1egl3  =       iegl3
        i1egl4  =       iegl4
        i1ams   =       iams
        i1hz    =       ihz
        iop     =       iop + 1
        iopfn   =       iop2fn
                igoto   loop
op2:            if      (iop > 2) igoto op3
        i2egd1  =       iegd1
        i2egd2  =       iegd2
        i2egd3  =       iegd3
        i2egd4  =       iegd4
        i2egl1  =       iegl1
        i2egl2  =       iegl2
        i2egl3  =       iegl3
        i2egl4  =       iegl4
        i2ams   =       iams
        i2hz    =       ihz
        iop     =       iop + 1
        iopfn   =       iop3fn
                igoto   loop
op3:            if      (iop > 3) igoto op4
        i3egd1  =       iegd1
        i3egd2  =       iegd2
        i3egd3  =       iegd3
        i3egd4  =       iegd4
        i3egl1  =       iegl1
        i3egl2  =       iegl2
        i3egl3  =       iegl3
        i3egl4  =       iegl4
        i3ams   =       iams
        i3hz    =       ihz
        iop     =       iop + 1
        iopfn   =       iop4fn
                igoto   loop
op4:            if      (iop > 4) igoto op5
        i4egd1  =       iegd1
        i4egd2  =       iegd2
        i4egd3  =       iegd3
        i4egd4  =       iegd4
        i4egl1  =       iegl1
        i4egl2  =       iegl2
        i4egl3  =       iegl3
        i4egl4  =       iegl4
        i4ams   =       iams
        i4hz    =       ihz
        iop     =       iop + 1
        iopfn   =       iop5fn
                igoto   loop
op5:            if      (iop > 5) igoto op6
        i5egd1  =       iegd1
        i5egd2  =       iegd2
        i5egd3  =       iegd3
        i5egd4  =       iegd4
        i5egl1  =       iegl1
        i5egl2  =       iegl2
        i5egl3  =       iegl3
        i5egl4  =       iegl4
        i5ams   =       iams
        i5hz    =       ihz
        iop     =       iop + 1
        iopfn   =       iop6fn
                igoto   loop
op6:
        i6egd1  =       iegd1
        i6egd2  =       iegd2
        i6egd3  =       iegd3
        i6egd4  =       iegd4
        i6egl1  =       iegl1
        i6egl2  =       iegl2
        i6egl3  =       iegl3
        i6egl4  =       iegl4
        i6ams   =       iams
        i6hz    =       ihz
;=====================================================================
                timout  idur,999,final          ;skip during final decay
        k1sus   linseg  i1egl4,i1egd1,i1egl1,i1egd2,i1egl2,i1egd3,i1egl3,1,i1egl3
        k2sus   linseg  i2egl4,i2egd1,i2egl1,i2egd2,i2egl2,i2egd3,i2egl3,1,i2egl3
        k3sus   linseg  i3egl4,i3egd1,i3egl1,i3egd2,i3egl2,i3egd3,i3egl3,1,i3egl3
        k4sus   linseg  i4egl4,i4egd1,i4egl1,i4egd2,i4egl2,i4egd3,i4egl3,1,i4egl3
        k5sus   linseg  i5egl4,i5egd1,i5egl1,i5egd2,i5egl2,i5egd3,i5egl3,1,i5egl3
        k6sus   linseg  i6egl4,i6egd1,i6egl1,i6egd2,i6egl2,i6egd3,i6egl3,1,i6egl3
        k1phs   =       k1sus
        k2phs   =       k2sus
        k3phs   =       k3sus
        k4phs   =       k4sus
        k5phs   =       k5sus
        k6phs   =       k6sus
                kgoto   output
final:
        k1fin   linseg  1,i1egd4,0,1,0
        k1phs   =       i1egl4+(k1sus-i1egl4)*k1fin
        k2fin   linseg  1,i2egd4,0,1,0
        k2phs   =       i2egl4+(k2sus-i2egl4)*k2fin
        k3fin   linseg  1,i3egd4,0,1,0
        k3phs   =       i3egl4+(k3sus-i3egl4)*k3fin
        k4fin   linseg  1,i4egd4,0,1,0
        k4phs   =       i4egl4+(k4sus-i4egl4)*k4fin
        k5fin   linseg  1,i5egd4,0,1,0
        k5phs   =       i5egl4+(k5sus-i5egl4)*k5fin
        k6fin   linseg  1,i6egd4,0,1,0
        k6phs   =       i6egl4+(k6sus-i6egl4)*k6fin
;------------------------------Algorithm 1---------------------------------;
                if      (k1fin+k3fin) > 0 kgoto output  ;test carrier sigs
                turnoff                 ;when carrier oscil(s) done, turn off.
output:
        k1gate  tablei  k1phs,iampfn                ;use iampfn for carriers
        k2gate  tablei  k2phs,idevfn                ;use idevfn for modulators
 	k3gate	tablei	k3phs,iampfn
 	k4gate	tablei	k4phs,idevfn
        k5gate  tablei  k5phs,idevfn
 	k6gate	tablei	k6phs,idevfn
	
        a6sig   init    0               ;initialize for feedback
        a6phs   phasor  i6hz            ;ops to be modulated must use phase...
        a6sig   tablei  a6phs+a6sig*(.2*ifeed),1,1,0,1 ; ...modulation, not fm!
        a6sig   =       a6sig*k6gate
        a5phs   phasor  i5hz
        a5sig   tablei  a5phs+a6sig,1,1,0,1
        a5sig   =       a5sig*k5gate
        a4phs   phasor  i4hz
        a4sig   tablei  a4phs+a5sig,1,1,0,1
        a4sig   =       a4sig*k4gate
        a3phs   phasor  i3hz
        a3sig   tablei  a3phs+a4sig,1,1,0,1
        a3sig   =       a3sig*k3gate
        a2sig   oscili  k2gate,i2hz,1
        a1phs   phasor  i1hz
        a1sig   tablei  a1phs+a2sig,1,1,0,1
        a1sig   =       a1sig*k1gate
                aout =  (a1sig+a3sig)*ipkamp
               
ga_bluemix_2_0 = ga_bluemix_2_0 +  aout
ga_bluemix_2_1 = ga_bluemix_2_1 +  aout

	endin

	instr 3	;Default Bank 32 - CHIMES
                idur 	= abs(p3) 
p3 = p3 + 4                           ;turn on note indefinitely
        idur    =       idur
        ibase   =       (p4 < 15 ? cpspch(p4) : p4)              ;p4 is keyboard pitch
        iroct   =       (p4 < 15 ? octpch(p4) : p4)
        irbase  =       octpch(4.09)            ;base of rate scl table
        irrange =       octpch(13.06)-irbase
        iveloc  =       p5                      ;0 <= p5 <= 127
        iop1fn  =       24                     ;param tables for ops
        iop2fn  =       25
        iop3fn  =       26
        iop4fn  =       27
        iop5fn  =       28
        iop6fn  =       29
        iampfn  =       2                     ;amp/level map function
        ipkamp  =       5000                     ;scale for converter
        irsfn   =       3                     ;rate scaling function
        idevfn  =       8                     ;level/pkdev map func
        irisefn =       4                     ;eg rise rate fn
        idecfn  =       6                     ;eg decay rate fn
        ivsfn   =       10                     ;vel sensitivity fn
        ivelfn  =       9                     ;vel/amp fac map fn
        iveloc  table   iveloc,ivelfn           ;map this note's veloc
        ifeedfn =       11
        ifeed   table   0,ifeedfn             ;0 <= p25 <= 7 (feedbk)
        ifeed   =       ifeed/(2 * 3.14159)     ;dev in radians
        idetfac =       4                       ;max detuning divisor
        imap128 =       127/99                  ;mapping constant 99->127
        irscl   table   (iroct-irbase)/irrange*127,irsfn
        irscl   =       irscl*6
        iop     =       1                       ;start loop with op1
        iopfn   =       iop1fn
loop:
;---------------------------------read operator parameters
        ilvl    table   0,iopfn
        ivel    table   1,iopfn
        iegr1   table   2,iopfn
        iegr2   table   3,iopfn
        iegr3   table   4,iopfn
        iegr4   table   5,iopfn
        iegl1   table   6,iopfn
        iegl2   table   7,iopfn
        iegl3   table   8,iopfn
        iegl4   table   9,iopfn
        iams    table   10,iopfn
        imode   table   11,iopfn
        ifreq   table   12,iopfn
        idet    table   13,iopfn
        irss    table   14,iopfn
;----------------------------------initialize operator
        ihz     =       (imode > 0 ? ifreq : ibase * ifreq) + idet/idetfac
 iamp	=	ilvl/99		;rescale to 0 -> 1
        ivfac   table   ivel,ivsfn
        iegl1   =       iamp*iegl1
        iegl2   =       iamp*iegl2
        iegl3   =       iamp*iegl3
        iegl4   =       iamp*iegl4
        iegl1   =       iegl1*(1-ivfac)+iegl1*ivfac*iveloc
        iegl2   =       iegl2*(1-ivfac)+iegl2*ivfac*iveloc
        iegl3   =       iegl3*(1-ivfac)+iegl3*ivfac*iveloc
        iegl4   =       iegl4*(1-ivfac)+iegl4*ivfac*iveloc
        irs     =       irscl*irss
        iegr1   =       (iegr1+irs > 99 ? 99 : iegr1+irs)
        iegr2   =       (iegr2+irs > 99 ? 99 : iegr2+irs)
        iegr3   =       (iegr3+irs > 99 ? 99 : iegr3+irs)
        iegr4   =       (iegr4+irs > 99 ? 99 : iegr4+irs)
        irfn    =       (iegl1 > iegl4 ? irisefn : idecfn)
        iegd1   table   iegr1,irfn               ;convert rate->dur
        ipct1   table   iegl4,irfn+1             ;pct fn is next one
        ipct2   table   iegl1,irfn+1
        iegd1   =       abs(iegd1*ipct1-iegd1*ipct2)
        iegd1   =       (iegd1 == 0 ? .001 : iegd1)
        irfn    =       (iegl2 > iegl1 ? irisefn : idecfn)
        iegd2   table   iegr2,irfn
        ipct1   table   iegl1,irfn+1
        ipct2   table   iegl2,irfn+1
        iegd2   =       abs(iegd2*ipct1-iegd2*ipct2)
        iegd2   =       (iegd2 == 0 ? .001 : iegd2)
        irfn    =       (iegl3 > iegl2 ? irisefn : idecfn)
        iegd3   table   iegr3,irfn
        ipct1   table   iegl2,irfn+1
        ipct2   table   iegl3,irfn+1
        iegd3   =       abs(iegd3*ipct1-iegd3*ipct2)
        iegd3   =       (iegd3 == 0 ? .001 : iegd3)
        iegd4   table   iegr4,idecfn
                if      (iegl3 <= iegl4) igoto continue
        ipct1   table   iegl3,irfn+1
        ipct2   table   iegl4,irfn+1
        iegd4   =       abs(iegd4*ipct1-iegd4*ipct2)
        iegd4   =       (iegd4 == 0 ? .001 : iegd4)
continue:
                if      (iop > 1) igoto op2
op1:
        i1egd1  =       iegd1
        i1egd2  =       iegd2
        i1egd3  =       iegd3
        i1egd4  =       iegd4
        i1egl1  =       iegl1
        i1egl2  =       iegl2
        i1egl3  =       iegl3
        i1egl4  =       iegl4
        i1ams   =       iams
        i1hz    =       ihz
        iop     =       iop + 1
        iopfn   =       iop2fn
                igoto   loop
op2:            if      (iop > 2) igoto op3
        i2egd1  =       iegd1
        i2egd2  =       iegd2
        i2egd3  =       iegd3
        i2egd4  =       iegd4
        i2egl1  =       iegl1
        i2egl2  =       iegl2
        i2egl3  =       iegl3
        i2egl4  =       iegl4
        i2ams   =       iams
        i2hz    =       ihz
        iop     =       iop + 1
        iopfn   =       iop3fn
                igoto   loop
op3:            if      (iop > 3) igoto op4
        i3egd1  =       iegd1
        i3egd2  =       iegd2
        i3egd3  =       iegd3
        i3egd4  =       iegd4
        i3egl1  =       iegl1
        i3egl2  =       iegl2
        i3egl3  =       iegl3
        i3egl4  =       iegl4
        i3ams   =       iams
        i3hz    =       ihz
        iop     =       iop + 1
        iopfn   =       iop4fn
                igoto   loop
op4:            if      (iop > 4) igoto op5
        i4egd1  =       iegd1
        i4egd2  =       iegd2
        i4egd3  =       iegd3
        i4egd4  =       iegd4
        i4egl1  =       iegl1
        i4egl2  =       iegl2
        i4egl3  =       iegl3
        i4egl4  =       iegl4
        i4ams   =       iams
        i4hz    =       ihz
        iop     =       iop + 1
        iopfn   =       iop5fn
                igoto   loop
op5:            if      (iop > 5) igoto op6
        i5egd1  =       iegd1
        i5egd2  =       iegd2
        i5egd3  =       iegd3
        i5egd4  =       iegd4
        i5egl1  =       iegl1
        i5egl2  =       iegl2
        i5egl3  =       iegl3
        i5egl4  =       iegl4
        i5ams   =       iams
        i5hz    =       ihz
        iop     =       iop + 1
        iopfn   =       iop6fn
                igoto   loop
op6:
        i6egd1  =       iegd1
        i6egd2  =       iegd2
        i6egd3  =       iegd3
        i6egd4  =       iegd4
        i6egl1  =       iegl1
        i6egl2  =       iegl2
        i6egl3  =       iegl3
        i6egl4  =       iegl4
        i6ams   =       iams
        i6hz    =       ihz
;=====================================================================
                timout  idur,999,final          ;skip during final decay
        k1sus   linseg  i1egl4,i1egd1,i1egl1,i1egd2,i1egl2,i1egd3,i1egl3,1,i1egl3
        k2sus   linseg  i2egl4,i2egd1,i2egl1,i2egd2,i2egl2,i2egd3,i2egl3,1,i2egl3
        k3sus   linseg  i3egl4,i3egd1,i3egl1,i3egd2,i3egl2,i3egd3,i3egl3,1,i3egl3
        k4sus   linseg  i4egl4,i4egd1,i4egl1,i4egd2,i4egl2,i4egd3,i4egl3,1,i4egl3
        k5sus   linseg  i5egl4,i5egd1,i5egl1,i5egd2,i5egl2,i5egd3,i5egl3,1,i5egl3
        k6sus   linseg  i6egl4,i6egd1,i6egl1,i6egd2,i6egl2,i6egd3,i6egl3,1,i6egl3
        k1phs   =       k1sus
        k2phs   =       k2sus
        k3phs   =       k3sus
        k4phs   =       k4sus
        k5phs   =       k5sus
        k6phs   =       k6sus
                kgoto   output
final:
        k1fin   linseg  1,i1egd4,0,1,0
        k1phs   =       i1egl4+(k1sus-i1egl4)*k1fin
        k2fin   linseg  1,i2egd4,0,1,0
        k2phs   =       i2egl4+(k2sus-i2egl4)*k2fin
        k3fin   linseg  1,i3egd4,0,1,0
        k3phs   =       i3egl4+(k3sus-i3egl4)*k3fin
        k4fin   linseg  1,i4egd4,0,1,0
        k4phs   =       i4egl4+(k4sus-i4egl4)*k4fin
        k5fin   linseg  1,i5egd4,0,1,0
        k5phs   =       i5egl4+(k5sus-i5egl4)*k5fin
        k6fin   linseg  1,i6egd4,0,1,0
        k6phs   =       i6egl4+(k6sus-i6egl4)*k6fin
;------------------------------Algorithm 1---------------------------------;
                if      (k1fin+k3fin) > 0 kgoto output  ;test carrier sigs
                turnoff                 ;when carrier oscil(s) done, turn off.
output:
        k1gate  tablei  k1phs,iampfn                ;use iampfn for carriers
        k2gate  tablei  k2phs,idevfn                ;use idevfn for modulators
 	k3gate	tablei	k3phs,iampfn
 	k4gate	tablei	k4phs,idevfn
        k5gate  tablei  k5phs,idevfn
 	k6gate	tablei	k6phs,idevfn
	
        a6sig   init    0               ;initialize for feedback
        a6phs   phasor  i6hz            ;ops to be modulated must use phase...
        a6sig   tablei  a6phs+a6sig*(.2*ifeed),1,1,0,1 ; ...modulation, not fm!
        a6sig   =       a6sig*k6gate
        a5phs   phasor  i5hz
        a5sig   tablei  a5phs+a6sig,1,1,0,1
        a5sig   =       a5sig*k5gate
        a4phs   phasor  i4hz
        a4sig   tablei  a4phs+a5sig,1,1,0,1
        a4sig   =       a4sig*k4gate
        a3phs   phasor  i3hz
        a3sig   tablei  a3phs+a4sig,1,1,0,1
        a3sig   =       a3sig*k3gate
        a2sig   oscili  k2gate,i2hz,1
        a1phs   phasor  i1hz
        a1sig   tablei  a1phs+a2sig,1,1,0,1
        a1sig   =       a1sig*k1gate
                aout =  (a1sig+a3sig)*ipkamp
               
ga_bluemix_3_0 = ga_bluemix_3_0 +  aout
ga_bluemix_3_1 = ga_bluemix_3_1 +  aout

	endin

	instr 4	;oscillator (p6 = freq)
idur    =       p3                      ; duration
iamp    =       p4                      ; amplitude
ifn     =       p5                      ; function table number (waveform)
ifreq   =       p6                      ; frequency
ilr     =       p7                      ; 1.0 = left <-> 0.0 = right
aenv    linen   iamp, 1, idur, 3        ; simple envelope
aout    poscil  aenv, ifreq, ifn
ga_bluemix_4_0 = ga_bluemix_4_0 +  aout*ilr
ga_bluemix_4_1 = ga_bluemix_4_1 +  aout*(1-ilr)

	endin

	instr 5	;Blue Mixer Instrument
ga_bluemix_1_0 = ga_bluemix_1_0 * 0.4466836154
ga_bluemix_1_1 = ga_bluemix_1_1 * 0.4466836154
ga_bluemix_2_0 = ga_bluemix_2_0 * 0.3981072009
ga_bluemix_2_1 = ga_bluemix_2_1 * 0.3981072009
ga_bluemix_3_0 = ga_bluemix_3_0 * 2.2387211323
ga_bluemix_3_1 = ga_bluemix_3_1 * 2.2387211323
ga_bluemix_4_0 = ga_bluemix_4_0 * 1.3258671761
ga_bluemix_4_1 = ga_bluemix_4_1 * 1.3258671761
ga_bluemix_4_0, ga_bluemix_4_1	blueEffect0	ga_bluemix_4_0, ga_bluemix_4_1
a_bluesub_Master_0	sum	ga_bluemix_1_0, ga_bluemix_2_0, ga_bluemix_3_0, ga_bluemix_4_0
a_bluesub_Master_1	sum	ga_bluemix_1_1, ga_bluemix_2_1, ga_bluemix_3_1, ga_bluemix_4_1
outc a_bluesub_Master_0, a_bluesub_Master_1
ga_bluemix_1_0 = 0
ga_bluemix_1_1 = 0
ga_bluemix_2_0 = 0
ga_bluemix_2_1 = 0
ga_bluemix_3_0 = 0
ga_bluemix_3_1 = 0
ga_bluemix_4_0 = 0
ga_bluemix_4_1 = 0

	endin


</CsInstruments>

<CsScore>

; sine
f 300 0 262144 10 1
; [BLUEX7] - START STATIC TABLES; sine wave
f1     0       512     10      1
; operator output level to amp scale function (data from Chowning/Bristow)
f2     0       128     7       0       10      .003    10      .013       10      .031    10      .079    10      .188    10      .446       5       .690    5       1.068   5       1.639   5       2.512       5       3.894   5       6.029   5       9.263   4       13.119       29      13.119
; rate scaling function
f3     0       128     7       0       128     1
; eg rate rise function for lvl change between 0 and 99 (data from Opcode)
f4     0       128     -7      38      5       22.8    5       12      5       7.5     5       4.8     5       2.7     5       1.8     5       1.3       8       .737    3       .615    3       .505    3       .409    3       .321    6       .080    6       .055    2       .032    3       .024       3       .018    3       .014    3       .011    3       .008    3       .008    3       .007    3       .005    3       .003    32      .003
; eg rate rise percentage function
f5     0       128     -7      .00001  31      .00001  4       .02     5       .06     10      .14     10      .24     10      .35     10      .50       10      .70     5       .86     4       1.0     29      1.0
; eg rate decay function for lvl change between 0 and 99
f6     0       128     -7      318     4       181     5       115     5       63      5       39.7    5       20      5       11.2    5       7       8       5.66    3       3.98    6       1.99    3       1.34    3       .99     3       .71     5       .41     3       .15     3       .081       3       .068    3       .047    3       .037    3       .025    3       .02     3       .013    3       .008    36      .008
; eg rate decay percentage function
f7     0       128     -7      .00001  10      .25     10      .35     10     .43     10      .52     10      .59     10      .70     10      .77     10      .84     10      .92     9       1.0     29      1.0
; eg level to peak deviation mapping function (index in radians = Index / 2PI)
f8     0       128     -7      0       10      .000477 10      .002     10      .00493  10      .01257  10      .02992  10      .07098     5       .10981  5       .16997  5       .260855 5       .39979     5       .61974  5       .95954  5       1.47425 4       2.08795     29      2.08795
; velocity to amp factor mapping function (rough guess)
f9     0       129     9       .25     1       0
; velocity sensitivity scaling function
f10     0       8       -7      0       8       1
; feedback scaling function
f11     0       8       -7      0       8       7
; [BLUEX7] - END STATIC TABLES

; FTABLES FOR BLUEX7 INSTRUMENT: Default Bank 30 - SOFTSPACE4
f 12 0 32 -2 99 4 99 67 30 87 99 95 0 0 0 0 1 -1 0 0 

f 13 0 32 -2 92 0 99 35 99 87 99 99 99 0 0 0 1 0 0 0 

f 14 0 32 -2 71 2 99 32 99 87 99 0 0 0 0 0 1 0 0 0 

f 15 0 32 -2 88 4 99 39 99 99 99 0 0 0 0 0 1 0 0 0 

f 16 0 32 -2 65 6 99 39 99 99 99 0 0 0 0 0 1 0 0 0 

f 17 0 32 -2 87 0 99 99 99 99 99 99 99 0 0 0 1 0 0 0 



; FTABLES FOR BLUEX7 INSTRUMENT: Default Bank 9 - UNCLE BENS
f 18 0 32 -2 99 0 68 82 67 50 99 99 99 0 2 0 1 -1 0 0 

f 19 0 32 -2 82 0 67 99 84 21 99 99 99 0 0 0 1 0 0 0 

f 20 0 32 -2 64 0 99 99 53 73 99 99 0 0 0 0 1 0 0 0 

f 21 0 32 -2 82 6 99 62 70 58 99 99 0 0 0 0 1 0 0 0 

f 22 0 32 -2 99 0 99 84 61 32 99 99 71 0 0 0 1 0 0 0 

f 23 0 32 -2 99 0 99 99 50 48 99 99 0 0 0 0 1 0 0 0 



; FTABLES FOR BLUEX7 INSTRUMENT: Default Bank 32 - CHIMES
f 24 0 32 -2 75 0 97 20 20 26 99 90 80 0 0 0 1 -1 2 0 

f 25 0 32 -2 81 0 97 20 20 34 99 90 80 0 0 0 1 -1 2 0 

f 26 0 32 -2 81 0 17 99 20 26 0 90 80 0 0 0 1 -3 2 0 

f 27 0 32 -2 67 0 97 20 20 34 99 90 80 0 0 0 1 -1 2 0 

f 28 0 32 -2 84 2 26 99 20 33 0 90 80 0 0 0 1 3 2 0 

f 29 0 32 -2 66 2 97 20 20 34 99 90 80 0 0 0 1 -1 2 0 




; MIDI velocity level for BlueX& instruments
#define VELO #127#

; tempi
t 0 50 215 50 227 35





i3	3.5	0.5	480.0	$VELO.	
i3	4.0	0.5	560.0	$VELO.	
i3	4.5	0.5	560.0	$VELO.	
i3	6.0	0.5	480.0	$VELO.	
i3	6.5	0.5	560.0	$VELO.	
i3	7.0	0.5	480.0	$VELO.	
i3	8.0	0.5	720.0	$VELO.	
i3	8.5	0.5	480.0	$VELO.	
i3	9.0	0.5	480.0	$VELO.	
i3	9.5	0.5	560.0	$VELO.	
i3	10.0	0.5	480.0	$VELO.	
i3	10.5	0.5	480.0	$VELO.	
i3	11.0	0.5	720.0	$VELO.	
i3	11.5	0.5	540.0	$VELO.	
i3	12.0	0.5	560.0	$VELO.	
i3	12.5	0.5	540.0	$VELO.	
i3	13.0	0.5	480.0	$VELO.	
i3	13.5	0.5	480.0	$VELO.	
i3	14.0	0.5	480.0	$VELO.	
i3	14.5	0.5	540.0	$VELO.	
i3	15.0	0.5	560.0	$VELO.	
i3	15.5	0.5	480.0	$VELO.	
i3	16.0	0.5	720.0	$VELO.	
i3	16.5	0.5	480.0	$VELO.	
i3	17.0	0.5	720.0	$VELO.	
i3	17.5	0.5	540.0	$VELO.	
i3	18.0	0.5	480.0	$VELO.	
i3	18.5	0.5	540.0	$VELO.	
i3	19.0	0.5	560.0	$VELO.	
i3	20.0	0.5	560.0	$VELO.	
i3	20.5	0.5	480.0	$VELO.	
i3	21.0	0.5	560.0	$VELO.	
i3	21.5	0.5	720.0	$VELO.	
i3	22.0	0.5	560.0	$VELO.	
i3	22.5	0.5	540.0	$VELO.	
i3	23.0	0.5	480.0	$VELO.	
i3	23.5	0.5	560.0	$VELO.	
i3	24.0	0.5	480.0	$VELO.	
i3	24.5	0.5	540.0	$VELO.	
i3	25.0	0.5	560.0	$VELO.	
i3	25.5	0.5	540.0	$VELO.	
i3	26.0	0.5	480.0	$VELO.	
i3	26.5	0.5	540.0	$VELO.	
i3	27.0	0.5	560.0	$VELO.	
i3	27.5	0.5	560.0	$VELO.	
i3	28.0	0.5	560.0	$VELO.	
i3	28.5	0.5	420.0	$VELO.	
i3	29.0	0.5	720.0	$VELO.	
i3	29.5	0.5	480.0	$VELO.	
i3	30.0	0.5	480.0	$VELO.	
i3	30.5	0.5	540.0	$VELO.	
i3	31.0	0.5	560.0	$VELO.	
i3	31.5	0.5	540.0	$VELO.	
i3	32.0	0.5	480.0	$VELO.	
i3	32.5	0.5	420.0	$VELO.	
i3	33.0	0.5	720.0	$VELO.	
i3	33.5	0.5	540.0	$VELO.	
i3	34.0	0.5	720.0	$VELO.	
i3	19.5	0.5	560.0	$VELO.	
i3	5.0	0.5	560.0	$VELO.	
i3	5.5	0.5	540.0	$VELO.	
i3	7.5	0.5	560.0	$VELO.	
i3	3.0	0.5	720.0	$VELO.	
i3	34.5	0.5	540.0	$VELO.	
i3	35.5	0.5	480.0	$VELO.	
i3	36.0	0.5	560.0	$VELO.	
i3	36.5	0.5	560.0	$VELO.	
i3	38.0	0.5	480.0	$VELO.	
i3	38.5	0.5	560.0	$VELO.	
i3	39.0	0.5	480.0	$VELO.	
i3	40.0	0.5	720.0	$VELO.	
i3	40.5	0.5	480.0	$VELO.	
i3	41.0	0.5	480.0	$VELO.	
i3	41.5	0.5	560.0	$VELO.	
i3	42.0	0.5	480.0	$VELO.	
i3	42.5	0.5	480.0	$VELO.	
i3	43.0	0.5	720.0	$VELO.	
i3	43.5	0.5	540.0	$VELO.	
i3	44.0	0.5	560.0	$VELO.	
i3	44.5	0.5	540.0	$VELO.	
i3	45.0	0.5	480.0	$VELO.	
i3	45.5	0.5	480.0	$VELO.	
i3	46.0	0.5	480.0	$VELO.	
i3	46.5	0.5	540.0	$VELO.	
i3	47.0	0.5	560.0	$VELO.	
i3	47.5	0.5	480.0	$VELO.	
i3	48.0	0.5	720.0	$VELO.	
i3	48.5	0.5	480.0	$VELO.	
i3	49.0	0.5	720.0	$VELO.	
i3	49.5	0.5	540.0	$VELO.	
i3	50.0	0.5	480.0	$VELO.	
i3	50.5	0.5	540.0	$VELO.	
i3	51.0	0.5	560.0	$VELO.	
i3	52.0	0.5	560.0	$VELO.	
i3	52.5	0.5	480.0	$VELO.	
i3	53.0	0.5	560.0	$VELO.	
i3	53.5	0.5	720.0	$VELO.	
i3	54.0	0.5	560.0	$VELO.	
i3	54.5	0.5	540.0	$VELO.	
i3	55.0	0.5	480.0	$VELO.	
i3	55.5	0.5	560.0	$VELO.	
i3	56.0	0.5	480.0	$VELO.	
i3	56.5	0.5	540.0	$VELO.	
i3	57.0	0.5	560.0	$VELO.	
i3	57.5	0.5	540.0	$VELO.	
i3	58.0	0.5	480.0	$VELO.	
i3	58.5	0.5	540.0	$VELO.	
i3	59.0	0.5	560.0	$VELO.	
i3	59.5	0.5	560.0	$VELO.	
i3	60.0	0.5	560.0	$VELO.	
i3	60.5	0.5	420.0	$VELO.	
i3	61.0	0.5	720.0	$VELO.	
i3	61.5	0.5	480.0	$VELO.	
i3	62.0	0.5	480.0	$VELO.	
i3	62.5	0.5	540.0	$VELO.	
i3	63.0	0.5	560.0	$VELO.	
i3	63.5	0.5	540.0	$VELO.	
i3	64.0	0.5	480.0	$VELO.	
i3	64.5	0.5	420.0	$VELO.	
i3	65.0	0.5	720.0	$VELO.	
i3	65.5	0.5	540.0	$VELO.	
i3	66.0	0.5	720.0	$VELO.	
i3	51.5	0.5	560.0	$VELO.	
i3	37.0	0.5	560.0	$VELO.	
i3	37.5	0.5	540.0	$VELO.	
i3	39.5	0.5	560.0	$VELO.	
i3	35.0	0.5	720.0	$VELO.	
i3	66.5	0.5	540.0	$VELO.	
i3	67.5	0.5	480.0	$VELO.	
i3	68.0	0.5	560.0	$VELO.	
i3	68.5	0.5	560.0	$VELO.	
i3	70.0	0.5	480.0	$VELO.	
i3	70.5	0.5	560.0	$VELO.	
i3	71.0	0.5	480.0	$VELO.	
i3	72.0	0.5	720.0	$VELO.	
i3	72.5	0.5	480.0	$VELO.	
i3	73.0	0.5	480.0	$VELO.	
i3	73.5	0.5	560.0	$VELO.	
i3	74.0	0.5	480.0	$VELO.	
i3	74.5	0.5	480.0	$VELO.	
i3	75.0	0.5	720.0	$VELO.	
i3	75.5	0.5	540.0	$VELO.	
i3	76.0	0.5	560.0	$VELO.	
i3	76.5	0.5	540.0	$VELO.	
i3	77.0	0.5	480.0	$VELO.	
i3	77.5	0.5	480.0	$VELO.	
i3	78.0	0.5	480.0	$VELO.	
i3	78.5	0.5	540.0	$VELO.	
i3	79.0	0.5	560.0	$VELO.	
i3	79.5	0.5	480.0	$VELO.	
i3	80.0	0.5	720.0	$VELO.	
i3	80.5	0.5	480.0	$VELO.	
i3	81.0	0.5	720.0	$VELO.	
i3	81.5	0.5	540.0	$VELO.	
i3	82.0	0.5	480.0	$VELO.	
i3	82.5	0.5	540.0	$VELO.	
i3	83.0	0.5	560.0	$VELO.	
i3	84.0	0.5	560.0	$VELO.	
i3	84.5	0.5	480.0	$VELO.	
i3	85.0	0.5	560.0	$VELO.	
i3	85.5	0.5	720.0	$VELO.	
i3	86.0	0.5	560.0	$VELO.	
i3	86.5	0.5	540.0	$VELO.	
i3	87.0	0.5	480.0	$VELO.	
i3	87.5	0.5	560.0	$VELO.	
i3	88.0	0.5	480.0	$VELO.	
i3	88.5	0.5	540.0	$VELO.	
i3	89.0	0.5	560.0	$VELO.	
i3	89.5	0.5	540.0	$VELO.	
i3	90.0	0.5	480.0	$VELO.	
i3	90.5	0.5	540.0	$VELO.	
i3	91.0	0.5	560.0	$VELO.	
i3	91.5	0.5	560.0	$VELO.	
i3	92.0	0.5	560.0	$VELO.	
i3	92.5	0.5	420.0	$VELO.	
i3	93.0	0.5	720.0	$VELO.	
i3	93.5	0.5	480.0	$VELO.	
i3	94.0	0.5	480.0	$VELO.	
i3	94.5	0.5	540.0	$VELO.	
i3	95.0	0.5	560.0	$VELO.	
i3	95.5	0.5	540.0	$VELO.	
i3	96.0	0.5	480.0	$VELO.	
i3	96.5	0.5	420.0	$VELO.	
i3	97.0	0.5	720.0	$VELO.	
i3	97.5	0.5	540.0	$VELO.	
i3	98.0	0.5	720.0	$VELO.	
i3	83.5	0.5	560.0	$VELO.	
i3	69.0	0.5	560.0	$VELO.	
i3	69.5	0.5	540.0	$VELO.	
i3	71.5	0.5	560.0	$VELO.	
i3	67.0	0.5	720.0	$VELO.	
i3	98.5	0.5	540.0	$VELO.	
i3	99.5	0.5	480.0	$VELO.	
i3	100.0	0.5	560.0	$VELO.	
i3	100.5	0.5	560.0	$VELO.	
i3	102.0	0.5	480.0	$VELO.	
i3	102.5	0.5	560.0	$VELO.	
i3	103.0	0.5	480.0	$VELO.	
i3	104.0	0.5	720.0	$VELO.	
i3	104.5	0.5	480.0	$VELO.	
i3	105.0	0.5	480.0	$VELO.	
i3	105.5	0.5	560.0	$VELO.	
i3	106.0	0.5	480.0	$VELO.	
i3	106.5	0.5	480.0	$VELO.	
i3	107.0	0.5	720.0	$VELO.	
i3	107.5	0.5	540.0	$VELO.	
i3	108.0	0.5	560.0	$VELO.	
i3	108.5	0.5	540.0	$VELO.	
i3	109.0	0.5	480.0	$VELO.	
i3	109.5	0.5	480.0	$VELO.	
i3	110.0	0.5	480.0	$VELO.	
i3	110.5	0.5	540.0	$VELO.	
i3	111.0	0.5	560.0	$VELO.	
i3	111.5	0.5	480.0	$VELO.	
i3	112.0	0.5	720.0	$VELO.	
i3	112.5	0.5	480.0	$VELO.	
i3	113.0	0.5	720.0	$VELO.	
i3	113.5	0.5	540.0	$VELO.	
i3	114.0	0.5	480.0	$VELO.	
i3	114.5	0.5	540.0	$VELO.	
i3	115.0	0.5	560.0	$VELO.	
i3	116.0	0.5	560.0	$VELO.	
i3	116.5	0.5	480.0	$VELO.	
i3	117.0	0.5	560.0	$VELO.	
i3	117.5	0.5	720.0	$VELO.	
i3	118.0	0.5	560.0	$VELO.	
i3	118.5	0.5	540.0	$VELO.	
i3	119.0	0.5	480.0	$VELO.	
i3	119.5	0.5	560.0	$VELO.	
i3	120.0	0.5	480.0	$VELO.	
i3	120.5	0.5	540.0	$VELO.	
i3	121.0	0.5	560.0	$VELO.	
i3	121.5	0.5	540.0	$VELO.	
i3	122.0	0.5	480.0	$VELO.	
i3	122.5	0.5	540.0	$VELO.	
i3	123.0	0.5	560.0	$VELO.	
i3	123.5	0.5	560.0	$VELO.	
i3	124.0	0.5	560.0	$VELO.	
i3	124.5	0.5	420.0	$VELO.	
i3	125.0	0.5	720.0	$VELO.	
i3	125.5	0.5	480.0	$VELO.	
i3	126.0	0.5	480.0	$VELO.	
i3	126.5	0.5	540.0	$VELO.	
i3	127.0	0.5	560.0	$VELO.	
i3	127.5	0.5	540.0	$VELO.	
i3	128.0	0.5	480.0	$VELO.	
i3	128.5	0.5	420.0	$VELO.	
i3	129.0	0.5	720.0	$VELO.	
i3	129.5	0.5	540.0	$VELO.	
i3	130.0	0.5	720.0	$VELO.	
i3	115.5	0.5	560.0	$VELO.	
i3	101.0	0.5	560.0	$VELO.	
i3	101.5	0.5	540.0	$VELO.	
i3	103.5	0.5	560.0	$VELO.	
i3	99.0	0.5	720.0	$VELO.	
i3	130.5	0.5	540.0	$VELO.	
i3	131.5	0.5	480.0	$VELO.	
i3	132.0	0.5	560.0	$VELO.	
i3	132.5	0.5	560.0	$VELO.	
i3	134.0	0.5	480.0	$VELO.	
i3	134.5	0.5	560.0	$VELO.	
i3	135.0	0.5	480.0	$VELO.	
i3	136.0	0.5	720.0	$VELO.	
i3	136.5	0.5	480.0	$VELO.	
i3	137.0	0.5	480.0	$VELO.	
i3	137.5	0.5	560.0	$VELO.	
i3	138.0	0.5	480.0	$VELO.	
i3	138.5	0.5	480.0	$VELO.	
i3	139.0	0.5	720.0	$VELO.	
i3	139.5	0.5	540.0	$VELO.	
i3	140.0	0.5	560.0	$VELO.	
i3	140.5	0.5	540.0	$VELO.	
i3	141.0	0.5	480.0	$VELO.	
i3	141.5	0.5	480.0	$VELO.	
i3	142.0	0.5	480.0	$VELO.	
i3	142.5	0.5	540.0	$VELO.	
i3	143.0	0.5	560.0	$VELO.	
i3	143.5	0.5	480.0	$VELO.	
i3	144.0	0.5	720.0	$VELO.	
i3	144.5	0.5	480.0	$VELO.	
i3	145.0	0.5	720.0	$VELO.	
i3	145.5	0.5	540.0	$VELO.	
i3	146.0	0.5	480.0	$VELO.	
i3	146.5	0.5	540.0	$VELO.	
i3	147.0	0.5	560.0	$VELO.	
i3	148.0	0.5	560.0	$VELO.	
i3	148.5	0.5	480.0	$VELO.	
i3	149.0	0.5	560.0	$VELO.	
i3	149.5	0.5	720.0	$VELO.	
i3	150.0	0.5	560.0	$VELO.	
i3	150.5	0.5	540.0	$VELO.	
i3	151.0	0.5	480.0	$VELO.	
i3	151.5	0.5	560.0	$VELO.	
i3	152.0	0.5	480.0	$VELO.	
i3	152.5	0.5	540.0	$VELO.	
i3	153.0	0.5	560.0	$VELO.	
i3	153.5	0.5	540.0	$VELO.	
i3	154.0	0.5	480.0	$VELO.	
i3	154.5	0.5	540.0	$VELO.	
i3	155.0	0.5	560.0	$VELO.	
i3	155.5	0.5	560.0	$VELO.	
i3	156.0	0.5	560.0	$VELO.	
i3	156.5	0.5	420.0	$VELO.	
i3	157.0	0.5	720.0	$VELO.	
i3	157.5	0.5	480.0	$VELO.	
i3	158.0	0.5	480.0	$VELO.	
i3	158.5	0.5	540.0	$VELO.	
i3	159.0	0.5	560.0	$VELO.	
i3	159.5	0.5	540.0	$VELO.	
i3	160.0	0.5	480.0	$VELO.	
i3	160.5	0.5	420.0	$VELO.	
i3	161.0	0.5	720.0	$VELO.	
i3	161.5	0.5	540.0	$VELO.	
i3	162.0	0.5	720.0	$VELO.	
i3	147.5	0.5	560.0	$VELO.	
i3	133.0	0.5	560.0	$VELO.	
i3	133.5	0.5	540.0	$VELO.	
i3	135.5	0.5	560.0	$VELO.	
i3	131.0	0.5	720.0	$VELO.	
i3	162.5	0.5	540.0	$VELO.	
i3	163.5	0.5	480.0	$VELO.	
i3	164.0	0.5	560.0	$VELO.	
i3	164.5	0.5	560.0	$VELO.	
i3	166.0	0.5	480.0	$VELO.	
i3	166.5	0.5	560.0	$VELO.	
i3	167.0	0.5	480.0	$VELO.	
i3	168.0	0.5	720.0	$VELO.	
i3	168.5	0.5	480.0	$VELO.	
i3	169.0	0.5	480.0	$VELO.	
i3	169.5	0.5	560.0	$VELO.	
i3	170.0	0.5	480.0	$VELO.	
i3	170.5	0.5	480.0	$VELO.	
i3	171.0	0.5	720.0	$VELO.	
i3	171.5	0.5	540.0	$VELO.	
i3	172.0	0.5	560.0	$VELO.	
i3	172.5	0.5	540.0	$VELO.	
i3	173.0	0.5	480.0	$VELO.	
i3	173.5	0.5	480.0	$VELO.	
i3	174.0	0.5	480.0	$VELO.	
i3	174.5	0.5	540.0	$VELO.	
i3	175.0	0.5	560.0	$VELO.	
i3	175.5	0.5	480.0	$VELO.	
i3	176.0	0.5	720.0	$VELO.	
i3	176.5	0.5	480.0	$VELO.	
i3	177.0	0.5	720.0	$VELO.	
i3	177.5	0.5	540.0	$VELO.	
i3	178.0	0.5	480.0	$VELO.	
i3	178.5	0.5	540.0	$VELO.	
i3	179.0	0.5	560.0	$VELO.	
i3	180.0	0.5	560.0	$VELO.	
i3	180.5	0.5	480.0	$VELO.	
i3	181.0	0.5	560.0	$VELO.	
i3	181.5	0.5	720.0	$VELO.	
i3	182.0	0.5	560.0	$VELO.	
i3	182.5	0.5	540.0	$VELO.	
i3	183.0	0.5	480.0	$VELO.	
i3	183.5	0.5	560.0	$VELO.	
i3	184.0	0.5	480.0	$VELO.	
i3	184.5	0.5	540.0	$VELO.	
i3	185.0	0.5	560.0	$VELO.	
i3	185.5	0.5	540.0	$VELO.	
i3	186.0	0.5	480.0	$VELO.	
i3	186.5	0.5	540.0	$VELO.	
i3	187.0	0.5	560.0	$VELO.	
i3	187.5	0.5	560.0	$VELO.	
i3	188.0	0.5	560.0	$VELO.	
i3	188.5	0.5	420.0	$VELO.	
i3	189.0	0.5	720.0	$VELO.	
i3	189.5	0.5	480.0	$VELO.	
i3	190.0	0.5	480.0	$VELO.	
i3	190.5	0.5	540.0	$VELO.	
i3	191.0	0.5	560.0	$VELO.	
i3	191.5	0.5	540.0	$VELO.	
i3	192.0	0.5	480.0	$VELO.	
i3	192.5	0.5	420.0	$VELO.	
i3	193.0	0.5	720.0	$VELO.	
i3	193.5	0.5	540.0	$VELO.	
i3	194.0	0.5	720.0	$VELO.	
i3	179.5	0.5	560.0	$VELO.	
i3	165.0	0.5	560.0	$VELO.	
i3	165.5	0.5	540.0	$VELO.	
i3	167.5	0.5	560.0	$VELO.	
i3	163.0	0.5	720.0	$VELO.	
i3	194.5	0.5	540.0	$VELO.	
i3	195.5	0.5	480.0	$VELO.	
i3	196.0	0.5	560.0	$VELO.	
i3	196.5	0.5	560.0	$VELO.	
i3	198.0	0.5	480.0	$VELO.	
i3	198.5	0.5	560.0	$VELO.	
i3	199.0	0.5	480.0	$VELO.	
i3	200.0	0.5	720.0	$VELO.	
i3	200.5	0.5	480.0	$VELO.	
i3	201.0	0.5	480.0	$VELO.	
i3	201.5	0.5	560.0	$VELO.	
i3	202.0	0.5	480.0	$VELO.	
i3	202.5	0.5	480.0	$VELO.	
i3	203.0	0.5	720.0	$VELO.	
i3	203.5	0.5	540.0	$VELO.	
i3	204.0	0.5	560.0	$VELO.	
i3	204.5	0.5	540.0	$VELO.	
i3	205.0	0.5	480.0	$VELO.	
i3	205.5	0.5	480.0	$VELO.	
i3	206.0	0.5	480.0	$VELO.	
i3	206.5	0.5	540.0	$VELO.	
i3	207.0	0.5	560.0	$VELO.	
i3	207.5	0.5	480.0	$VELO.	
i3	208.0	0.5	720.0	$VELO.	
i3	208.5	0.5	480.0	$VELO.	
i3	209.0	0.5	720.0	$VELO.	
i3	209.5	0.5	540.0	$VELO.	
i3	210.0	0.5	480.0	$VELO.	
i3	210.5	0.5	540.0	$VELO.	
i3	211.0	0.5	560.0	$VELO.	
i3	212.0	0.5	560.0	$VELO.	
i3	212.5	0.5	480.0	$VELO.	
i3	213.0	0.5	560.0	$VELO.	
i3	213.5	0.5	720.0	$VELO.	
i3	214.0	0.5	560.0	$VELO.	
i3	214.5	0.5	540.0	$VELO.	
i3	215.0	0.5	480.0	$VELO.	
i3	215.5	0.5	560.0	$VELO.	
i3	216.0	0.5	480.0	$VELO.	
i3	216.5	0.5	540.0	$VELO.	
i3	217.0	0.5	560.0	$VELO.	
i3	217.5	0.5	540.0	$VELO.	
i3	218.0	0.5	480.0	$VELO.	
i3	218.5	0.5	540.0	$VELO.	
i3	219.0	0.5	560.0	$VELO.	
i3	219.5	0.5	560.0	$VELO.	
i3	220.0	0.5	560.0	$VELO.	
i3	220.5	0.5	420.0	$VELO.	
i3	221.0	0.5	720.0	$VELO.	
i3	221.5	0.5	480.0	$VELO.	
i3	222.0	0.5	480.0	$VELO.	
i3	222.5	0.5	540.0	$VELO.	
i3	223.0	0.5	560.0	$VELO.	
i3	223.5	0.5	540.0	$VELO.	
i3	224.0	0.5	480.0	$VELO.	
i3	224.5	0.5	420.0	$VELO.	
i3	225.0	0.5	720.0	$VELO.	
i3	225.5	0.5	540.0	$VELO.	
i3	226.0	0.5	720.0	$VELO.	
i3	211.5	0.5	560.0	$VELO.	
i3	197.0	0.5	560.0	$VELO.	
i3	197.5	0.5	540.0	$VELO.	
i3	199.5	0.5	560.0	$VELO.	
i3	195.0	0.5	720.0	$VELO.	
i3	226.5	0.5	540.0	$VELO.	
i3	227.0	5	480.0	$VELO.	
i3	3.5	0.5	540.0	$VELO.	
i3	4.0	0.5	840.0	$VELO.	
i3	4.5	0.5	800.0	$VELO.	
i3	6.0	0.5	720.0	$VELO.	
i3	6.5	0.5	800.0	$VELO.	
i3	7.0	0.5	800.0	$VELO.	
i3	8.0	0.5	800.0	$VELO.	
i3	8.5	0.5	672.0	$VELO.	
i3	9.0	0.5	672.0	$VELO.	
i3	9.5	0.5	672.0	$VELO.	
i3	10.0	0.5	720.0	$VELO.	
i3	10.5	0.5	800.0	$VELO.	
i3	11.0	0.5	720.0	$VELO.	
i3	11.5	0.5	672.0	$VELO.	
i3	12.0	0.5	720.0	$VELO.	
i3	12.5	0.5	800.0	$VELO.	
i3	13.0	0.5	672.0	$VELO.	
i3	13.5	0.5	800.0	$VELO.	
i3	14.0	0.5	720.0	$VELO.	
i3	14.5	0.5	672.0	$VELO.	
i3	15.0	0.5	540.0	$VELO.	
i3	15.5	0.5	672.0	$VELO.	
i3	16.0	0.5	800.0	$VELO.	
i3	16.5	0.5	672.0	$VELO.	
i3	17.0	0.5	672.0	$VELO.	
i3	17.5	0.5	672.0	$VELO.	
i3	18.0	0.5	720.0	$VELO.	
i3	18.5	0.5	800.0	$VELO.	
i3	19.0	0.5	720.0	$VELO.	
i3	20.0	0.5	800.0	$VELO.	
i3	20.5	0.5	540.0	$VELO.	
i3	21.0	0.5	800.0	$VELO.	
i3	21.5	0.5	672.0	$VELO.	
i3	22.0	0.5	720.0	$VELO.	
i3	22.5	0.5	800.0	$VELO.	
i3	23.0	0.5	800.0	$VELO.	
i3	23.5	0.5	800.0	$VELO.	
i3	24.0	0.5	720.0	$VELO.	
i3	24.5	0.5	672.0	$VELO.	
i3	25.0	0.5	720.0	$VELO.	
i3	25.5	0.5	540.0	$VELO.	
i3	26.0	0.5	800.0	$VELO.	
i3	26.5	0.5	800.0	$VELO.	
i3	27.0	0.5	672.0	$VELO.	
i3	27.5	0.5	800.0	$VELO.	
i3	28.0	0.5	800.0	$VELO.	
i3	28.5	0.5	540.0	$VELO.	
i3	29.0	0.5	672.0	$VELO.	
i3	29.5	0.5	800.0	$VELO.	
i3	30.0	0.5	672.0	$VELO.	
i3	30.5	0.5	800.0	$VELO.	
i3	31.0	0.5	720.0	$VELO.	
i3	31.5	0.5	672.0	$VELO.	
i3	32.0	0.5	672.0	$VELO.	
i3	32.5	0.5	672.0	$VELO.	
i3	33.0	0.5	800.0	$VELO.	
i3	33.5	0.5	540.0	$VELO.	
i3	34.0	0.5	720.0	$VELO.	
i3	19.5	0.5	540.0	$VELO.	
i3	5.0	0.5	720.0	$VELO.	
i3	5.5	0.5	672.0	$VELO.	
i3	7.5	0.5	540.0	$VELO.	
i3	3.0	0.5	720.0	$VELO.	
i3	34.5	0.5	540.0	$VELO.	
i3	35.5	0.5	540.0	$VELO.	
i3	36.0	0.5	840.0	$VELO.	
i3	36.5	0.5	800.0	$VELO.	
i3	38.0	0.5	720.0	$VELO.	
i3	38.5	0.5	800.0	$VELO.	
i3	39.0	0.5	800.0	$VELO.	
i3	40.0	0.5	800.0	$VELO.	
i3	40.5	0.5	672.0	$VELO.	
i3	41.0	0.5	672.0	$VELO.	
i3	41.5	0.5	672.0	$VELO.	
i3	42.0	0.5	720.0	$VELO.	
i3	42.5	0.5	800.0	$VELO.	
i3	43.0	0.5	720.0	$VELO.	
i3	43.5	0.5	672.0	$VELO.	
i3	44.0	0.5	720.0	$VELO.	
i3	44.5	0.5	800.0	$VELO.	
i3	45.0	0.5	672.0	$VELO.	
i3	45.5	0.5	800.0	$VELO.	
i3	46.0	0.5	720.0	$VELO.	
i3	46.5	0.5	672.0	$VELO.	
i3	47.0	0.5	540.0	$VELO.	
i3	47.5	0.5	672.0	$VELO.	
i3	48.0	0.5	800.0	$VELO.	
i3	48.5	0.5	672.0	$VELO.	
i3	49.0	0.5	672.0	$VELO.	
i3	49.5	0.5	672.0	$VELO.	
i3	50.0	0.5	720.0	$VELO.	
i3	50.5	0.5	800.0	$VELO.	
i3	51.0	0.5	720.0	$VELO.	
i3	52.0	0.5	800.0	$VELO.	
i3	52.5	0.5	540.0	$VELO.	
i3	53.0	0.5	800.0	$VELO.	
i3	53.5	0.5	672.0	$VELO.	
i3	54.0	0.5	720.0	$VELO.	
i3	54.5	0.5	800.0	$VELO.	
i3	55.0	0.5	800.0	$VELO.	
i3	55.5	0.5	800.0	$VELO.	
i3	56.0	0.5	720.0	$VELO.	
i3	56.5	0.5	672.0	$VELO.	
i3	57.0	0.5	720.0	$VELO.	
i3	57.5	0.5	540.0	$VELO.	
i3	58.0	0.5	800.0	$VELO.	
i3	58.5	0.5	800.0	$VELO.	
i3	59.0	0.5	672.0	$VELO.	
i3	59.5	0.5	800.0	$VELO.	
i3	60.0	0.5	800.0	$VELO.	
i3	60.5	0.5	540.0	$VELO.	
i3	61.0	0.5	672.0	$VELO.	
i3	61.5	0.5	800.0	$VELO.	
i3	62.0	0.5	672.0	$VELO.	
i3	62.5	0.5	800.0	$VELO.	
i3	63.0	0.5	720.0	$VELO.	
i3	63.5	0.5	672.0	$VELO.	
i3	64.0	0.5	672.0	$VELO.	
i3	64.5	0.5	672.0	$VELO.	
i3	65.0	0.5	800.0	$VELO.	
i3	65.5	0.5	540.0	$VELO.	
i3	66.0	0.5	720.0	$VELO.	
i3	51.5	0.5	540.0	$VELO.	
i3	37.0	0.5	720.0	$VELO.	
i3	37.5	0.5	672.0	$VELO.	
i3	39.5	0.5	540.0	$VELO.	
i3	35.0	0.5	720.0	$VELO.	
i3	66.5	0.5	540.0	$VELO.	
i3	67.5	0.5	540.0	$VELO.	
i3	68.0	0.5	840.0	$VELO.	
i3	68.5	0.5	800.0	$VELO.	
i3	70.0	0.5	720.0	$VELO.	
i3	70.5	0.5	800.0	$VELO.	
i3	71.0	0.5	800.0	$VELO.	
i3	72.0	0.5	800.0	$VELO.	
i3	72.5	0.5	672.0	$VELO.	
i3	73.0	0.5	672.0	$VELO.	
i3	73.5	0.5	672.0	$VELO.	
i3	74.0	0.5	720.0	$VELO.	
i3	74.5	0.5	800.0	$VELO.	
i3	75.0	0.5	720.0	$VELO.	
i3	75.5	0.5	672.0	$VELO.	
i3	76.0	0.5	720.0	$VELO.	
i3	76.5	0.5	800.0	$VELO.	
i3	77.0	0.5	672.0	$VELO.	
i3	77.5	0.5	800.0	$VELO.	
i3	78.0	0.5	720.0	$VELO.	
i3	78.5	0.5	672.0	$VELO.	
i3	79.0	0.5	540.0	$VELO.	
i3	79.5	0.5	672.0	$VELO.	
i3	80.0	0.5	800.0	$VELO.	
i3	80.5	0.5	672.0	$VELO.	
i3	81.0	0.5	672.0	$VELO.	
i3	81.5	0.5	672.0	$VELO.	
i3	82.0	0.5	720.0	$VELO.	
i3	82.5	0.5	800.0	$VELO.	
i3	83.0	0.5	720.0	$VELO.	
i3	84.0	0.5	800.0	$VELO.	
i3	84.5	0.5	540.0	$VELO.	
i3	85.0	0.5	800.0	$VELO.	
i3	85.5	0.5	672.0	$VELO.	
i3	86.0	0.5	720.0	$VELO.	
i3	86.5	0.5	800.0	$VELO.	
i3	87.0	0.5	800.0	$VELO.	
i3	87.5	0.5	800.0	$VELO.	
i3	88.0	0.5	720.0	$VELO.	
i3	88.5	0.5	672.0	$VELO.	
i3	89.0	0.5	720.0	$VELO.	
i3	89.5	0.5	540.0	$VELO.	
i3	90.0	0.5	800.0	$VELO.	
i3	90.5	0.5	800.0	$VELO.	
i3	91.0	0.5	672.0	$VELO.	
i3	91.5	0.5	800.0	$VELO.	
i3	92.0	0.5	800.0	$VELO.	
i3	92.5	0.5	540.0	$VELO.	
i3	93.0	0.5	672.0	$VELO.	
i3	93.5	0.5	800.0	$VELO.	
i3	94.0	0.5	672.0	$VELO.	
i3	94.5	0.5	800.0	$VELO.	
i3	95.0	0.5	720.0	$VELO.	
i3	95.5	0.5	672.0	$VELO.	
i3	96.0	0.5	672.0	$VELO.	
i3	96.5	0.5	672.0	$VELO.	
i3	97.0	0.5	800.0	$VELO.	
i3	97.5	0.5	540.0	$VELO.	
i3	98.0	0.5	720.0	$VELO.	
i3	83.5	0.5	540.0	$VELO.	
i3	69.0	0.5	720.0	$VELO.	
i3	69.5	0.5	672.0	$VELO.	
i3	71.5	0.5	540.0	$VELO.	
i3	67.0	0.5	720.0	$VELO.	
i3	98.5	0.5	540.0	$VELO.	
i3	99.5	0.5	540.0	$VELO.	
i3	100.0	0.5	840.0	$VELO.	
i3	100.5	0.5	800.0	$VELO.	
i3	102.0	0.5	720.0	$VELO.	
i3	102.5	0.5	800.0	$VELO.	
i3	103.0	0.5	800.0	$VELO.	
i3	104.0	0.5	800.0	$VELO.	
i3	104.5	0.5	672.0	$VELO.	
i3	105.0	0.5	672.0	$VELO.	
i3	105.5	0.5	672.0	$VELO.	
i3	106.0	0.5	720.0	$VELO.	
i3	106.5	0.5	800.0	$VELO.	
i3	107.0	0.5	720.0	$VELO.	
i3	107.5	0.5	672.0	$VELO.	
i3	108.0	0.5	720.0	$VELO.	
i3	108.5	0.5	800.0	$VELO.	
i3	109.0	0.5	672.0	$VELO.	
i3	109.5	0.5	800.0	$VELO.	
i3	110.0	0.5	720.0	$VELO.	
i3	110.5	0.5	672.0	$VELO.	
i3	111.0	0.5	540.0	$VELO.	
i3	111.5	0.5	672.0	$VELO.	
i3	112.0	0.5	800.0	$VELO.	
i3	112.5	0.5	672.0	$VELO.	
i3	113.0	0.5	672.0	$VELO.	
i3	113.5	0.5	672.0	$VELO.	
i3	114.0	0.5	720.0	$VELO.	
i3	114.5	0.5	800.0	$VELO.	
i3	115.0	0.5	720.0	$VELO.	
i3	116.0	0.5	800.0	$VELO.	
i3	116.5	0.5	540.0	$VELO.	
i3	117.0	0.5	800.0	$VELO.	
i3	117.5	0.5	672.0	$VELO.	
i3	118.0	0.5	720.0	$VELO.	
i3	118.5	0.5	800.0	$VELO.	
i3	119.0	0.5	800.0	$VELO.	
i3	119.5	0.5	800.0	$VELO.	
i3	120.0	0.5	720.0	$VELO.	
i3	120.5	0.5	672.0	$VELO.	
i3	121.0	0.5	720.0	$VELO.	
i3	121.5	0.5	540.0	$VELO.	
i3	122.0	0.5	800.0	$VELO.	
i3	122.5	0.5	800.0	$VELO.	
i3	123.0	0.5	672.0	$VELO.	
i3	123.5	0.5	800.0	$VELO.	
i3	124.0	0.5	800.0	$VELO.	
i3	124.5	0.5	540.0	$VELO.	
i3	125.0	0.5	672.0	$VELO.	
i3	125.5	0.5	800.0	$VELO.	
i3	126.0	0.5	672.0	$VELO.	
i3	126.5	0.5	800.0	$VELO.	
i3	127.0	0.5	720.0	$VELO.	
i3	127.5	0.5	672.0	$VELO.	
i3	128.0	0.5	672.0	$VELO.	
i3	128.5	0.5	672.0	$VELO.	
i3	129.0	0.5	800.0	$VELO.	
i3	129.5	0.5	540.0	$VELO.	
i3	130.0	0.5	720.0	$VELO.	
i3	115.5	0.5	540.0	$VELO.	
i3	101.0	0.5	720.0	$VELO.	
i3	101.5	0.5	672.0	$VELO.	
i3	103.5	0.5	540.0	$VELO.	
i3	99.0	0.5	720.0	$VELO.	
i3	130.5	0.5	540.0	$VELO.	
i3	131.5	0.5	540.0	$VELO.	
i3	132.0	0.5	840.0	$VELO.	
i3	132.5	0.5	800.0	$VELO.	
i3	134.0	0.5	720.0	$VELO.	
i3	134.5	0.5	800.0	$VELO.	
i3	135.0	0.5	800.0	$VELO.	
i3	136.0	0.5	800.0	$VELO.	
i3	136.5	0.5	672.0	$VELO.	
i3	137.0	0.5	672.0	$VELO.	
i3	137.5	0.5	672.0	$VELO.	
i3	138.0	0.5	720.0	$VELO.	
i3	138.5	0.5	800.0	$VELO.	
i3	139.0	0.5	720.0	$VELO.	
i3	139.5	0.5	672.0	$VELO.	
i3	140.0	0.5	720.0	$VELO.	
i3	140.5	0.5	800.0	$VELO.	
i3	141.0	0.5	672.0	$VELO.	
i3	141.5	0.5	800.0	$VELO.	
i3	142.0	0.5	720.0	$VELO.	
i3	142.5	0.5	672.0	$VELO.	
i3	143.0	0.5	540.0	$VELO.	
i3	143.5	0.5	672.0	$VELO.	
i3	144.0	0.5	800.0	$VELO.	
i3	144.5	0.5	672.0	$VELO.	
i3	145.0	0.5	672.0	$VELO.	
i3	145.5	0.5	672.0	$VELO.	
i3	146.0	0.5	720.0	$VELO.	
i3	146.5	0.5	800.0	$VELO.	
i3	147.0	0.5	720.0	$VELO.	
i3	148.0	0.5	800.0	$VELO.	
i3	148.5	0.5	540.0	$VELO.	
i3	149.0	0.5	800.0	$VELO.	
i3	149.5	0.5	672.0	$VELO.	
i3	150.0	0.5	720.0	$VELO.	
i3	150.5	0.5	800.0	$VELO.	
i3	151.0	0.5	800.0	$VELO.	
i3	151.5	0.5	800.0	$VELO.	
i3	152.0	0.5	720.0	$VELO.	
i3	152.5	0.5	672.0	$VELO.	
i3	153.0	0.5	720.0	$VELO.	
i3	153.5	0.5	540.0	$VELO.	
i3	154.0	0.5	800.0	$VELO.	
i3	154.5	0.5	800.0	$VELO.	
i3	155.0	0.5	672.0	$VELO.	
i3	155.5	0.5	800.0	$VELO.	
i3	156.0	0.5	800.0	$VELO.	
i3	156.5	0.5	540.0	$VELO.	
i3	157.0	0.5	672.0	$VELO.	
i3	157.5	0.5	800.0	$VELO.	
i3	158.0	0.5	672.0	$VELO.	
i3	158.5	0.5	800.0	$VELO.	
i3	159.0	0.5	720.0	$VELO.	
i3	159.5	0.5	672.0	$VELO.	
i3	160.0	0.5	672.0	$VELO.	
i3	160.5	0.5	672.0	$VELO.	
i3	161.0	0.5	800.0	$VELO.	
i3	161.5	0.5	540.0	$VELO.	
i3	162.0	0.5	720.0	$VELO.	
i3	147.5	0.5	540.0	$VELO.	
i3	133.0	0.5	720.0	$VELO.	
i3	133.5	0.5	672.0	$VELO.	
i3	135.5	0.5	540.0	$VELO.	
i3	131.0	0.5	720.0	$VELO.	
i3	162.5	0.5	540.0	$VELO.	
i3	163.5	0.5	540.0	$VELO.	
i3	164.0	0.5	840.0	$VELO.	
i3	164.5	0.5	800.0	$VELO.	
i3	166.0	0.5	720.0	$VELO.	
i3	166.5	0.5	800.0	$VELO.	
i3	167.0	0.5	800.0	$VELO.	
i3	168.0	0.5	800.0	$VELO.	
i3	168.5	0.5	672.0	$VELO.	
i3	169.0	0.5	672.0	$VELO.	
i3	169.5	0.5	672.0	$VELO.	
i3	170.0	0.5	720.0	$VELO.	
i3	170.5	0.5	800.0	$VELO.	
i3	171.0	0.5	720.0	$VELO.	
i3	171.5	0.5	672.0	$VELO.	
i3	172.0	0.5	720.0	$VELO.	
i3	172.5	0.5	800.0	$VELO.	
i3	173.0	0.5	672.0	$VELO.	
i3	173.5	0.5	800.0	$VELO.	
i3	174.0	0.5	720.0	$VELO.	
i3	174.5	0.5	672.0	$VELO.	
i3	175.0	0.5	540.0	$VELO.	
i3	175.5	0.5	672.0	$VELO.	
i3	176.0	0.5	800.0	$VELO.	
i3	176.5	0.5	672.0	$VELO.	
i3	177.0	0.5	672.0	$VELO.	
i3	177.5	0.5	672.0	$VELO.	
i3	178.0	0.5	720.0	$VELO.	
i3	178.5	0.5	800.0	$VELO.	
i3	179.0	0.5	720.0	$VELO.	
i3	180.0	0.5	800.0	$VELO.	
i3	180.5	0.5	540.0	$VELO.	
i3	181.0	0.5	800.0	$VELO.	
i3	181.5	0.5	672.0	$VELO.	
i3	182.0	0.5	720.0	$VELO.	
i3	182.5	0.5	800.0	$VELO.	
i3	183.0	0.5	800.0	$VELO.	
i3	183.5	0.5	800.0	$VELO.	
i3	184.0	0.5	720.0	$VELO.	
i3	184.5	0.5	672.0	$VELO.	
i3	185.0	0.5	720.0	$VELO.	
i3	185.5	0.5	540.0	$VELO.	
i3	186.0	0.5	800.0	$VELO.	
i3	186.5	0.5	800.0	$VELO.	
i3	187.0	0.5	672.0	$VELO.	
i3	187.5	0.5	800.0	$VELO.	
i3	188.0	0.5	800.0	$VELO.	
i3	188.5	0.5	540.0	$VELO.	
i3	189.0	0.5	672.0	$VELO.	
i3	189.5	0.5	800.0	$VELO.	
i3	190.0	0.5	672.0	$VELO.	
i3	190.5	0.5	800.0	$VELO.	
i3	191.0	0.5	720.0	$VELO.	
i3	191.5	0.5	672.0	$VELO.	
i3	192.0	0.5	672.0	$VELO.	
i3	192.5	0.5	672.0	$VELO.	
i3	193.0	0.5	800.0	$VELO.	
i3	193.5	0.5	540.0	$VELO.	
i3	194.0	0.5	720.0	$VELO.	
i3	179.5	0.5	540.0	$VELO.	
i3	165.0	0.5	720.0	$VELO.	
i3	165.5	0.5	672.0	$VELO.	
i3	167.5	0.5	540.0	$VELO.	
i3	163.0	0.5	720.0	$VELO.	
i3	194.5	0.5	540.0	$VELO.	
i3	195.5	0.5	540.0	$VELO.	
i3	196.0	0.5	840.0	$VELO.	
i3	196.5	0.5	800.0	$VELO.	
i3	198.0	0.5	720.0	$VELO.	
i3	198.5	0.5	800.0	$VELO.	
i3	199.0	0.5	800.0	$VELO.	
i3	200.0	0.5	800.0	$VELO.	
i3	200.5	0.5	672.0	$VELO.	
i3	201.0	0.5	672.0	$VELO.	
i3	201.5	0.5	672.0	$VELO.	
i3	202.0	0.5	720.0	$VELO.	
i3	202.5	0.5	800.0	$VELO.	
i3	203.0	0.5	720.0	$VELO.	
i3	203.5	0.5	672.0	$VELO.	
i3	204.0	0.5	720.0	$VELO.	
i3	204.5	0.5	800.0	$VELO.	
i3	205.0	0.5	672.0	$VELO.	
i3	205.5	0.5	800.0	$VELO.	
i3	206.0	0.5	720.0	$VELO.	
i3	206.5	0.5	672.0	$VELO.	
i3	207.0	0.5	540.0	$VELO.	
i3	207.5	0.5	672.0	$VELO.	
i3	208.0	0.5	800.0	$VELO.	
i3	208.5	0.5	672.0	$VELO.	
i3	209.0	0.5	672.0	$VELO.	
i3	209.5	0.5	672.0	$VELO.	
i3	210.0	0.5	720.0	$VELO.	
i3	210.5	0.5	800.0	$VELO.	
i3	211.0	0.5	720.0	$VELO.	
i3	212.0	0.5	800.0	$VELO.	
i3	212.5	0.5	540.0	$VELO.	
i3	213.0	0.5	800.0	$VELO.	
i3	213.5	0.5	672.0	$VELO.	
i3	214.0	0.5	720.0	$VELO.	
i3	214.5	0.5	800.0	$VELO.	
i3	215.0	0.5	800.0	$VELO.	
i3	215.5	0.5	800.0	$VELO.	
i3	216.0	0.5	720.0	$VELO.	
i3	216.5	0.5	672.0	$VELO.	
i3	217.0	0.5	720.0	$VELO.	
i3	217.5	0.5	540.0	$VELO.	
i3	218.0	0.5	800.0	$VELO.	
i3	218.5	0.5	800.0	$VELO.	
i3	219.0	0.5	672.0	$VELO.	
i3	219.5	0.5	800.0	$VELO.	
i3	220.0	0.5	800.0	$VELO.	
i3	220.5	0.5	540.0	$VELO.	
i3	221.0	0.5	672.0	$VELO.	
i3	221.5	0.5	800.0	$VELO.	
i3	222.0	0.5	672.0	$VELO.	
i3	222.5	0.5	800.0	$VELO.	
i3	223.0	0.5	720.0	$VELO.	
i3	223.5	0.5	672.0	$VELO.	
i3	224.0	0.5	672.0	$VELO.	
i3	224.5	0.5	672.0	$VELO.	
i3	225.0	0.5	800.0	$VELO.	
i3	225.5	0.5	540.0	$VELO.	
i3	226.0	0.5	720.0	$VELO.	
i3	211.5	0.5	540.0	$VELO.	
i3	197.0	0.5	720.0	$VELO.	
i3	197.5	0.5	672.0	$VELO.	
i3	199.5	0.5	540.0	$VELO.	
i3	195.0	0.5	720.0	$VELO.	
i3	226.5	0.5	540.0	$VELO.	
i3	227.0	5	480.0	$VELO.	
i1	36.5	1.5	240.0	$VELO.	
i1	38.0	1.5	280.0	$VELO.	
i1	39.5	1.5	280.0	$VELO.	
i1	44.0	1.5	240.0	$VELO.	
i1	45.5	1.5	280.0	$VELO.	
i1	47.0	1.5	240.0	$VELO.	
i1	50.0	1.5	360.0	$VELO.	
i1	51.5	1.5	240.0	$VELO.	
i1	53.0	1.5	240.0	$VELO.	
i1	54.5	1.5	280.0	$VELO.	
i1	56.0	1.5	240.0	$VELO.	
i1	57.5	1.5	240.0	$VELO.	
i1	59.0	1.5	360.0	$VELO.	
i1	60.5	1.5	270.0	$VELO.	
i1	62.0	1.5	280.0	$VELO.	
i1	63.5	1.5	270.0	$VELO.	
i1	65.0	1.5	240.0	$VELO.	
i1	66.5	1.5	240.0	$VELO.	
i1	68.0	1.5	240.0	$VELO.	
i1	69.5	1.5	270.0	$VELO.	
i1	71.0	1.5	280.0	$VELO.	
i1	72.5	1.5	240.0	$VELO.	
i1	74.0	1.5	360.0	$VELO.	
i1	75.5	1.5	240.0	$VELO.	
i1	77.0	1.5	360.0	$VELO.	
i1	78.5	1.5	270.0	$VELO.	
i1	80.0	1.5	240.0	$VELO.	
i1	81.5	1.5	270.0	$VELO.	
i1	83.0	1.5	280.0	$VELO.	
i1	86.0	1.5	280.0	$VELO.	
i1	87.5	1.5	240.0	$VELO.	
i1	89.0	1.5	280.0	$VELO.	
i1	90.5	1.5	360.0	$VELO.	
i1	92.0	1.5	280.0	$VELO.	
i1	93.5	1.5	270.0	$VELO.	
i1	95.0	1.5	240.0	$VELO.	
i1	96.5	1.5	280.0	$VELO.	
i1	98.0	1.5	240.0	$VELO.	
i1	99.5	1.5	270.0	$VELO.	
i1	101.0	1.5	280.0	$VELO.	
i1	102.5	1.5	270.0	$VELO.	
i1	104.0	1.5	240.0	$VELO.	
i1	105.5	1.5	270.0	$VELO.	
i1	107.0	1.5	280.0	$VELO.	
i1	108.5	1.5	280.0	$VELO.	
i1	110.0	1.5	280.0	$VELO.	
i1	111.5	1.5	210.0	$VELO.	
i1	113.0	1.5	360.0	$VELO.	
i1	114.5	1.5	240.0	$VELO.	
i1	116.0	1.5	240.0	$VELO.	
i1	117.5	1.5	270.0	$VELO.	
i1	119.0	1.5	280.0	$VELO.	
i1	120.5	1.5	270.0	$VELO.	
i1	122.0	1.5	240.0	$VELO.	
i1	123.5	1.5	210.0	$VELO.	
i1	125.0	1.5	360.0	$VELO.	
i1	126.5	1.5	270.0	$VELO.	
i1	128.0	1.5	360.0	$VELO.	
i1	84.5	1.5	280.0	$VELO.	
i1	41.0	1.5	280.0	$VELO.	
i1	42.5	1.5	270.0	$VELO.	
i1	48.5	1.5	280.0	$VELO.	
i1	35.0	1.5	360.0	$VELO.	
i1	129.5	1.5	270.0	$VELO.	
i1	132.5	1.5	240.0	$VELO.	
i1	134.0	1.5	280.0	$VELO.	
i1	135.5	1.5	280.0	$VELO.	
i1	140.0	1.5	240.0	$VELO.	
i1	141.5	1.5	280.0	$VELO.	
i1	143.0	1.5	240.0	$VELO.	
i1	146.0	1.5	360.0	$VELO.	
i1	147.5	1.5	240.0	$VELO.	
i1	149.0	1.5	240.0	$VELO.	
i1	150.5	1.5	280.0	$VELO.	
i1	152.0	1.5	240.0	$VELO.	
i1	153.5	1.5	240.0	$VELO.	
i1	155.0	1.5	360.0	$VELO.	
i1	156.5	1.5	270.0	$VELO.	
i1	158.0	1.5	280.0	$VELO.	
i1	159.5	1.5	270.0	$VELO.	
i1	161.0	1.5	240.0	$VELO.	
i1	162.5	1.5	240.0	$VELO.	
i1	164.0	1.5	240.0	$VELO.	
i1	165.5	1.5	270.0	$VELO.	
i1	167.0	1.5	280.0	$VELO.	
i1	168.5	1.5	240.0	$VELO.	
i1	170.0	1.5	360.0	$VELO.	
i1	171.5	1.5	240.0	$VELO.	
i1	173.0	1.5	360.0	$VELO.	
i1	174.5	1.5	270.0	$VELO.	
i1	176.0	1.5	240.0	$VELO.	
i1	177.5	1.5	270.0	$VELO.	
i1	179.0	1.5	280.0	$VELO.	
i1	182.0	1.5	280.0	$VELO.	
i1	183.5	1.5	240.0	$VELO.	
i1	185.0	1.5	280.0	$VELO.	
i1	186.5	1.5	360.0	$VELO.	
i1	188.0	1.5	280.0	$VELO.	
i1	189.5	1.5	270.0	$VELO.	
i1	191.0	1.5	240.0	$VELO.	
i1	192.5	1.5	280.0	$VELO.	
i1	194.0	1.5	240.0	$VELO.	
i1	195.5	1.5	270.0	$VELO.	
i1	197.0	1.5	280.0	$VELO.	
i1	198.5	1.5	270.0	$VELO.	
i1	200.0	1.5	240.0	$VELO.	
i1	201.5	1.5	270.0	$VELO.	
i1	203.0	1.5	280.0	$VELO.	
i1	204.5	1.5	280.0	$VELO.	
i1	206.0	1.5	280.0	$VELO.	
i1	207.5	1.5	210.0	$VELO.	
i1	209.0	1.5	360.0	$VELO.	
i1	210.5	1.5	240.0	$VELO.	
i1	212.0	1.5	240.0	$VELO.	
i1	213.5	1.5	270.0	$VELO.	
i1	215.0	1.5	280.0	$VELO.	
i1	216.5	1.5	270.0	$VELO.	
i1	218.0	1.5	240.0	$VELO.	
i1	219.5	1.5	210.0	$VELO.	
i1	221.0	1.5	360.0	$VELO.	
i1	222.5	1.5	270.0	$VELO.	
i1	224.0	1.5	360.0	$VELO.	
i1	180.5	1.5	280.0	$VELO.	
i1	137.0	1.5	280.0	$VELO.	
i1	138.5	1.5	270.0	$VELO.	
i1	144.5	1.5	280.0	$VELO.	
i1	131.0	1.5	360.0	$VELO.	
i1	225.5	1.5	270.0	$VELO.	
i1	227.0	5	240.0	$VELO.	
i1	36.5	1.5	270.0	$VELO.	
i1	38.0	1.5	420.0	$VELO.	
i1	39.5	1.5	400.0	$VELO.	
i1	44.0	1.5	360.0	$VELO.	
i1	45.5	1.5	400.0	$VELO.	
i1	47.0	1.5	400.0	$VELO.	
i1	50.0	1.5	400.0	$VELO.	
i1	51.5	1.5	336.0	$VELO.	
i1	53.0	1.5	336.0	$VELO.	
i1	54.5	1.5	336.0	$VELO.	
i1	56.0	1.5	360.0	$VELO.	
i1	57.5	1.5	400.0	$VELO.	
i1	59.0	1.5	360.0	$VELO.	
i1	60.5	1.5	336.0	$VELO.	
i1	62.0	1.5	360.0	$VELO.	
i1	63.5	1.5	400.0	$VELO.	
i1	65.0	1.5	336.0	$VELO.	
i1	66.5	1.5	400.0	$VELO.	
i1	68.0	1.5	360.0	$VELO.	
i1	69.5	1.5	336.0	$VELO.	
i1	71.0	1.5	270.0	$VELO.	
i1	72.5	1.5	336.0	$VELO.	
i1	74.0	1.5	400.0	$VELO.	
i1	75.5	1.5	336.0	$VELO.	
i1	77.0	1.5	336.0	$VELO.	
i1	78.5	1.5	336.0	$VELO.	
i1	80.0	1.5	360.0	$VELO.	
i1	81.5	1.5	400.0	$VELO.	
i1	83.0	1.5	360.0	$VELO.	
i1	86.0	1.5	400.0	$VELO.	
i1	87.5	1.5	270.0	$VELO.	
i1	89.0	1.5	400.0	$VELO.	
i1	90.5	1.5	336.0	$VELO.	
i1	92.0	1.5	360.0	$VELO.	
i1	93.5	1.5	400.0	$VELO.	
i1	95.0	1.5	400.0	$VELO.	
i1	96.5	1.5	400.0	$VELO.	
i1	98.0	1.5	360.0	$VELO.	
i1	99.5	1.5	336.0	$VELO.	
i1	101.0	1.5	360.0	$VELO.	
i1	102.5	1.5	270.0	$VELO.	
i1	104.0	1.5	400.0	$VELO.	
i1	105.5	1.5	400.0	$VELO.	
i1	107.0	1.5	336.0	$VELO.	
i1	108.5	1.5	400.0	$VELO.	
i1	110.0	1.5	400.0	$VELO.	
i1	111.5	1.5	270.0	$VELO.	
i1	113.0	1.5	336.0	$VELO.	
i1	114.5	1.5	400.0	$VELO.	
i1	116.0	1.5	336.0	$VELO.	
i1	117.5	1.5	400.0	$VELO.	
i1	119.0	1.5	360.0	$VELO.	
i1	120.5	1.5	336.0	$VELO.	
i1	122.0	1.5	336.0	$VELO.	
i1	123.5	1.5	336.0	$VELO.	
i1	125.0	1.5	400.0	$VELO.	
i1	126.5	1.5	270.0	$VELO.	
i1	128.0	1.5	360.0	$VELO.	
i1	84.5	1.5	270.0	$VELO.	
i1	41.0	1.5	360.0	$VELO.	
i1	42.5	1.5	336.0	$VELO.	
i1	48.5	1.5	270.0	$VELO.	
i1	35.0	1.5	360.0	$VELO.	
i1	129.5	1.5	270.0	$VELO.	
i1	132.5	1.5	270.0	$VELO.	
i1	134.0	1.5	420.0	$VELO.	
i1	135.5	1.5	400.0	$VELO.	
i1	140.0	1.5	360.0	$VELO.	
i1	141.5	1.5	400.0	$VELO.	
i1	143.0	1.5	400.0	$VELO.	
i1	146.0	1.5	400.0	$VELO.	
i1	147.5	1.5	336.0	$VELO.	
i1	149.0	1.5	336.0	$VELO.	
i1	150.5	1.5	336.0	$VELO.	
i1	152.0	1.5	360.0	$VELO.	
i1	153.5	1.5	400.0	$VELO.	
i1	155.0	1.5	360.0	$VELO.	
i1	156.5	1.5	336.0	$VELO.	
i1	158.0	1.5	360.0	$VELO.	
i1	159.5	1.5	400.0	$VELO.	
i1	161.0	1.5	336.0	$VELO.	
i1	162.5	1.5	400.0	$VELO.	
i1	164.0	1.5	360.0	$VELO.	
i1	165.5	1.5	336.0	$VELO.	
i1	167.0	1.5	270.0	$VELO.	
i1	168.5	1.5	336.0	$VELO.	
i1	170.0	1.5	400.0	$VELO.	
i1	171.5	1.5	336.0	$VELO.	
i1	173.0	1.5	336.0	$VELO.	
i1	174.5	1.5	336.0	$VELO.	
i1	176.0	1.5	360.0	$VELO.	
i1	177.5	1.5	400.0	$VELO.	
i1	179.0	1.5	360.0	$VELO.	
i1	182.0	1.5	400.0	$VELO.	
i1	183.5	1.5	270.0	$VELO.	
i1	185.0	1.5	400.0	$VELO.	
i1	186.5	1.5	336.0	$VELO.	
i1	188.0	1.5	360.0	$VELO.	
i1	189.5	1.5	400.0	$VELO.	
i1	191.0	1.5	400.0	$VELO.	
i1	192.5	1.5	400.0	$VELO.	
i1	194.0	1.5	360.0	$VELO.	
i1	195.5	1.5	336.0	$VELO.	
i1	197.0	1.5	360.0	$VELO.	
i1	198.5	1.5	270.0	$VELO.	
i1	200.0	1.5	400.0	$VELO.	
i1	201.5	1.5	400.0	$VELO.	
i1	203.0	1.5	336.0	$VELO.	
i1	204.5	1.5	400.0	$VELO.	
i1	206.0	1.5	400.0	$VELO.	
i1	207.5	1.5	270.0	$VELO.	
i1	209.0	1.5	336.0	$VELO.	
i1	210.5	1.5	400.0	$VELO.	
i1	212.0	1.5	336.0	$VELO.	
i1	213.5	1.5	400.0	$VELO.	
i1	215.0	1.5	360.0	$VELO.	
i1	216.5	1.5	336.0	$VELO.	
i1	218.0	1.5	336.0	$VELO.	
i1	219.5	1.5	336.0	$VELO.	
i1	221.0	1.5	400.0	$VELO.	
i1	222.5	1.5	270.0	$VELO.	
i1	224.0	1.5	360.0	$VELO.	
i1	180.5	1.5	270.0	$VELO.	
i1	137.0	1.5	360.0	$VELO.	
i1	138.5	1.5	336.0	$VELO.	
i1	144.5	1.5	270.0	$VELO.	
i1	131.0	1.5	360.0	$VELO.	
i1	225.5	1.5	270.0	$VELO.	
i1	227.0	5	240.0	$VELO.	
i2	38.0	3	120.0	$VELO.	
i2	41.0	3	140.0	$VELO.	
i2	44.0	3	140.0	$VELO.	
i2	53.0	3	120.0	$VELO.	
i2	56.0	3	140.0	$VELO.	
i2	59.0	3	120.0	$VELO.	
i2	65.0	3	180.0	$VELO.	
i2	68.0	3	120.0	$VELO.	
i2	71.0	3	120.0	$VELO.	
i2	74.0	3	140.0	$VELO.	
i2	77.0	3	120.0	$VELO.	
i2	80.0	3	120.0	$VELO.	
i2	83.0	3	180.0	$VELO.	
i2	86.0	3	135.0	$VELO.	
i2	89.0	3	140.0	$VELO.	
i2	92.0	3	135.0	$VELO.	
i2	95.0	3	120.0	$VELO.	
i2	98.0	3	120.0	$VELO.	
i2	101.0	3	120.0	$VELO.	
i2	104.0	3	135.0	$VELO.	
i2	107.0	3	140.0	$VELO.	
i2	110.0	3	120.0	$VELO.	
i2	113.0	3	180.0	$VELO.	
i2	116.0	3	120.0	$VELO.	
i2	119.0	3	180.0	$VELO.	
i2	122.0	3	135.0	$VELO.	
i2	125.0	3	120.0	$VELO.	
i2	128.0	3	135.0	$VELO.	
i2	131.0	3	140.0	$VELO.	
i2	137.0	3	140.0	$VELO.	
i2	140.0	3	120.0	$VELO.	
i2	143.0	3	140.0	$VELO.	
i2	146.0	3	180.0	$VELO.	
i2	149.0	3	140.0	$VELO.	
i2	152.0	3	135.0	$VELO.	
i2	155.0	3	120.0	$VELO.	
i2	158.0	3	140.0	$VELO.	
i2	161.0	3	120.0	$VELO.	
i2	164.0	3	135.0	$VELO.	
i2	167.0	3	140.0	$VELO.	
i2	170.0	3	135.0	$VELO.	
i2	173.0	3	120.0	$VELO.	
i2	176.0	3	135.0	$VELO.	
i2	179.0	3	140.0	$VELO.	
i2	182.0	3	140.0	$VELO.	
i2	185.0	3	140.0	$VELO.	
i2	188.0	3	105.0	$VELO.	
i2	191.0	3	180.0	$VELO.	
i2	194.0	3	120.0	$VELO.	
i2	197.0	3	120.0	$VELO.	
i2	200.0	3	135.0	$VELO.	
i2	203.0	3	140.0	$VELO.	
i2	206.0	3	135.0	$VELO.	
i2	209.0	3	120.0	$VELO.	
i2	212.0	3	105.0	$VELO.	
i2	215.0	3	180.0	$VELO.	
i2	218.0	3	135.0	$VELO.	
i2	221.0	3	180.0	$VELO.	
i2	134.0	3	140.0	$VELO.	
i2	47.0	3	140.0	$VELO.	
i2	50.0	3	135.0	$VELO.	
i2	62.0	3	140.0	$VELO.	
i2	35.0	3	180.0	$VELO.	
i2	224.0	3	135.0	$VELO.	
i2	227.0	5	120.0	$VELO.	
i2	38.0	3	135.0	$VELO.	
i2	41.0	3	210.0	$VELO.	
i2	44.0	3	200.0	$VELO.	
i2	53.0	3	180.0	$VELO.	
i2	56.0	3	200.0	$VELO.	
i2	59.0	3	200.0	$VELO.	
i2	65.0	3	200.0	$VELO.	
i2	68.0	3	168.0	$VELO.	
i2	71.0	3	168.0	$VELO.	
i2	74.0	3	168.0	$VELO.	
i2	77.0	3	180.0	$VELO.	
i2	80.0	3	200.0	$VELO.	
i2	83.0	3	180.0	$VELO.	
i2	86.0	3	168.0	$VELO.	
i2	89.0	3	180.0	$VELO.	
i2	92.0	3	200.0	$VELO.	
i2	95.0	3	168.0	$VELO.	
i2	98.0	3	200.0	$VELO.	
i2	101.0	3	180.0	$VELO.	
i2	104.0	3	168.0	$VELO.	
i2	107.0	3	135.0	$VELO.	
i2	110.0	3	168.0	$VELO.	
i2	113.0	3	200.0	$VELO.	
i2	116.0	3	168.0	$VELO.	
i2	119.0	3	168.0	$VELO.	
i2	122.0	3	168.0	$VELO.	
i2	125.0	3	180.0	$VELO.	
i2	128.0	3	200.0	$VELO.	
i2	131.0	3	180.0	$VELO.	
i2	137.0	3	200.0	$VELO.	
i2	140.0	3	135.0	$VELO.	
i2	143.0	3	200.0	$VELO.	
i2	146.0	3	168.0	$VELO.	
i2	149.0	3	180.0	$VELO.	
i2	152.0	3	200.0	$VELO.	
i2	155.0	3	200.0	$VELO.	
i2	158.0	3	200.0	$VELO.	
i2	161.0	3	180.0	$VELO.	
i2	164.0	3	168.0	$VELO.	
i2	167.0	3	180.0	$VELO.	
i2	170.0	3	135.0	$VELO.	
i2	173.0	3	200.0	$VELO.	
i2	176.0	3	200.0	$VELO.	
i2	179.0	3	168.0	$VELO.	
i2	182.0	3	200.0	$VELO.	
i2	185.0	3	200.0	$VELO.	
i2	188.0	3	135.0	$VELO.	
i2	191.0	3	168.0	$VELO.	
i2	194.0	3	200.0	$VELO.	
i2	197.0	3	168.0	$VELO.	
i2	200.0	3	200.0	$VELO.	
i2	203.0	3	180.0	$VELO.	
i2	206.0	3	168.0	$VELO.	
i2	209.0	3	168.0	$VELO.	
i2	212.0	3	168.0	$VELO.	
i2	215.0	3	200.0	$VELO.	
i2	218.0	3	135.0	$VELO.	
i2	221.0	3	180.0	$VELO.	
i2	134.0	3	135.0	$VELO.	
i2	47.0	3	180.0	$VELO.	
i2	50.0	3	168.0	$VELO.	
i2	62.0	3	135.0	$VELO.	
i2	35.0	3	180.0	$VELO.	
i2	224.0	3	135.0	$VELO.	
i2	227.0	5	120.0	$VELO.	
i4	0.75	39.25	1200	300	480.0	0	
i4	0.75	39.25	1200	300	960.0	1	
i4	0.75	39.25	1200	300	840.0	.8	
i4	0.75	39.25	1200	300	720.0	.5	
i4	176.42857	60.5714302063	2000	300	420.0	.4	
i4	191.57143	45.4285736084	2000	300	360.0	.2	
i4	131.0	106	2000	300	840.0	1	
i4	146.14285	90.8571472168	2000	300	720.0	.8	
i4	161.28572	75.7142868042	2000	300	480.0	.6	
i4	206.7143	30.2857151031	2000	300	240.0	0	
i4	221.85715	15.1428575516	2000	300	560.0	.5	
i4	221.85715	15.1428575516	2000	300	280.0	.5	
i5	0	239.0000152588	
e

</CsScore>

</CsoundSynthesizer>