/*
 * Decompiled with CFR 0.152.
 */
package blue.settings;

import blue.settings.PlaybackOptionsPanelController;
import blue.settings.PlaybackSettings;
import blue.ui.utilities.SimpleDocumentListener;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

final class PlaybackPanel
extends JPanel {
    private final PlaybackOptionsPanelController controller;
    private boolean loading = false;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JSpinner playbackFPS;
    private JTextField playbackLatencyCorrection;

    PlaybackPanel(PlaybackOptionsPanelController controller) {
        this.controller = controller;
        this.initComponents();
        SimpleDocumentListener changeListener = new SimpleDocumentListener(){

            public void documentChanged(DocumentEvent e) {
                if (!PlaybackPanel.this.loading) {
                    PlaybackPanel.this.controller.changed();
                }
            }
        };
        this.playbackLatencyCorrection.getDocument().addDocumentListener((DocumentListener)changeListener);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.playbackFPS = new JSpinner(new SpinnerNumberModel(20, 1, 120, 1));
        this.playbackLatencyCorrection = new JTextField();
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(PlaybackPanel.class, (String)"PlaybackPanel.jLabel1.text_1"));
        this.jLabel2.setHorizontalAlignment(11);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(PlaybackPanel.class, (String)"PlaybackPanel.jLabel2.text_1"));
        this.playbackFPS.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                PlaybackPanel.this.playbackFPSStateChanged(evt);
            }
        });
        this.playbackLatencyCorrection.setText(NbBundle.getMessage(PlaybackPanel.class, (String)"PlaybackPanel.playbackLatencyCorrection.text_1"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jLabel2, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.playbackLatencyCorrection, -1, 310, Short.MAX_VALUE).addComponent(this.playbackFPS, -1, 310, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.playbackFPS, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.playbackLatencyCorrection, -2, -1, -2)).addContainerGap(89, Short.MAX_VALUE)));
    }

    private void playbackFPSStateChanged(ChangeEvent evt) {
        if (!this.loading) {
            this.controller.changed();
        }
    }

    void load() {
        this.loading = true;
        PlaybackSettings settings = PlaybackSettings.getInstance();
        this.playbackFPS.setValue(new Integer(settings.getPlaybackFPS()));
        this.playbackLatencyCorrection.setText(Float.toString(settings.getPlaybackLatencyCorrection()));
        this.loading = false;
    }

    void store() {
        PlaybackSettings settings = PlaybackSettings.getInstance();
        settings.setPlaybackFPS((Integer)this.playbackFPS.getValue());
        try {
            settings.setPlaybackLatencyCorrection(Float.parseFloat(this.playbackLatencyCorrection.getText()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        settings.save();
    }

    boolean valid() {
        return true;
    }
}

