/*
 * Decompiled with CFR 0.152.
 */
package blue.settings;

import java.io.File;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.openide.util.Exceptions;
import org.openide.util.NbPreferences;

public class GeneralSettings {
    private static final String PREFIX = "general.";
    private static final String CSOUND_ERROR_WARNING_ENABLED = "csoundErrorWarningEnabled";
    private static final String DEFAULT_WORK_DIRECTORY = "defaultWorkDirectory";
    private static final String DRAW_ALPHA_BACKGROUND_ON_MARQUEE = "drawAlphaBackgroundOnMarquee";
    private static final String MESSAGE_COLORS_ENABLED = "messageColorsEnabled";
    private static final String NEW_USER_DEFAULTS_ENABLED = "newUserDefaultsEnabled";
    private String csoundDocRoot = "";
    private File defaultDirectory = null;
    private boolean newUserDefaultsEnabled = true;
    private boolean alphaEnabled = false;
    private boolean messageColorsEnabled = false;
    private boolean csoundErrorWarningEnabled = true;
    private static GeneralSettings instance = null;

    private GeneralSettings() {
    }

    public static GeneralSettings getInstance() {
        if (instance == null) {
            instance = new GeneralSettings();
            Preferences prefs = NbPreferences.forModule(GeneralSettings.class);
            GeneralSettings.instance.defaultDirectory = new File(prefs.get("general.defaultWorkDirectory", ""));
            GeneralSettings.instance.newUserDefaultsEnabled = prefs.getBoolean("general.newUserDefaultsEnabled", true);
            GeneralSettings.instance.alphaEnabled = prefs.getBoolean("general.drawAlphaBackgroundOnMarquee", false);
            GeneralSettings.instance.messageColorsEnabled = prefs.getBoolean("general.messageColorsEnabled", false);
            GeneralSettings.instance.csoundErrorWarningEnabled = prefs.getBoolean("general.csoundErrorWarningEnabled", true);
        }
        return instance;
    }

    public void save() {
        Preferences prefs = NbPreferences.forModule(GeneralSettings.class);
        prefs.put("general.defaultWorkDirectory", this.defaultDirectory.getAbsolutePath());
        prefs.putBoolean("general.newUserDefaultsEnabled", this.newUserDefaultsEnabled);
        prefs.putBoolean("general.drawAlphaBackgroundOnMarquee", this.alphaEnabled);
        prefs.putBoolean("general.messageColorsEnabled", this.messageColorsEnabled);
        prefs.putBoolean("general.csoundErrorWarningEnabled", this.csoundErrorWarningEnabled);
        try {
            prefs.sync();
        }
        catch (BackingStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public File getDefaultDirectory() {
        return this.defaultDirectory;
    }

    public void setDefaultDirectory(File defaultDirectory) {
        this.defaultDirectory = defaultDirectory;
    }

    public boolean isAlphaEnabled() {
        return this.alphaEnabled;
    }

    public void setAlphaEnabled(boolean alphaEnabled) {
        this.alphaEnabled = alphaEnabled;
    }

    public boolean isMessageColorsEnabled() {
        return this.messageColorsEnabled;
    }

    public void setMessageColorsEnabled(boolean messageColorsEnabled) {
        this.messageColorsEnabled = messageColorsEnabled;
    }

    public boolean isNewUserDefaultsEnabled() {
        return this.newUserDefaultsEnabled;
    }

    public void setNewUserDefaultsEnabled(boolean newUserDefaultsEnabled) {
        this.newUserDefaultsEnabled = newUserDefaultsEnabled;
    }

    public boolean isCsoundErrorWarningEnabled() {
        return this.csoundErrorWarningEnabled;
    }

    public void setCsoundErrorWarningEnabled(boolean aCsoundErrorWarningEnabled) {
        this.csoundErrorWarningEnabled = aCsoundErrorWarningEnabled;
    }
}

