/*
 * Decompiled with CFR 0.152.
 */
package blue.plaf;

import blue.plaf.BlueLookAndFeel;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalToolTipUI;

public class BlueToolTipUI
extends MetalToolTipUI {
    static BlueToolTipUI sharedInstance = new BlueToolTipUI();
    private Font smallFont;
    private String acceleratorDelimiter;
    private JToolTip tip;

    public static ComponentUI createUI(JComponent c) {
        return sharedInstance;
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        Font f = c.getFont();
        this.smallFont = new Font(f.getName(), f.getStyle(), f.getSize() - 2);
        this.acceleratorDelimiter = UIManager.getString("MenuItem.acceleratorDelimiter");
        if (this.acceleratorDelimiter == null) {
            this.acceleratorDelimiter = "-";
        }
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        JToolTip tip = (JToolTip)c;
        super.paint(g, c);
        Font font = c.getFont();
        String keyText = this.getAcceleratorString(tip);
        String tipText = tip.getTipText();
        if (tipText == null) {
            tipText = "";
        }
        if (!keyText.equals("")) {
            g.setFont(this.smallFont);
            g.setColor(BlueLookAndFeel.getPrimaryControlDarkShadow());
            FontMetrics metrics = g.getFontMetrics();
            g.drawString(keyText, metrics.stringWidth(tipText) + 12, 2 + metrics.getAscent());
        }
    }

    private String getAcceleratorString(JToolTip tip) {
        this.tip = tip;
        String retValue = this.getAcceleratorString();
        this.tip = null;
        return retValue;
    }

    @Override
    public String getAcceleratorString() {
        int mnemonic;
        if (this.tip == null || this.isAcceleratorHidden()) {
            return "";
        }
        JComponent comp = this.tip.getComponent();
        if (comp == null) {
            return "";
        }
        KeyStroke[] keys = comp.getRegisteredKeyStrokes();
        String controlKeyStr = "";
        for (int i = 0; i < keys.length; ++i) {
            int mod = keys[i].getModifiers();
            int condition = comp.getConditionForKeyStroke(keys[i]);
            if (condition != 2 || (mod & 8) == 0 && (mod & 2) == 0 && (mod & 1) == 0 && (mod & 4) == 0) continue;
            controlKeyStr = KeyEvent.getKeyModifiersText(mod) + this.acceleratorDelimiter + KeyEvent.getKeyText(keys[i].getKeyCode());
            break;
        }
        if (controlKeyStr.equals("") && comp instanceof JMenuItem && (mnemonic = ((JMenuItem)comp).getMnemonic()) != 0) {
            controlKeyStr = KeyEvent.getKeyModifiersText(8) + this.acceleratorDelimiter + (char)mnemonic;
        }
        return controlKeyStr;
    }
}

