/*
 * Decompiled with CFR 0.152.
 */
package blue.clojure.project;

import blue.BlueData;
import blue.clojure.project.ClojureProjectData;
import blue.clojure.project.ClojureProjectDataEditorController;
import blue.jfx.BlueFX;
import blue.project.ProjectPluginEditor;
import blue.project.ProjectPluginUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import org.openide.util.Exceptions;

public class ClojureProjectPluginEditor
extends ProjectPluginEditor {
    ClojureProjectDataEditorController controller;

    public ClojureProjectPluginEditor() {
        this.setLayout(new BorderLayout());
        JFXPanel panel = new JFXPanel();
        this.add((Component)panel, "Center");
        CountDownLatch latch = new CountDownLatch(1);
        Platform.runLater(() -> {
            FXMLLoader loader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("ClojureProjectDataEditor.fxml"));
            try {
                loader.load();
                this.controller = (ClojureProjectDataEditorController)loader.getController();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            Scene scene = new Scene((Parent)loader.getRoot());
            BlueFX.style((Scene)scene);
            Node root = (Node)loader.getRoot();
            panel.setScene(scene);
            latch.countDown();
        });
        try {
            latch.await();
        }
        catch (InterruptedException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public void edit(BlueData data) {
        ClojureProjectData projData = (ClojureProjectData)ProjectPluginUtils.findPluginData((List)data.getPluginData(), ClojureProjectData.class);
        if (projData == null) {
            projData = new ClojureProjectData();
            data.getPluginData().add(projData);
        }
        this.controller.setClojureProjectData(projData);
    }
}

