/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.editor.csound.orc.actions;

import java.awt.event.ActionEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;

public class RemoveSemiColonLineCommentAction
extends BaseAction {
    public static String ACTION_NAME = "remove-semicolon-line-comment";
    private static String COMMENT_STRING = ";";

    public RemoveSemiColonLineCommentAction() {
        this.putValue("Name", ACTION_NAME);
    }

    public void actionPerformed(ActionEvent evt, JTextComponent target) {
        if (target != null) {
            if (!target.isEditable() || !target.isEnabled()) {
                target.getToolkit().beep();
                return;
            }
            Caret caret = target.getCaret();
            BaseDocument doc = (BaseDocument)target.getDocument();
            doc.runAtomicAsUser(() -> {
                try {
                    int endPos;
                    int startPos;
                    if (Utilities.isSelectionShowing((Caret)caret)) {
                        startPos = Utilities.getRowStart((BaseDocument)doc, (int)target.getSelectionStart());
                        endPos = target.getSelectionEnd();
                        if (endPos > 0 && Utilities.getRowStart((BaseDocument)doc, (int)endPos) == endPos) {
                            --endPos;
                        }
                        endPos = Utilities.getRowEnd((BaseDocument)doc, (int)endPos);
                    } else {
                        startPos = Utilities.getRowStart((BaseDocument)doc, (int)caret.getDot());
                        endPos = Utilities.getRowEnd((BaseDocument)doc, (int)caret.getDot());
                    }
                    int lineCount = Utilities.getRowCount((BaseDocument)doc, (int)startPos, (int)endPos);
                    this.uncomment(doc, startPos, lineCount);
                }
                catch (BadLocationException e) {
                    target.getToolkit().beep();
                }
            });
        }
    }

    private void uncomment(BaseDocument doc, int startOffset, int lineCount) throws BadLocationException {
        int lineCommentStringLen = 1;
        int offset = startOffset;
        while (lineCount > 0) {
            CharSequence maybeLineComment;
            int rowStart = Utilities.getRowStart((BaseDocument)doc, (int)offset);
            if (rowStart != -1 && Utilities.getRowEnd((BaseDocument)doc, (int)rowStart) - rowStart >= lineCommentStringLen && CharSequenceUtilities.textEquals((CharSequence)(maybeLineComment = DocumentUtilities.getText((Document)doc, (int)rowStart, (int)lineCommentStringLen)), (CharSequence)COMMENT_STRING)) {
                doc.remove(rowStart, lineCommentStringLen);
            }
            offset = Utilities.getRowStart((BaseDocument)doc, (int)offset, (int)1);
            --lineCount;
        }
    }
}

