/*
 * Decompiled with CFR 0.152.
 */
package csound.manual.impl;

import csound.manual.OpcodeDoc;
import csound.manual.OpcodeDocCategory;
import java.io.IOException;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class OpcodesParser
extends DefaultHandler {
    Stack<OpcodeDocCategory> categories = new Stack();
    OpcodeDoc currentOpcode = null;
    StringBuilder currentValue = new StringBuilder();

    private OpcodesParser() {
        OpcodeDocCategory root = new OpcodeDocCategory();
        root.categoryName = "opcodes";
        this.categories.add(root);
    }

    public static OpcodeDocCategory loadOpcodesXML() {
        OpcodesParser opParser = new OpcodesParser();
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            parser.parse(OpcodesParser.class.getResourceAsStream("opcodes.xml"), (DefaultHandler)opParser);
        }
        catch (IOException ex) {
            Logger.getLogger(OpcodesParser.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ParserConfigurationException ex) {
            Logger.getLogger(OpcodesParser.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (SAXException ex) {
            Logger.getLogger(OpcodesParser.class.getName()).log(Level.SEVERE, null, ex);
        }
        return opParser.categories.pop();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if ("opcodeGroup".equals(qName)) {
            OpcodeDocCategory cat = new OpcodeDocCategory();
            cat.categoryName = atts.getValue("name");
            this.categories.peek().subGroups.add(cat);
            this.categories.push(cat);
        } else if ("opcode".equals(qName)) {
            this.currentOpcode = new OpcodeDoc();
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("opcodeGroup".equals(qName)) {
            this.categories.pop();
        } else if ("opcode".equals(qName)) {
            this.categories.peek().opcodes.add(this.currentOpcode);
            this.currentOpcode = null;
        } else if ("name".equals(qName)) {
            this.currentOpcode.opcodeName = this.currentValue.toString().trim();
        } else if ("signature".equals(qName)) {
            this.currentOpcode.signature = this.currentValue.toString().trim();
        }
        this.currentValue = new StringBuilder();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.currentValue.append(ch, start, length);
    }
}

