/*
 * Decompiled with CFR 0.152.
 */
package blue.utility;

import blue.BlueSystem;
import blue.utility.PluginObjectInputStream;
import electric.xml.Element;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class ObjectUtilities {
    private static final Map<String, String> classMap = new HashMap<String, String>();

    public static Object serializeClone(Object obj) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(obj);
            objectOutputStream.flush();
            byteArrayOutputStream.close();
            byte[] objectBuffer = byteArrayOutputStream.toByteArray();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(objectBuffer);
            PluginObjectInputStream objectInputStream = new PluginObjectInputStream(byteArrayInputStream);
            Object myClone = objectInputStream.readObject();
            return myClone;
        }
        catch (IOException | ClassNotFoundException x) {
            x.printStackTrace();
            return null;
        }
    }

    public static void printMembers(Object obj) {
        System.out.println(obj.toString());
        Method[] methods = obj.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            try {
                if (!methods[i].getName().startsWith("get") && !methods[i].getName().startsWith("is")) continue;
                System.out.println(methods[i].getName() + " : " + methods[i].invoke(obj, new Object[0]));
                continue;
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        System.out.println("\n");
    }

    public static Object loadFromXML(Element elem) throws Exception {
        String npClass = elem.getAttributeValue("type");
        if (classMap.containsKey(npClass)) {
            npClass = classMap.get(npClass);
        }
        Class<?> classToLoad = BlueSystem.getClassLoader().loadClass(npClass);
        Object retVal = null;
        Method m = classToLoad.getMethod("loadFromXML", Element.class);
        try {
            retVal = m.invoke(null, elem);
        }
        catch (Exception e) {
            throw new Exception("Error with class: " + classToLoad, e);
        }
        return retVal;
    }

    public static Object loadFromXML(Element elem, Map<String, Object> objRefMap) throws Exception {
        String npClass = elem.getAttributeValue("type");
        if (classMap.containsKey(npClass)) {
            npClass = classMap.get(npClass);
        }
        Class<?> classToLoad = Thread.currentThread().getContextClassLoader().loadClass(npClass);
        Object retVal = null;
        Method m = classToLoad.getMethod("loadFromXML", Element.class, Map.class);
        retVal = m.invoke(null, elem, objRefMap);
        return retVal;
    }

    public static String getShortClassName(Object obj) {
        String className = obj.getClass().getName();
        String shortName = className.substring(className.lastIndexOf(46) + 1);
        return shortName;
    }

    static {
        classMap.put("blue.orchestra.RhinoInstrument", "blue.orchestra.JavaScriptInstrument");
        classMap.put("blue.soundObject.RhinoObject", "blue.soundObject.JavaScriptObject");
    }
}

