/*
 * Decompiled with CFR 0.152.
 */
package blue.utility;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;

public class FileUtilities {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File source, File dest) throws IOException {
        BufferedInputStream in = null;
        FilterOutputStream out = null;
        try {
            in = new BufferedInputStream(new FileInputStream(source));
            out = new BufferedOutputStream(new FileOutputStream(dest));
            FileUtilities.copyStream(in, out);
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (in != null) {
                in.close();
            }
        }
    }

    private static void copyStream(InputStream in, OutputStream out) throws IOException {
        int numberRead;
        byte[] buffer = new byte[1024];
        while ((numberRead = in.read(buffer)) >= 0) {
            out.write(buffer, 0, numberRead);
        }
    }

    public static boolean ensureDirectoryExists(String userPythonPath) {
        return FileUtilities.ensureDirectoryExists(new File(userPythonPath));
    }

    public static boolean ensureDirectoryExists(File dir) {
        boolean didExist = dir.exists();
        if (!didExist) {
            dir.mkdirs();
        }
        return didExist;
    }

    public static boolean copyIfNotThere(File src, File dest) {
        if (!dest.exists() && src.exists()) {
            try {
                FileUtilities.copyFile(src, dest);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return true;
        }
        return false;
    }

    public static File createTempTextFile(String prefix, String suffix, File directory, String text) {
        File f;
        try {
            f = directory == null ? File.createTempFile(prefix, suffix) : File.createTempFile(prefix, suffix, directory);
            f.deleteOnExit();
            try (PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(f)));){
                out.print(text);
                out.flush();
            }
        }
        catch (IOException e) {
            return null;
        }
        return f;
    }
}

