/*
 * Decompiled with CFR 0.152.
 */
package blue.upgrades;

public class ProjectVersion {
    int[] versionParts = null;
    boolean beta = false;

    private ProjectVersion() {
    }

    public static ProjectVersion parseVersion(String versionString) {
        ProjectVersion version = new ProjectVersion();
        if (versionString != null && !versionString.isEmpty()) {
            String[] parts = versionString.split("_");
            if (parts.length >= 2) {
                version.beta = true;
            }
            parts = parts[0].split("\\.");
            version.versionParts = new int[parts.length];
            for (int i = 0; i < parts.length; ++i) {
                int part;
                try {
                    part = Integer.parseInt(parts[i]);
                }
                catch (NumberFormatException nfe) {
                    part = -1;
                }
                version.versionParts[i] = part;
            }
        }
        return version;
    }

    public boolean lessThan(ProjectVersion version) {
        for (int i = 0; i < 3; ++i) {
            if (this.versionParts[i] == version.versionParts[i]) continue;
            return this.versionParts[i] < version.versionParts[i];
        }
        return this.beta && !version.beta;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Version:");
        if (this.versionParts == null) {
            builder.append(" Empty");
        } else {
            for (int part : this.versionParts) {
                builder.append(" ").append(part);
            }
            if (this.beta) {
                builder.append(" BETA");
            }
        }
        return builder.toString();
    }
}

