/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.jmask;

import blue.soundObject.jmask.Accumulatable;
import blue.soundObject.jmask.Generator;
import blue.utility.XMLUtilities;
import electric.xml.Element;
import electric.xml.Elements;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class ItemList
implements Generator,
TableModel,
Accumulatable {
    public static final int CYCLE = 0;
    public static final int SWING = 1;
    public static final int RANDOM = 2;
    public static final int HEAP = 3;
    public static final String[] MODES = new String[]{"Cycle", "Swing", "Random", "Heap"};
    private int listType = 0;
    private ArrayList<Double> listItems;
    private transient int index = 0;
    private transient int direction = 0;
    private transient Vector<WeakReference<TableModelListener>> listeners = null;

    public ItemList() {
        this.listItems = new ArrayList();
    }

    public ItemList(ItemList il) {
        this.listType = il.listType;
        this.listItems = new ArrayList<Double>(il.listItems);
    }

    public static Generator loadFromXML(Element data) {
        ItemList retVal = new ItemList();
        Elements nodes = data.getElements();
        while (nodes.hasMoreElements()) {
            String nodeName;
            Element node = nodes.next();
            switch (nodeName = node.getName()) {
                case "listType": {
                    retVal.setListType(Integer.parseInt(node.getTextString()));
                    break;
                }
                case "listItems": {
                    Elements items = node.getElements();
                    while (items.hasMoreElements()) {
                        Element itemNode = items.next();
                        String itemNodeName = itemNode.getName();
                        if (!itemNodeName.equals("item")) continue;
                        retVal.listItems.add(Double.valueOf(itemNode.getTextString()));
                    }
                    break;
                }
                case "index": {
                    retVal.index = Integer.parseInt(node.getTextString());
                    break;
                }
                case "direction": {
                    retVal.direction = Integer.parseInt(node.getTextString());
                }
            }
        }
        return retVal;
    }

    @Override
    public Element saveAsXML() {
        Element retVal = new Element("generator");
        retVal.setAttribute("type", this.getClass().getName());
        retVal.addElement(XMLUtilities.writeInt("listType", this.getListType()));
        retVal.addElement(XMLUtilities.writeInt("index", this.index));
        retVal.addElement(XMLUtilities.writeInt("direction", this.direction));
        Element items = new Element("listItems");
        for (Double item : this.listItems) {
            items.addElement("item").setText(item.toString());
        }
        retVal.addElement(items);
        return retVal;
    }

    @Override
    public void initialize(double duration) {
        this.index = 0;
        this.direction = 0;
    }

    @Override
    public double getValue(double time, Random rnd) {
        double retVal = 0.0;
        if (this.listItems.size() <= 1) {
            retVal = this.listItems.get(this.index);
        } else {
            switch (this.getListType()) {
                case 0: {
                    retVal = this.listItems.get(this.index);
                    ++this.index;
                    if (this.index < this.listItems.size()) break;
                    this.index = 0;
                    break;
                }
                case 1: {
                    retVal = this.listItems.get(this.index);
                    if (this.direction == 0) {
                        ++this.index;
                        if (this.index < this.listItems.size()) break;
                        this.index -= 2;
                        this.direction = 1;
                        break;
                    }
                    --this.index;
                    if (this.index >= 0) break;
                    this.index = 1;
                    this.direction = 0;
                    break;
                }
                case 2: {
                    this.index = (int)(rnd.nextDouble() * (double)this.listItems.size());
                    retVal = this.listItems.get(this.index);
                    break;
                }
                case 3: {
                    if (this.index == 0) {
                        Collections.shuffle(this.listItems);
                    }
                    retVal = this.listItems.get(this.index);
                    ++this.index;
                    if (this.index < this.listItems.size()) break;
                    this.index = 0;
                    break;
                }
            }
        }
        return retVal;
    }

    public void addListItem(Double val, int rowIndex) {
        if (rowIndex < 0 || rowIndex >= this.listItems.size()) {
            this.listItems.add(val);
        } else {
            this.listItems.add(rowIndex, val);
        }
        TableModelEvent tme = new TableModelEvent(this);
        this.fireTableUpdated(tme);
    }

    public void removeListItem(int rowIndex) {
        this.listItems.remove(rowIndex);
        TableModelEvent tme = new TableModelEvent(this);
        this.fireTableUpdated(tme);
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        for (WeakReference<TableModelListener> ref : this.listeners) {
            if (ref.get() != l) continue;
            return;
        }
        this.listeners.add(new WeakReference<TableModelListener>(l));
    }

    public Class getColumnClass(int columnIndex) {
        return Double.class;
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return "List Items";
    }

    @Override
    public int getRowCount() {
        return this.listItems.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.listItems.get(rowIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        if (this.listeners != null) {
            WeakReference<TableModelListener> found = null;
            for (WeakReference<TableModelListener> ref : this.listeners) {
                if (ref.get() != l) continue;
                found = ref;
                ref.clear();
                break;
            }
            if (found != null) {
                this.listeners.remove(found);
            }
        }
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (aValue instanceof Double) {
            this.listItems.remove(rowIndex);
            this.listItems.add(rowIndex, (Double)aValue);
        }
        TableModelEvent tme = new TableModelEvent(this, rowIndex);
        this.fireTableUpdated(tme);
    }

    private void fireTableUpdated(TableModelEvent tme) {
        if (this.listeners != null) {
            for (WeakReference<TableModelListener> ref : this.listeners) {
                if (ref.get() == null) continue;
                ((TableModelListener)ref.get()).tableChanged(tme);
            }
        }
    }

    public void pushDown(int selectedIndex) {
        Double obj = this.listItems.remove(selectedIndex + 1);
        this.listItems.add(selectedIndex, obj);
        TableModelEvent tme = new TableModelEvent(this, selectedIndex, selectedIndex + 1);
        this.fireTableUpdated(tme);
    }

    public void pushUp(int selectedIndex) {
        Double obj = this.listItems.remove(selectedIndex);
        this.listItems.add(selectedIndex - 1, obj);
        TableModelEvent tme = new TableModelEvent(this, selectedIndex - 1, selectedIndex);
        this.fireTableUpdated(tme);
    }

    public int getListType() {
        return this.listType;
    }

    public void setListType(int listType) {
        this.listType = listType;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    @Override
    public ItemList deepCopy() {
        return new ItemList(this);
    }
}

