/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject;

import blue.components.lines.Line;
import blue.soundObject.AbstractLineObject;
import blue.soundObject.SoundObject;
import blue.soundObject.SoundObjectUtilities;
import electric.xml.Element;
import electric.xml.Elements;
import java.util.Map;

public class ZakLineObject
extends AbstractLineObject {
    public ZakLineObject() {
        this.setName("ZakLineObject");
    }

    public ZakLineObject(ZakLineObject zlo) {
        super(zlo);
    }

    @Override
    protected String generateLineInstrument(Line line) {
        int channel = line.getChannel();
        StringBuilder buffer = new StringBuilder();
        buffer.append("kphase line p4, p3, p5\n");
        buffer.append("kline\ttablei kphase, p6, 1\n");
        buffer.append("zkw kline, ").append(channel);
        return buffer.toString();
    }

    public static SoundObject loadFromXML(Element data, Map<String, Object> objRefMap) throws Exception {
        ZakLineObject lObj = new ZakLineObject();
        SoundObjectUtilities.initBasicFromXML(data, lObj);
        Elements lines = data.getElements();
        while (lines.hasMoreElements()) {
            Element node = lines.next();
            if (!node.getName().equals("zakline")) continue;
            Line l = Line.loadFromXML(node);
            lObj.getLines().add(l);
        }
        return lObj;
    }

    @Override
    public ZakLineObject deepCopy() {
        return new ZakLineObject(this);
    }
}

