/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject;

import blue.CompileData;
import blue.noteProcessor.NoteProcessorChain;
import blue.noteProcessor.NoteProcessorException;
import blue.score.ScoreObjectEvent;
import blue.soundObject.AbstractSoundObject;
import blue.soundObject.GenericViewable;
import blue.soundObject.Note;
import blue.soundObject.NoteList;
import blue.soundObject.NoteParseException;
import blue.soundObject.SoundObject;
import blue.soundObject.SoundObjectException;
import blue.soundObject.SoundObjectUtilities;
import blue.soundObject.pianoRoll.PianoNote;
import blue.soundObject.pianoRoll.Scale;
import blue.utility.ScoreUtilities;
import blue.utility.TextUtilities;
import electric.xml.Element;
import electric.xml.Elements;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Map;

public class PianoRoll
extends AbstractSoundObject
implements GenericViewable {
    public static final int DISPLAY_TIME = 0;
    public static final int DISPLAY_NUMBER = 1;
    public static final int GENERATE_FREQUENCY = 0;
    public static final int GENERATE_PCH = 1;
    public static final int GENERATE_MIDI = 2;
    private int timeBehavior;
    double repeatPoint = -1.0;
    private NoteProcessorChain npc = new NoteProcessorChain();
    private Scale scale;
    private ArrayList<PianoNote> notes;
    private String noteTemplate;
    private String instrumentId;
    private int pixelSecond;
    private int noteHeight;
    private transient ArrayList listeners;
    private boolean snapEnabled = false;
    private double snapValue = 1.0;
    private int timeDisplay = 0;
    private int pchGenerationMethod = 0;
    private int timeUnit = 5;
    private int transposition = 0;

    public PianoRoll() {
        this.setName("PianoRoll");
        this.timeBehavior = 0;
        this.scale = Scale.get12TET();
        this.notes = new ArrayList();
        this.noteTemplate = "i <INSTR_ID> <START> <DUR> <FREQ>";
        this.instrumentId = "1";
        this.pixelSecond = 64;
        this.noteHeight = 15;
    }

    public PianoRoll(PianoRoll pr) {
        super(pr);
        this.timeBehavior = pr.timeBehavior;
        this.repeatPoint = pr.repeatPoint;
        this.npc = new NoteProcessorChain(pr.npc);
        this.scale = new Scale(pr.scale);
        this.notes = new ArrayList(pr.notes.size());
        for (PianoNote pn : pr.notes) {
            this.notes.add(new PianoNote(pn));
        }
        this.noteTemplate = pr.noteTemplate;
        this.instrumentId = pr.instrumentId;
        this.pixelSecond = pr.pixelSecond;
        this.noteHeight = pr.noteHeight;
        this.snapEnabled = pr.snapEnabled;
        this.snapValue = pr.snapValue;
        this.timeDisplay = pr.timeDisplay;
        this.pchGenerationMethod = pr.pchGenerationMethod;
        this.timeUnit = pr.timeUnit;
        this.transposition = pr.transposition;
    }

    @Override
    public NoteProcessorChain getNoteProcessorChain() {
        return this.npc;
    }

    @Override
    public void setNoteProcessorChain(NoteProcessorChain chain) {
        this.npc = chain;
    }

    @Override
    public double getObjectiveDuration() {
        return this.getSubjectiveDuration();
    }

    public NoteList generateNotes(double renderStart, double renderEnd) throws SoundObjectException {
        NoteList nl = new NoteList();
        String instrId = this.instrumentId;
        if (instrId != null) {
            instrId = instrId.trim();
        }
        try {
            Integer.parseInt(this.instrumentId);
        }
        catch (NumberFormatException nfe) {
            instrId = "\"" + instrId + "\"";
        }
        for (PianoNote n : this.notes) {
            int numScaleDegrees;
            String freq = "";
            int octave = n.getOctave();
            int scaleDegree = n.getScaleDegree() + this.getTransposition();
            if (scaleDegree >= (numScaleDegrees = this.getPchGenerationMethod() == 2 ? 12 : this.scale.getNumScaleDegrees())) {
                octave += scaleDegree / numScaleDegrees;
                scaleDegree %= numScaleDegrees;
            }
            if (scaleDegree < 0) {
                int octaveDiff = scaleDegree * -1 / numScaleDegrees;
                scaleDegree %= numScaleDegrees;
                octave -= ++octaveDiff;
                scaleDegree = numScaleDegrees + scaleDegree;
            }
            if (this.pchGenerationMethod == 0) {
                double f = this.scale.getFrequency(octave, scaleDegree);
                freq = Double.toString(f);
            } else if (this.pchGenerationMethod == 1) {
                freq = octave + "." + scaleDegree;
            } else if (this.pchGenerationMethod == 2) {
                freq = Integer.toString(octave * 12 + scaleDegree);
            }
            String template = n.getNoteTemplate();
            template = TextUtilities.replaceAll(template, "<INSTR_ID>", instrId);
            template = TextUtilities.replaceAll(template, "<INSTR_NAME>", this.instrumentId);
            template = TextUtilities.replaceAll(template, "<START>", Double.toString(n.getStart()));
            template = TextUtilities.replaceAll(template, "<DUR>", Double.toString(n.getDuration()));
            template = TextUtilities.replaceAll(template, "<FREQ>", freq);
            Note note = null;
            try {
                note = Note.createNote(template);
            }
            catch (NoteParseException e) {
                throw new SoundObjectException((SoundObject)this, (Throwable)e);
            }
            nl.add(note);
        }
        try {
            ScoreUtilities.applyNoteProcessorChain(nl, this.npc);
        }
        catch (NoteProcessorException e) {
            throw new SoundObjectException((SoundObject)this, (Throwable)e);
        }
        ScoreUtilities.applyTimeBehavior(nl, this.getTimeBehavior(), this.getSubjectiveDuration(), this.getRepeatPoint());
        ScoreUtilities.setScoreStart(nl, this.startTime);
        return nl;
    }

    @Override
    public int getTimeBehavior() {
        return this.timeBehavior;
    }

    @Override
    public void setTimeBehavior(int timeBehavior) {
        this.timeBehavior = timeBehavior;
    }

    @Override
    public double getRepeatPoint() {
        return this.repeatPoint;
    }

    @Override
    public void setRepeatPoint(double repeatPoint) {
        this.repeatPoint = repeatPoint;
        ScoreObjectEvent event = new ScoreObjectEvent(this, 4);
        this.fireScoreObjectEvent(event);
    }

    public static SoundObject loadFromXML(Element data, Map<String, Object> objRefMap) throws Exception {
        PianoRoll p = new PianoRoll();
        SoundObjectUtilities.initBasicFromXML(data, p);
        Elements nodes = data.getElements();
        while (nodes.hasMoreElements()) {
            String nodeName;
            Element e = nodes.next();
            switch (nodeName = e.getName()) {
                case "noteTemplate": {
                    p.setNoteTemplate(e.getTextString());
                    break;
                }
                case "instrumentId": {
                    p.setInstrumentId(e.getTextString());
                    break;
                }
                case "scale": {
                    p.setScale(Scale.loadFromXML(e));
                    break;
                }
                case "pixelSecond": {
                    p.setPixelSecond(Integer.parseInt(e.getTextString()));
                    break;
                }
                case "noteHeight": {
                    p.setNoteHeight(Integer.parseInt(e.getTextString()));
                    break;
                }
                case "snapEnabled": {
                    p.setSnapEnabled(Boolean.valueOf(e.getTextString()));
                    break;
                }
                case "snapValue": {
                    p.setSnapValue(Double.parseDouble(e.getTextString()));
                    break;
                }
                case "timeDisplay": {
                    p.setTimeDisplay(Integer.parseInt(e.getTextString()));
                    break;
                }
                case "timeUnit": {
                    p.setTimeUnit(Integer.parseInt(e.getTextString()));
                    break;
                }
                case "pianoNote": {
                    p.notes.add(PianoNote.loadFromXML(e));
                    break;
                }
                case "pchGenerationMethod": {
                    p.setPchGenerationMethod(Integer.parseInt(e.getTextString()));
                    break;
                }
                case "transposition": {
                    p.setTransposition(Integer.parseInt(e.getTextString()));
                }
            }
        }
        return p;
    }

    @Override
    public Element saveAsXML(Map<Object, String> objRefMap) {
        Element retVal = SoundObjectUtilities.getBasicXML(this);
        retVal.addElement("noteTemplate").setText(this.getNoteTemplate());
        retVal.addElement("instrumentId").setText(this.getInstrumentId());
        retVal.addElement(this.scale.saveAsXML());
        retVal.addElement("pixelSecond").setText(Integer.toString(this.getPixelSecond()));
        retVal.addElement("noteHeight").setText(Integer.toString(this.getNoteHeight()));
        retVal.addElement("snapEnabled").setText(Boolean.toString(this.isSnapEnabled()));
        retVal.addElement("snapValue").setText(Double.toString(this.getSnapValue()));
        retVal.addElement("timeDisplay").setText(Integer.toString(this.getTimeDisplay()));
        retVal.addElement("timeUnit").setText(Integer.toString(this.getTimeUnit()));
        retVal.addElement("pchGenerationMethod").setText(Integer.toString(this.getPchGenerationMethod()));
        retVal.addElement("transposition").setText(Integer.toString(this.getTransposition()));
        for (PianoNote note : this.notes) {
            retVal.addElement(note.saveAsXML());
        }
        return retVal;
    }

    public ArrayList<PianoNote> getNotes() {
        return this.notes;
    }

    public void setNotes(ArrayList<PianoNote> notes) {
        this.notes = notes;
    }

    public String getNoteTemplate() {
        return this.noteTemplate;
    }

    public void setNoteTemplate(String noteTemplate) {
        this.noteTemplate = noteTemplate;
    }

    public Scale getScale() {
        return this.scale;
    }

    public void setScale(Scale scale) {
        PropertyChangeEvent pce = new PropertyChangeEvent(this, "scale", this.scale, scale);
        this.scale = scale;
        this.firePropertyChange(pce);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.checkListenersExists();
        this.listeners.add(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.checkListenersExists();
        this.listeners.remove(listener);
    }

    public void firePropertyChange(PropertyChangeEvent pce) {
        this.checkListenersExists();
        for (PropertyChangeListener listener : this.listeners) {
            listener.propertyChange(pce);
        }
    }

    private void checkListenersExists() {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
    }

    public int getPixelSecond() {
        return this.pixelSecond;
    }

    public void setPixelSecond(int pixelSecond) {
        PropertyChangeEvent pce = new PropertyChangeEvent(this, "pixelSecond", new Integer(this.pixelSecond), new Integer(pixelSecond));
        this.pixelSecond = pixelSecond;
        this.firePropertyChange(pce);
    }

    public int getNoteHeight() {
        return this.noteHeight;
    }

    public void setNoteHeight(int noteHeight) {
        PropertyChangeEvent pce = new PropertyChangeEvent(this, "noteHeight", new Integer(this.noteHeight), new Integer(noteHeight));
        this.noteHeight = noteHeight;
        this.firePropertyChange(pce);
    }

    public boolean isSnapEnabled() {
        return this.snapEnabled;
    }

    public void setSnapEnabled(boolean snapEnabled) {
        PropertyChangeEvent pce = new PropertyChangeEvent(this, "snapEnabled", this.snapEnabled, snapEnabled);
        this.snapEnabled = snapEnabled;
        this.firePropertyChange(pce);
    }

    public double getSnapValue() {
        return this.snapValue;
    }

    public void setSnapValue(double snapValue) {
        PropertyChangeEvent pce = new PropertyChangeEvent(this, "snapValue", new Double(this.snapValue), new Double(snapValue));
        this.snapValue = snapValue;
        this.firePropertyChange(pce);
    }

    public int getTimeDisplay() {
        return this.timeDisplay;
    }

    public void setTimeDisplay(int timeDisplay) {
        PropertyChangeEvent pce = new PropertyChangeEvent(this, "timeDisplay", new Integer(this.timeDisplay), new Integer(timeDisplay));
        this.timeDisplay = timeDisplay;
        this.firePropertyChange(pce);
    }

    public int getTimeUnit() {
        return this.timeUnit;
    }

    public void setTimeUnit(int timeUnit) {
        PropertyChangeEvent pce = new PropertyChangeEvent(this, "timeUnit", new Integer(this.timeUnit), new Integer(timeUnit));
        this.timeUnit = timeUnit;
        this.firePropertyChange(pce);
    }

    public String getInstrumentId() {
        return this.instrumentId;
    }

    public void setInstrumentId(String instrumentId) {
        this.instrumentId = instrumentId;
    }

    public int getPchGenerationMethod() {
        return this.pchGenerationMethod;
    }

    public void setPchGenerationMethod(int pchGenerationMethod) {
        PropertyChangeEvent pce = new PropertyChangeEvent(this, "pchGenerationMethod", new Integer(this.pchGenerationMethod), new Integer(pchGenerationMethod));
        this.pchGenerationMethod = pchGenerationMethod;
        this.firePropertyChange(pce);
    }

    public int getTransposition() {
        return this.transposition;
    }

    public void setTransposition(int transposition) {
        this.transposition = transposition;
    }

    @Override
    public NoteList generateForCSD(CompileData compileData, double startTime, double endTime) throws SoundObjectException {
        return this.generateNotes(startTime, endTime);
    }

    @Override
    public PianoRoll deepCopy() {
        return new PianoRoll(this);
    }
}

