/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject;

import blue.BlueSystem;
import blue.CompileData;
import blue.noteProcessor.NoteProcessorChain;
import blue.score.ScoreObjectEvent;
import blue.scripting.JavaScriptProxy;
import blue.soundObject.AbstractSoundObject;
import blue.soundObject.NoteList;
import blue.soundObject.OnLoadProcessable;
import blue.soundObject.SoundObject;
import blue.soundObject.SoundObjectException;
import blue.soundObject.SoundObjectUtilities;
import blue.utility.ScoreUtilities;
import electric.xml.Element;
import java.util.Map;

public class JavaScriptObject
extends AbstractSoundObject
implements OnLoadProcessable {
    private String javaScriptCode;
    private NoteProcessorChain npc = new NoteProcessorChain();
    private int timeBehavior;
    double repeatPoint = -1.0;
    private boolean onLoadProcessable = false;

    public JavaScriptObject() {
        this.setName("javaScriptObject");
        this.javaScriptCode = BlueSystem.getString("rhinoObject.defaultCode");
        this.javaScriptCode = this.javaScriptCode + "\n\nscore = \"i1 0 2 3 4 5\";";
        this.timeBehavior = 0;
    }

    public JavaScriptObject(JavaScriptObject ro) {
        super(ro);
        this.npc = new NoteProcessorChain(ro.npc);
        this.timeBehavior = ro.timeBehavior;
        this.repeatPoint = ro.repeatPoint;
        this.javaScriptCode = ro.javaScriptCode;
        this.onLoadProcessable = ro.onLoadProcessable;
    }

    public void setText(String text) {
        this.javaScriptCode = text;
    }

    public String getText() {
        return this.javaScriptCode;
    }

    @Override
    public double getObjectiveDuration() {
        return this.subjectiveDuration;
    }

    @Override
    public NoteProcessorChain getNoteProcessorChain() {
        return this.npc;
    }

    @Override
    public void setNoteProcessorChain(NoteProcessorChain chain) {
        this.npc = chain;
    }

    public NoteList generateNotes(double renderStart, double renderEnd) throws SoundObjectException {
        String soundObjectId = "[ " + this.name + " : " + this.startTime + " ] ";
        try {
            String tempScore = JavaScriptProxy.processJavascriptScore(this.javaScriptCode, this.subjectiveDuration, soundObjectId);
            NoteList nl = ScoreUtilities.getNotes(tempScore);
            ScoreUtilities.applyNoteProcessorChain(nl, this.npc);
            ScoreUtilities.applyTimeBehavior(nl, this.getTimeBehavior(), this.getSubjectiveDuration(), this.getRepeatPoint());
            ScoreUtilities.setScoreStart(nl, this.startTime);
            return nl;
        }
        catch (Exception e) {
            throw new SoundObjectException((SoundObject)this, (Throwable)e);
        }
    }

    @Override
    public int getTimeBehavior() {
        return this.timeBehavior;
    }

    @Override
    public void setTimeBehavior(int timeBehavior) {
        this.timeBehavior = timeBehavior;
    }

    @Override
    public double getRepeatPoint() {
        return this.repeatPoint;
    }

    @Override
    public void setRepeatPoint(double repeatPoint) {
        this.repeatPoint = repeatPoint;
        ScoreObjectEvent event = new ScoreObjectEvent(this, 4);
        this.fireScoreObjectEvent(event);
    }

    public static SoundObject loadFromXML(Element data, Map<String, Object> objRefMap) throws Exception {
        JavaScriptObject sObj = new JavaScriptObject();
        SoundObjectUtilities.initBasicFromXML(data, sObj);
        sObj.setText(data.getTextString("javaScriptCode"));
        String olpString = data.getAttributeValue("onLoadProcessable");
        if (olpString != null) {
            sObj.setOnLoadProcessable(Boolean.valueOf(olpString));
        }
        return sObj;
    }

    @Override
    public Element saveAsXML(Map<Object, String> objRefMap) {
        Element retVal = SoundObjectUtilities.getBasicXML(this);
        retVal.addElement("javaScriptCode").setText(this.getText());
        retVal.setAttribute("onLoadProcessable", Boolean.toString(this.onLoadProcessable));
        return retVal;
    }

    @Override
    public NoteList generateForCSD(CompileData compileData, double startTime, double endTime) throws SoundObjectException {
        return this.generateNotes(startTime, endTime);
    }

    @Override
    public SoundObject deepCopy() {
        return new JavaScriptObject(this);
    }

    @Override
    public void setOnLoadProcessable(boolean onLoadProcessable) {
        this.onLoadProcessable = onLoadProcessable;
    }

    @Override
    public boolean isOnLoadProcessable() {
        return this.onLoadProcessable;
    }

    @Override
    public void processOnLoad() throws SoundObjectException {
        if (this.onLoadProcessable) {
            this.generateNotes(0.0, -1.0);
        }
    }
}

