/*
 * Decompiled with CFR 0.152.
 */
package blue.score;

import blue.CompileData;
import blue.noteProcessor.NoteProcessorChain;
import blue.noteProcessor.NoteProcessorException;
import blue.score.ScoreGenerationException;
import blue.score.ScoreObject;
import blue.score.TimeState;
import blue.score.layers.Layer;
import blue.score.layers.LayerGroup;
import blue.score.layers.LayerGroupProviderManager;
import blue.score.layers.ScoreObjectLayer;
import blue.score.tempo.Tempo;
import blue.soundObject.NoteList;
import blue.soundObject.PolyObject;
import blue.util.ObservableArrayList;
import blue.utility.ScoreUtilities;
import electric.xml.Element;
import electric.xml.Elements;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Score
extends ObservableArrayList<LayerGroup<? extends Layer>> {
    Tempo tempo = null;
    TimeState timeState = null;
    private NoteProcessorChain npc;
    public static final int SPACER = 36;

    public Score() {
        this(true);
    }

    private Score(boolean populate) {
        if (populate) {
            PolyObject pObj = new PolyObject(true);
            this.add(pObj);
            this.timeState = new TimeState();
        }
        this.npc = new NoteProcessorChain();
        this.tempo = new Tempo();
    }

    public Score(Score score) {
        this.timeState = new TimeState(score.timeState);
        this.npc = new NoteProcessorChain(score.npc);
        this.tempo = new Tempo(score.tempo);
        for (LayerGroup lg : score) {
            this.add(lg.deepCopyLG());
        }
    }

    public Tempo getTempo() {
        return this.tempo;
    }

    public void setTempo(Tempo tempo) {
        this.tempo = tempo;
    }

    public TimeState getTimeState() {
        return this.timeState;
    }

    public void setTimeState(TimeState timeState) {
        this.timeState = timeState;
    }

    public NoteProcessorChain getNoteProcessorChain() {
        return this.npc;
    }

    public void setNoteProcessorChain(NoteProcessorChain npc) {
        this.npc = npc;
    }

    public Element saveAsXML(Map<Object, String> objRefMap) {
        Element retVal = new Element("score");
        retVal.addElement(this.tempo.saveAsXML());
        retVal.addElement(this.timeState.saveAsXML());
        retVal.addElement(this.npc.saveAsXML());
        for (LayerGroup layerGroup : this) {
            retVal.addElement(layerGroup.saveAsXML(objRefMap));
        }
        return retVal;
    }

    public static Score loadFromXML(Element data, Map<String, Object> objRefMap) throws Exception {
        Score score = new Score(false);
        Elements nodes = data.getElements();
        LayerGroupProviderManager manager = LayerGroupProviderManager.getInstance();
        block10: while (nodes.hasMoreElements()) {
            Element node = nodes.next();
            switch (node.getName()) {
                case "tempo": {
                    score.tempo = Tempo.loadFromXML(node);
                    continue block10;
                }
                case "timeState": {
                    score.timeState = TimeState.loadFromXML(node);
                    continue block10;
                }
                case "noteProcessorChain": {
                    score.npc = NoteProcessorChain.loadFromXML(node);
                    continue block10;
                }
            }
            LayerGroup layerGroup = manager.loadFromXML(node, objRefMap);
            if (layerGroup == null) {
                throw new RuntimeException("Unable to load Score LayerGroup of type: " + node.getName());
            }
            score.add(layerGroup);
            if (!(layerGroup instanceof PolyObject)) continue;
            ((PolyObject)layerGroup).setTimeBehavior(2);
        }
        if (score.size() == 0) {
            PolyObject pObj = new PolyObject(true);
            score.add(pObj);
        }
        return score;
    }

    public void processOnLoad() {
        for (LayerGroup layerGroup : this) {
            layerGroup.onLoadComplete();
        }
    }

    public NoteList generateForCSD(CompileData compileData, double startTime, double endTime) throws ScoreGenerationException {
        LayerGroup layerGroup2;
        NoteList noteList = new NoteList();
        boolean soloFound = false;
        Iterator iterator = this.iterator();
        while (iterator.hasNext() && !(soloFound = (layerGroup2 = (LayerGroup)iterator.next()).hasSoloLayers())) {
        }
        for (LayerGroup layerGroup2 : this) {
            NoteList nl = layerGroup2.generateForCSD(compileData, startTime, endTime, soloFound);
            noteList.merge(nl);
        }
        try {
            ScoreUtilities.applyNoteProcessorChain(noteList, this.npc);
        }
        catch (NoteProcessorException e) {
            throw new ScoreGenerationException(e);
        }
        return noteList;
    }

    public List<LayerGroup> getLayerGroupsForScoreObjects(Collection<? extends ScoreObject> scoreObjects) {
        ArrayList<LayerGroup> retVal = new ArrayList<LayerGroup>();
        block0: for (LayerGroup layerGroup : this) {
            for (Layer layer : layerGroup) {
                ScoreObjectLayer scoreLayer;
                boolean found = false;
                if (layer instanceof ScoreObjectLayer && !Collections.disjoint(scoreLayer = (ScoreObjectLayer)layer, scoreObjects)) {
                    retVal.add(layerGroup);
                    found = true;
                }
                if (!found) continue;
                continue block0;
            }
        }
        return retVal;
    }

    public List<Layer> getAllLayers() {
        ArrayList<Layer> retVal = new ArrayList<Layer>();
        for (LayerGroup layerGroup : this) {
            retVal.addAll(layerGroup);
        }
        return retVal;
    }

    public int getGlobalLayerIndexForY(int y) {
        int runningY = 0;
        int runningIndex = 0;
        for (LayerGroup layerGroup : this) {
            for (Layer layer : layerGroup) {
                if (y <= runningY + layer.getLayerHeight()) {
                    return runningIndex;
                }
                runningY += layer.getLayerHeight();
                ++runningIndex;
            }
            if (y <= runningY + 36) {
                return runningIndex;
            }
            runningY += 36;
        }
        return runningIndex - 1;
    }

    public Layer getGlobalLayerForY(int y) {
        int runningY = 0;
        for (LayerGroup layerGroup : this) {
            for (Layer layer : layerGroup) {
                if (y <= runningY + layer.getLayerHeight()) {
                    return layer;
                }
                runningY += layer.getLayerHeight();
            }
            if (y <= runningY + 36) {
                return null;
            }
            runningY += 36;
        }
        return null;
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + Objects.hashCode(this.tempo);
        hash = 79 * hash + Objects.hashCode(this.timeState);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        return obj == this;
    }
}

