/*
 * Decompiled with CFR 0.152.
 */
package blue.orchestra.blueSynthBuilder;

import blue.orchestra.blueSynthBuilder.BSBObject;
import blue.orchestra.blueSynthBuilder.UniqueNameCollection;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;

public class UniqueNameManager {
    private static MessageFormat NAME_FMT = new MessageFormat("{0}{1}");
    private UniqueNameCollection collection = null;
    private String defaultPrefix;

    public void setUniqueNameCollection(UniqueNameCollection collection) {
        this.collection = collection;
    }

    public UniqueNameCollection getUniqueNameCollection() {
        return this.collection;
    }

    public void setDefaultPrefix(String prefix) {
        this.defaultPrefix = prefix;
    }

    public boolean isUniquelyNamed(BSBObject bsbObj) {
        return this.isUniquelyNamed(bsbObj, this.collection == null ? new HashSet() : this.collection.getNames());
    }

    private boolean isUniquelyNamed(BSBObject bsbObj, Set<String> names) {
        String[] keys = bsbObj.getReplacementKeys();
        for (int i = 0; i < keys.length; ++i) {
            if (this.isUnique(keys[i], names)) continue;
            return false;
        }
        return true;
    }

    public void setUniqueName(BSBObject bsbObj) {
        String currentName = bsbObj.getObjectName();
        if (currentName == null || currentName.length() == 0) {
            return;
        }
        int nameIndex = 1;
        Object[] vals = new Object[]{this.getPrefix(currentName), new Integer(nameIndex)};
        Set<String> names = this.collection.getNames();
        BSBObject clone = (BSBObject)bsbObj.deepCopy();
        clone.setObjectName(NAME_FMT.format(vals));
        while (!this.isUniquelyNamed(clone, names)) {
            vals[1] = new Integer(++nameIndex);
            clone.setObjectName(NAME_FMT.format(vals));
        }
        bsbObj.setObjectName(clone.getObjectName());
    }

    protected String getPrefix(String name) {
        int index;
        for (index = name.length() - 1; index >= 0 && Character.isDigit(name.charAt(index)); --index) {
        }
        if (index < 0) {
            return "";
        }
        return name.substring(0, index + 1);
    }

    public boolean isUnique(String name) {
        return this.isUnique(name, this.collection.getNames());
    }

    private boolean isUnique(String name, Set<String> names) {
        return name == null || !names.contains(name);
    }

    public boolean equals(Object obj) {
        if (obj instanceof UniqueNameManager) {
            UniqueNameManager unm = (UniqueNameManager)obj;
            if (this.defaultPrefix.equals(unm.defaultPrefix)) {
                return true;
            }
        }
        return false;
    }
}

