/*
 * Decompiled with CFR 0.152.
 */
package blue.orchestra.blueSynthBuilder;

import blue.orchestra.blueSynthBuilder.BSBCompilationUnit;
import blue.orchestra.blueSynthBuilder.BSBFontUtil;
import blue.orchestra.blueSynthBuilder.BSBObject;
import blue.orchestra.blueSynthBuilder.SwingHTMLFontParser;
import electric.xml.Element;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.text.Font;

public class BSBLabel
extends BSBObject {
    StringProperty label = new SimpleStringProperty("label");
    ObjectProperty<Font> font = new SimpleObjectProperty((Object)new Font(12.0));

    public BSBLabel() {
    }

    public BSBLabel(BSBLabel label) {
        super(label);
        this.setLabel(label.getLabel());
        this.setFont(label.getFont());
    }

    public final void setLabel(String value) {
        this.label.set((Object)value);
    }

    public final String getLabel() {
        return (String)this.label.get();
    }

    public final StringProperty labelProperty() {
        return this.label;
    }

    public final void setFont(Font f) {
        this.font.set((Object)f);
    }

    public final Font getFont() {
        return (Font)this.font.get();
    }

    public final ObjectProperty<Font> fontProperty() {
        return this.font;
    }

    public static BSBObject loadFromXML(Element data) {
        String labelText;
        BSBLabel label = new BSBLabel();
        BSBLabel.initBasicFromXML(data, label);
        int version = 1;
        String versionStr = data.getAttributeValue("version");
        if (versionStr != null) {
            version = Integer.parseInt(versionStr);
        }
        if ((labelText = data.getTextString("label")) == null) {
            labelText = "";
        }
        if (version < 2) {
            label.setFont(SwingHTMLFontParser.parseFont(labelText));
            labelText = SwingHTMLFontParser.stripHTML(labelText);
            labelText = labelText.replace("&nbsp;", " ");
        } else {
            label.setFont(BSBFontUtil.loadFromXML(data.getElement("font")));
        }
        label.setLabel(labelText);
        return label;
    }

    @Override
    public Element saveAsXML() {
        Element retVal = BSBLabel.getBasicXML(this);
        retVal.setAttribute("version", "2");
        retVal.addElement("label").setText(this.getLabel());
        retVal.addElement(BSBFontUtil.saveAsXML(this.getFont()));
        return retVal;
    }

    @Override
    public void setupForCompilation(BSBCompilationUnit compilationUnit) {
    }

    @Override
    public String getPresetValue() {
        return null;
    }

    @Override
    public void setPresetValue(String val) {
    }

    @Override
    public BSBObject deepCopy() {
        return new BSBLabel(this);
    }
}

