/*
 * Decompiled with CFR 0.152.
 */
package blue.noteProcessor;

import blue.BlueSystem;
import blue.noteProcessor.NoteProcessor;
import blue.noteProcessor.NoteProcessorException;
import blue.soundObject.Note;
import blue.soundObject.NoteList;
import blue.soundObject.NoteParseException;
import electric.xml.Element;

public class EqualsProcessor
implements NoteProcessor {
    String value = "2.0";
    int pfield = 4;

    public EqualsProcessor() {
    }

    public EqualsProcessor(EqualsProcessor eqp) {
        this.value = eqp.value;
        this.pfield = eqp.pfield;
    }

    public String toString() {
        return "[equals]";
    }

    public String getPfield() {
        return Integer.toString(this.pfield);
    }

    public void setPfield(String pfield) {
        this.pfield = Integer.parseInt(pfield);
    }

    public String getVal() {
        return this.value;
    }

    public void setVal(String value) {
        this.value = value;
    }

    @Override
    public final void processNotes(NoteList in) throws NoteProcessorException {
        for (int i = 0; i < in.size(); ++i) {
            Note temp = (Note)in.get(i);
            try {
                if (this.pfield == 3) {
                    temp.setSubjectiveDuration(Double.parseDouble(this.value));
                    continue;
                }
                temp.setPField(this.value, this.pfield);
                continue;
            }
            catch (NumberFormatException ex) {
                throw new NoteProcessorException(this, BlueSystem.getString("noteProcessorException.pfieldNotDouble"), this.pfield);
            }
            catch (Exception ex) {
                throw new NoteProcessorException(this, BlueSystem.getString("noteProcessorException.missingPfield"), this.pfield);
            }
        }
    }

    public static void main(String[] args) {
        NoteList n = new NoteList();
        for (int i = 0; i < 10; ++i) {
            try {
                n.add(Note.createNote("i1 " + i * 2 + " 2 3 4"));
                continue;
            }
            catch (NoteParseException e) {
                e.printStackTrace();
            }
        }
        System.out.println("before: \n\n" + n + "\n\n");
        EqualsProcessor ep = new EqualsProcessor();
        ep.setPfield("4");
        ep.setVal("17");
        try {
            ep.processNotes(n);
        }
        catch (NoteProcessorException ex) {
            System.out.println("Error: " + ex.getMessage());
        }
        System.out.println("a after: \n\n" + n + "\n\n");
    }

    public static NoteProcessor loadFromXML(Element data) {
        EqualsProcessor ep = new EqualsProcessor();
        ep.setPfield(data.getElement("pfield").getTextString());
        ep.setVal(data.getElement("value").getTextString());
        return ep;
    }

    @Override
    public Element saveAsXML() {
        Element retVal = new Element("noteProcessor");
        retVal.setAttribute("type", this.getClass().getName());
        retVal.addElement("pfield").setText(this.getPfield());
        retVal.addElement("value").setText(this.getVal());
        return retVal;
    }

    @Override
    public EqualsProcessor deepCopy() {
        return new EqualsProcessor(this);
    }
}

