/*
 * Decompiled with CFR 0.152.
 */
package blue.mixer;

import blue.automation.Automatable;
import blue.automation.ParameterList;
import blue.orchestra.blueSynthBuilder.BSBCompilationUnit;
import blue.orchestra.blueSynthBuilder.BSBGraphicInterface;
import blue.orchestra.blueSynthBuilder.StringChannel;
import blue.udo.OpcodeList;
import blue.udo.UserDefinedOpcode;
import blue.utility.TextUtilities;
import blue.utility.UDOUtilities;
import blue.utility.XMLUtilities;
import electric.xml.Element;
import electric.xml.Elements;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import org.apache.commons.lang3.text.StrBuilder;

public class Effect
implements Automatable {
    private int numIns = 2;
    private int numOuts = 2;
    private BSBGraphicInterface graphicInterface;
    private String code = "";
    private String name = "New Effect";
    private String comments = "";
    private OpcodeList opcodeList;
    private boolean enabled = true;
    private transient Vector listeners = null;
    private ParameterList parameterList = null;

    public Effect() {
        this(true);
    }

    private Effect(boolean init) {
        if (init) {
            this.graphicInterface = new BSBGraphicInterface();
            this.parameterList = new ParameterList();
            this.graphicInterface.getRootGroup().setParameterList(this.parameterList);
            this.opcodeList = new OpcodeList();
        }
    }

    public Effect(Effect effect) {
        this.numIns = effect.numIns;
        this.numOuts = effect.numOuts;
        this.code = effect.code;
        this.name = effect.name;
        this.comments = effect.comments;
        this.enabled = effect.enabled;
        this.graphicInterface = new BSBGraphicInterface(effect.graphicInterface);
        this.parameterList = new ParameterList(effect.parameterList);
        this.graphicInterface.getRootGroup().setParameterList(this.parameterList);
        this.opcodeList = new OpcodeList(effect.opcodeList);
    }

    public UserDefinedOpcode generateUDO(OpcodeList udoList) {
        HashMap udoReplacementValues = UDOUtilities.appendUserDefinedOpcodes(this.opcodeList, udoList);
        UserDefinedOpcode udo = new UserDefinedOpcode();
        BSBCompilationUnit bsbUnit = new BSBCompilationUnit();
        this.graphicInterface.setupForCompilation(bsbUnit);
        StrBuilder buffer = new StrBuilder();
        buffer.append(this.getXinText()).append("\n");
        buffer.append(bsbUnit.replaceBSBValues(this.code)).append("\n");
        buffer.append(this.getXoutText()).append("\n");
        String udoCode = buffer.toString();
        if (udoReplacementValues != null) {
            udoCode = TextUtilities.replaceOpcodeNames(udoReplacementValues, udoCode);
        }
        udo.codeBody = udoCode;
        udo.inTypes = this.getSigTypes(this.numIns);
        udo.outTypes = this.getSigTypes(this.numOuts);
        return udo;
    }

    public static Effect loadFromXML(Element data) throws Exception {
        Effect effect = new Effect(false);
        Elements nodes = data.getElements();
        while (nodes.hasMoreElements()) {
            String nodeName;
            Element node = nodes.next();
            switch (nodeName = node.getName()) {
                case "name": {
                    effect.setName(node.getTextString());
                    break;
                }
                case "enabled": {
                    effect.setEnabled(XMLUtilities.readBoolean(node));
                    break;
                }
                case "numIns": {
                    effect.setNumIns(XMLUtilities.readInt(node));
                    break;
                }
                case "numOuts": {
                    effect.setNumOuts(XMLUtilities.readInt(node));
                    break;
                }
                case "code": {
                    effect.setCode(node.getTextString());
                    break;
                }
                case "comments": {
                    effect.setComments(node.getTextString());
                    break;
                }
                case "opcodeList": {
                    effect.opcodeList = OpcodeList.loadFromXML(node);
                    break;
                }
                case "graphicInterface": {
                    effect.setGraphicInterface(BSBGraphicInterface.loadFromXML(node));
                    break;
                }
                case "bsbParameterList": 
                case "parameterList": {
                    effect.parameterList = ParameterList.loadFromXML(node);
                }
            }
        }
        if (effect.opcodeList == null) {
            effect.opcodeList = new OpcodeList();
        }
        if (effect.graphicInterface == null) {
            effect.graphicInterface = new BSBGraphicInterface();
        }
        if (effect.parameterList == null) {
            effect.parameterList = new ParameterList();
        }
        effect.graphicInterface.getRootGroup().setParameterList(effect.parameterList);
        return effect;
    }

    public Element saveAsXML() {
        Element retVal = new Element("effect");
        retVal.addElement("name").setText(this.name);
        retVal.addElement(XMLUtilities.writeBoolean("enabled", this.enabled));
        retVal.addElement(XMLUtilities.writeInt("numIns", this.numIns));
        retVal.addElement(XMLUtilities.writeInt("numOuts", this.numOuts));
        retVal.addElement("code").setText(this.code);
        retVal.addElement("comments").setText(this.comments);
        retVal.addElement(this.opcodeList.saveAsXML());
        retVal.addElement(this.graphicInterface.saveAsXML());
        retVal.addElement(this.parameterList.saveAsXML());
        return retVal;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public int getNumIns() {
        return this.numIns;
    }

    public void setNumIns(int numIns) {
        Integer oldVal = new Integer(this.numIns);
        Integer newVal = new Integer(numIns);
        PropertyChangeEvent pce = new PropertyChangeEvent(this, "numIns", oldVal, newVal);
        this.numIns = numIns;
        this.firePropertyChangeEvent(pce);
    }

    public int getNumOuts() {
        return this.numOuts;
    }

    public void setNumOuts(int numOuts) {
        Integer oldVal = new Integer(this.numOuts);
        Integer newVal = new Integer(numOuts);
        PropertyChangeEvent pce = new PropertyChangeEvent(this, "numOuts", oldVal, newVal);
        this.numOuts = numOuts;
        this.firePropertyChangeEvent(pce);
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public OpcodeList getOpcodeList() {
        return this.opcodeList;
    }

    public BSBGraphicInterface getGraphicInterface() {
        return this.graphicInterface;
    }

    public void setGraphicInterface(BSBGraphicInterface graphicInterface) {
        this.graphicInterface = graphicInterface;
    }

    private void firePropertyChangeEvent(PropertyChangeEvent pce) {
        if (this.listeners == null) {
            return;
        }
        for (PropertyChangeListener listener : this.listeners) {
            listener.propertyChange(pce);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.add(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(pcl);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public String toString() {
        return this.getName();
    }

    private String getXinText() {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < this.numIns; ++i) {
            if (i > 0) {
                buffer.append(",");
            }
            buffer.append("ain").append(i + 1);
        }
        buffer.append("\txin");
        return buffer.toString();
    }

    private String getXoutText() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("xout\t");
        for (int i = 0; i < this.numOuts; ++i) {
            if (i > 0) {
                buffer.append(",");
            }
            buffer.append("aout").append(i + 1);
        }
        return buffer.toString();
    }

    private String getSigTypes(int num) {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < num; ++i) {
            buffer.append("a");
        }
        return buffer.toString();
    }

    @Override
    public ParameterList getParameterList() {
        return this.parameterList;
    }

    public void clearParameters() {
        this.parameterList = new ParameterList();
        this.graphicInterface.getRootGroup().setParameterList(this.parameterList);
    }

    @Override
    public ArrayList<StringChannel> getStringChannels() {
        return null;
    }
}

