/*
 * Decompiled with CFR 0.152.
 */
package blue;

import blue.utility.ValuesUtility;
import blue.utility.XMLUtilities;
import electric.xml.Element;
import electric.xml.Elements;
import org.apache.commons.lang3.builder.ToStringBuilder;

public final class ProjectProperties {
    public String title = "";
    public String author = "";
    public String notes = "";
    public String sampleRate = "44100";
    public String ksmps = "1";
    public String channels = "2";
    public boolean useZeroDbFS = false;
    public String zeroDbFS = "1";
    public String diskSampleRate = "44100";
    public String diskKsmps = "1";
    public String diskChannels = "2";
    public boolean diskUseZeroDbFS = false;
    public String diskZeroDbFS = "1";
    public boolean useAudioOut = true;
    public boolean useAudioIn = false;
    public boolean useMidiIn = false;
    public boolean useMidiOut = false;
    public boolean noteAmpsEnabled = true;
    public boolean outOfRangeEnabled = true;
    public boolean warningsEnabled = true;
    public boolean benchmarkEnabled = true;
    public String advancedSettings = "";
    public boolean completeOverride = false;
    public String fileName = "";
    public boolean askOnRender = false;
    public boolean diskNoteAmpsEnabled = true;
    public boolean diskOutOfRangeEnabled = true;
    public boolean diskWarningsEnabled = true;
    public boolean diskBenchmarkEnabled = true;
    public String diskAdvancedSettings = "";
    public boolean diskCompleteOverride = false;
    public boolean diskAlwaysRenderEntireProject = false;

    public ProjectProperties() {
    }

    public ProjectProperties(ProjectProperties props) {
        this.title = props.title;
        this.author = props.author;
        this.notes = props.notes;
        this.sampleRate = props.sampleRate;
        this.ksmps = props.ksmps;
        this.channels = props.channels;
        this.useZeroDbFS = props.useZeroDbFS;
        this.zeroDbFS = props.zeroDbFS;
        this.diskSampleRate = props.diskSampleRate;
        this.diskKsmps = props.diskKsmps;
        this.diskChannels = props.diskChannels;
        this.diskUseZeroDbFS = props.diskUseZeroDbFS;
        this.diskZeroDbFS = props.diskZeroDbFS;
        this.useAudioOut = props.useAudioOut;
        this.useAudioIn = props.useAudioIn;
        this.useMidiIn = props.useMidiIn;
        this.useMidiOut = props.useMidiOut;
        this.noteAmpsEnabled = props.noteAmpsEnabled;
        this.outOfRangeEnabled = props.outOfRangeEnabled;
        this.warningsEnabled = props.warningsEnabled;
        this.benchmarkEnabled = props.benchmarkEnabled;
        this.advancedSettings = props.advancedSettings;
        this.completeOverride = props.completeOverride;
        this.fileName = props.fileName;
        this.askOnRender = props.askOnRender;
        this.diskNoteAmpsEnabled = props.diskNoteAmpsEnabled;
        this.diskOutOfRangeEnabled = props.diskOutOfRangeEnabled;
        this.diskWarningsEnabled = props.diskWarningsEnabled;
        this.diskBenchmarkEnabled = props.diskBenchmarkEnabled;
        this.diskAdvancedSettings = props.diskAdvancedSettings;
        this.diskCompleteOverride = props.diskCompleteOverride;
        this.diskAlwaysRenderEntireProject = props.diskAlwaysRenderEntireProject;
    }

    public String getKsmps() {
        return this.ksmps;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public static ProjectProperties loadFromXML(Element data) {
        ProjectProperties retVal = new ProjectProperties();
        Elements nodes = data.getElements();
        String kr = null;
        String commandLine = null;
        String diskCommandLine = null;
        while (nodes.hasMoreElements()) {
            Element node = nodes.next();
            String nodeName = node.getName();
            String nodeVal = node.getTextString();
            switch (nodeName) {
                case "title": {
                    retVal.title = nodeVal;
                    break;
                }
                case "author": {
                    retVal.author = nodeVal;
                    break;
                }
                case "notes": {
                    retVal.notes = nodeVal;
                    break;
                }
                case "sampleRate": {
                    retVal.sampleRate = nodeVal;
                    break;
                }
                case "controlRate": {
                    kr = nodeVal;
                    break;
                }
                case "ksmps": {
                    retVal.ksmps = nodeVal;
                    break;
                }
                case "useZeroDbFS": {
                    retVal.useZeroDbFS = Boolean.valueOf(nodeVal);
                    break;
                }
                case "zeroDbFS": {
                    retVal.zeroDbFS = nodeVal;
                    break;
                }
                case "channels": {
                    retVal.channels = nodeVal;
                    break;
                }
                case "commandLine": {
                    commandLine = nodeVal;
                    break;
                }
                case "diskSampleRate": {
                    retVal.diskSampleRate = nodeVal;
                    break;
                }
                case "diskKsmps": {
                    retVal.diskKsmps = nodeVal;
                    break;
                }
                case "diskChannels": {
                    retVal.diskChannels = nodeVal;
                    break;
                }
                case "diskCommandLine": {
                    diskCommandLine = nodeVal;
                    break;
                }
                case "diskUseZeroDbFS": {
                    retVal.diskUseZeroDbFS = Boolean.valueOf(nodeVal);
                    break;
                }
                case "diskZeroDbFS": {
                    retVal.diskZeroDbFS = nodeVal;
                    break;
                }
                case "useAudioOut": {
                    retVal.useAudioOut = Boolean.valueOf(nodeVal);
                    break;
                }
                case "useAudioIn": {
                    retVal.useAudioIn = Boolean.valueOf(nodeVal);
                    break;
                }
                case "useMidiIn": {
                    retVal.useMidiIn = Boolean.valueOf(nodeVal);
                    break;
                }
                case "useMidiOut": {
                    retVal.useMidiOut = Boolean.valueOf(nodeVal);
                    break;
                }
                case "noteAmpsEnabled": {
                    retVal.noteAmpsEnabled = Boolean.valueOf(nodeVal);
                    break;
                }
                case "outOfRangeEnabled": {
                    retVal.outOfRangeEnabled = Boolean.valueOf(nodeVal);
                    break;
                }
                case "warningsEnabled": {
                    retVal.warningsEnabled = Boolean.valueOf(nodeVal);
                    break;
                }
                case "benchmarkEnabled": {
                    retVal.benchmarkEnabled = Boolean.valueOf(nodeVal);
                    break;
                }
                case "advancedSettings": {
                    retVal.advancedSettings = nodeVal;
                    break;
                }
                case "completeOverride": {
                    retVal.completeOverride = Boolean.valueOf(nodeVal);
                    break;
                }
                case "fileName": {
                    retVal.fileName = nodeVal;
                    break;
                }
                case "askOnRender": {
                    retVal.askOnRender = Boolean.valueOf(nodeVal);
                    break;
                }
                case "diskNoteAmpsEnabled": {
                    retVal.diskNoteAmpsEnabled = Boolean.valueOf(nodeVal);
                    break;
                }
                case "diskOutOfRangeEnabled": {
                    retVal.diskOutOfRangeEnabled = Boolean.valueOf(nodeVal);
                    break;
                }
                case "diskWarningsEnabled": {
                    retVal.diskWarningsEnabled = Boolean.valueOf(nodeVal);
                    break;
                }
                case "diskBenchmarkEnabled": {
                    retVal.diskBenchmarkEnabled = Boolean.valueOf(nodeVal);
                    break;
                }
                case "diskAdvancedSettings": {
                    retVal.diskAdvancedSettings = nodeVal;
                    break;
                }
                case "diskCompleteOverride": {
                    retVal.diskCompleteOverride = Boolean.valueOf(nodeVal);
                    break;
                }
                case "diskAlwaysRenderEntireProject": {
                    retVal.diskAlwaysRenderEntireProject = Boolean.valueOf(nodeVal);
                }
            }
        }
        if (kr != null && kr.length() > 0 && retVal.ksmps != null && retVal.ksmps.length() == 0) {
            try {
                int ksmpsNum = Integer.parseInt(retVal.sampleRate) / Integer.parseInt(kr);
                retVal.ksmps = Integer.toString(ksmpsNum);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (commandLine != null) {
            retVal.advancedSettings = commandLine;
            retVal.completeOverride = true;
        }
        if (diskCommandLine != null) {
            retVal.diskAdvancedSettings = diskCommandLine;
            retVal.diskCompleteOverride = true;
        }
        ValuesUtility.checkNullString(retVal);
        return retVal;
    }

    public Element saveAsXML() {
        Element retVal = new Element("projectProperties");
        retVal.addElement("title").setText(this.title);
        retVal.addElement("author").setText(this.author);
        retVal.addElement("notes").setText(this.notes);
        retVal.addElement("sampleRate").setText(this.sampleRate);
        retVal.addElement("ksmps").setText(this.ksmps);
        retVal.addElement("channels").setText(this.channels);
        retVal.addElement(XMLUtilities.writeBoolean("useZeroDbFS", this.useZeroDbFS));
        retVal.addElement("zeroDbFS").setText(this.zeroDbFS);
        retVal.addElement("diskSampleRate").setText(this.diskSampleRate);
        retVal.addElement("diskKsmps").setText(this.diskKsmps);
        retVal.addElement("diskChannels").setText(this.diskChannels);
        retVal.addElement(XMLUtilities.writeBoolean("diskUseZeroDbFS", this.diskUseZeroDbFS));
        retVal.addElement("diskZeroDbFS").setText(this.diskZeroDbFS);
        retVal.addElement(XMLUtilities.writeBoolean("useAudioOut", this.useAudioOut));
        retVal.addElement(XMLUtilities.writeBoolean("useAudioIn", this.useAudioIn));
        retVal.addElement(XMLUtilities.writeBoolean("useMidiIn", this.useMidiIn));
        retVal.addElement(XMLUtilities.writeBoolean("useMidiOut", this.useMidiOut));
        retVal.addElement(XMLUtilities.writeBoolean("noteAmpsEnabled", this.noteAmpsEnabled));
        retVal.addElement(XMLUtilities.writeBoolean("outOfRangeEnabled", this.outOfRangeEnabled));
        retVal.addElement(XMLUtilities.writeBoolean("warningsEnabled", this.warningsEnabled));
        retVal.addElement(XMLUtilities.writeBoolean("benchmarkEnabled", this.benchmarkEnabled));
        retVal.addElement("advancedSettings").setText(this.advancedSettings);
        retVal.addElement(XMLUtilities.writeBoolean("completeOverride", this.completeOverride));
        retVal.addElement("fileName").setText(this.fileName);
        retVal.addElement(XMLUtilities.writeBoolean("askOnRender", this.askOnRender));
        retVal.addElement(XMLUtilities.writeBoolean("diskNoteAmpsEnabled", this.diskNoteAmpsEnabled));
        retVal.addElement(XMLUtilities.writeBoolean("diskOutOfRangeEnabled", this.diskOutOfRangeEnabled));
        retVal.addElement(XMLUtilities.writeBoolean("diskWarningsEnabled", this.diskWarningsEnabled));
        retVal.addElement(XMLUtilities.writeBoolean("diskBenchmarkEnabled", this.diskBenchmarkEnabled));
        retVal.addElement("diskAdvancedSettings").setText(this.diskAdvancedSettings);
        retVal.addElement(XMLUtilities.writeBoolean("diskCompleteOverride", this.diskCompleteOverride));
        retVal.addElement(XMLUtilities.writeBoolean("diskAlwaysRenderEntireProject", this.diskAlwaysRenderEntireProject));
        return retVal;
    }
}

