/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import tcl.lang.Channel;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclIO;

public class SocketChannel
extends Channel {
    private Socket sock;

    public SocketChannel(Interp interp, int mode, String localAddr, int localPort, boolean async, String address, int port) throws IOException, TclException {
        InetAddress localAddress = null;
        InetAddress addr = null;
        if (async) {
            throw new TclException(interp, "Asynchronous socket connection not currently implemented");
        }
        if (!localAddr.equals("")) {
            try {
                localAddress = InetAddress.getByName(localAddr);
            }
            catch (UnknownHostException e) {
                throw new TclException(interp, "host unknown: " + localAddr);
            }
        }
        try {
            addr = InetAddress.getByName(address);
        }
        catch (UnknownHostException e) {
            throw new TclException(interp, "host unknown: " + address);
        }
        this.mode = mode;
        this.sock = localAddress != null && localPort != 0 ? new Socket(addr, port, localAddress, localPort) : new Socket(addr, port);
        this.setChanName(TclIO.getNextDescriptor(interp, "sock"));
    }

    public SocketChannel(Interp interp, Socket s) throws IOException, TclException {
        this.mode = 4;
        this.sock = s;
        this.setChanName(TclIO.getNextDescriptor(interp, "sock"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() throws IOException {
        try {
            super.close();
        }
        finally {
            this.sock.close();
        }
    }

    String getChanType() {
        return "tcp";
    }

    protected InputStream getInputStream() throws IOException {
        return this.sock.getInputStream();
    }

    protected OutputStream getOutputStream() throws IOException {
        return this.sock.getOutputStream();
    }
}

