/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.utilities;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SelectionModel {
    int anchor = -1;
    int end = -1;
    int lastIndexSet = -1;
    List<ChangeListener> listeners = null;
    ChangeEvent ce = null;

    public void setAnchor(int index) {
        this.end = this.anchor = index;
        this.lastIndexSet = index;
        this.fireChangeEvent();
    }

    public void setEnd(int index) {
        if (this.anchor < 0) {
            this.anchor = index;
        }
        this.end = index;
        this.lastIndexSet = index;
        this.fireChangeEvent();
    }

    public void clear() {
        this.lastIndexSet = -1;
        this.anchor = -1;
        this.end = -1;
        this.fireChangeEvent();
    }

    public int getStartIndex() {
        if (this.anchor < 0) {
            return -1;
        }
        return this.anchor < this.end ? this.anchor : this.end;
    }

    public int getEndIndex() {
        if (this.end < 0) {
            return this.getStartIndex();
        }
        return this.anchor > this.end ? this.anchor : this.end;
    }

    public int getLastIndexSet() {
        return this.lastIndexSet;
    }

    public void addChangeListener(ChangeListener cl) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<ChangeListener>();
        }
        this.listeners.add(cl);
    }

    public void removeChangeListener(ChangeListener cl) {
        if (this.listeners != null) {
            this.listeners.remove(cl);
        }
    }

    public void fireChangeEvent() {
        if (this.listeners == null || this.listeners.size() == 0) {
            return;
        }
        if (this.ce == null) {
            this.ce = new ChangeEvent(this);
        }
        for (ChangeListener cl : this.listeners) {
            cl.stateChanged(this.ce);
        }
    }
}

