/*
 * Decompiled with CFR 0.152.
 */
package blue.score.layers.audio.ui;

import blue.score.layers.audio.core.AudioClip;
import blue.score.layers.audio.core.FadeType;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class FadeTypePopup
extends JPopupMenu {
    private AudioClip clip;
    private boolean fadeIn;
    private static FadeTypePopup instance = null;

    public static FadeTypePopup getInstance() {
        if (instance == null) {
            instance = new FadeTypePopup();
        }
        return instance;
    }

    private FadeTypePopup() {
        for (final FadeType f : FadeType.values()) {
            AbstractAction a = new AbstractAction(f.toString()){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    FadeTypePopup.this.setType(f);
                }
            };
            JMenuItem menuItem = new JMenuItem(a);
            this.add(a);
        }
    }

    protected void setType(FadeType f) {
        if (this.fadeIn) {
            this.clip.setFadeInType(f);
        } else {
            this.clip.setFadeOutType(f);
        }
        this.clip = null;
    }

    public void setup(AudioClip clip, boolean fadeIn) {
        this.clip = clip;
        this.fadeIn = fadeIn;
    }
}

