/*
 * Decompiled with CFR 0.152.
 */
package blue.score.layers.audio.ui;

import blue.score.layers.audio.core.AudioClip;
import blue.score.layers.audio.core.AudioLayer;
import blue.score.layers.audio.core.AudioLayerGroup;
import blue.score.layers.audio.ui.AudioLayersPanel;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.io.File;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.List;
import org.openide.nodes.Node;
import org.openide.nodes.NodeTransfer;

public class AudioLayersDropTargetListener
implements DropTargetListener {
    DropTarget target;
    private AudioLayersPanel audioLayersPanel;

    public AudioLayersDropTargetListener(AudioLayersPanel sTimeCanvas) {
        this.audioLayersPanel = sTimeCanvas;
        this.target = new DropTarget(sTimeCanvas, this);
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        boolean isFile = dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor);
        if (!isFile && dtde.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            isFile = true;
        }
        if (isFile) {
            dtde.acceptDrag(0x40000000);
        } else {
            Node node = NodeTransfer.node((Transferable)dtde.getTransferable(), (int)1);
            File f = (File)node.getLookup().lookup(File.class);
            if (node != null && f != null && f.isFile()) {
                dtde.acceptDrag(1);
            } else {
                dtde.rejectDrag();
            }
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        Node node = NodeTransfer.node((Transferable)dtde.getTransferable(), (int)1);
        if (node != null) {
            File f = (File)node.getLookup().lookup(File.class);
            if (f == null || !f.isFile()) {
                dtde.dropComplete(false);
                return;
            }
            dtde.acceptDrop(1);
            Point p = dtde.getLocation();
            AudioLayerGroup audioLayerGroup = this.audioLayersPanel.getAudioLayerGroup();
            int index = audioLayerGroup.getLayerNumForY(p.y);
            AudioClip af = new AudioClip();
            af.setName(f.getName());
            af.setAudioFile(f);
            float startTime = (float)p.x / (float)this.audioLayersPanel.getTimeState().getPixelSecond();
            af.setStartTime((double)startTime);
            af.setSubjectiveDuration(af.getAudioDuration());
            AudioLayer layer = (AudioLayer)audioLayerGroup.get(index);
            layer.add(af);
            dtde.dropComplete(true);
        }
        try {
            Point p;
            Transferable tr = dtde.getTransferable();
            if (dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                dtde.acceptDrop(0x40000000);
                List list = (List)tr.getTransferData(DataFlavor.javaFileListFlavor);
                if (list.size() != 1) {
                    dtde.dropComplete(false);
                    return;
                }
                String s = list.get(0).toString().trim();
                System.out.println("file flavor found: " + s);
                if (!(s.toLowerCase().endsWith("wav") || s.toLowerCase().endsWith("aif") || s.toLowerCase().endsWith("aiff"))) {
                    dtde.dropComplete(false);
                    return;
                }
                String sObjName = s.substring(s.lastIndexOf(File.separator) + 1);
                p = dtde.getLocation();
                AudioLayerGroup audioLayerGroup = this.audioLayersPanel.getAudioLayerGroup();
                int index = audioLayerGroup.getLayerNumForY(p.y);
                AudioClip af = new AudioClip();
                af.setName(sObjName);
                af.setAudioFile(new File(s));
                float startTime = (float)p.x / (float)this.audioLayersPanel.getTimeState().getPixelSecond();
                af.setStartTime((double)startTime);
                af.setSubjectiveDuration(af.getAudioDuration());
                AudioLayer layer = (AudioLayer)audioLayerGroup.get(index);
                layer.add(af);
                dtde.dropComplete(true);
                return;
            }
            if (dtde.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                dtde.acceptDrop(0x40000000);
                String str = (String)tr.getTransferData(DataFlavor.stringFlavor);
                System.out.println("String flavor found: " + str);
                if (!str.startsWith("file://")) {
                    dtde.dropComplete(false);
                    return;
                }
                if (!((str = str.substring(7).trim()).toLowerCase().endsWith("wav") || str.toLowerCase().endsWith("aif") || str.toLowerCase().endsWith("aiff"))) {
                    System.err.println("Could not open file: " + str);
                    dtde.dropComplete(false);
                    return;
                }
                str = URLDecoder.decode(str);
                File f = new File(str = str.replaceAll(" ", "\\ "));
                if (!f.exists()) {
                    dtde.dropComplete(false);
                    return;
                }
                String sObjName = str.substring(str.lastIndexOf(File.separator) + 1);
                p = dtde.getLocation();
                AudioLayerGroup audioLayerGroup = this.audioLayersPanel.getAudioLayerGroup();
                int index = audioLayerGroup.getLayerNumForY(p.y);
                AudioClip af = new AudioClip();
                af.setName(sObjName);
                af.setAudioFile(f);
                float startTime = (float)p.x / (float)this.audioLayersPanel.getTimeState().getPixelSecond();
                af.setStartTime((double)startTime);
                af.setSubjectiveDuration(af.getAudioDuration());
                AudioLayer layer = (AudioLayer)audioLayerGroup.get(index);
                layer.add(af);
                dtde.dropComplete(true);
                return;
            }
            dtde.rejectDrop();
        }
        catch (UnsupportedFlavorException | InvalidDnDOperationException | IOException e) {
            e.printStackTrace();
            dtde.rejectDrop();
        }
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }
}

