/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.soundObject.renderer;

import blue.soundObject.PianoRoll;
import blue.soundObject.pianoRoll.PianoNote;
import blue.ui.core.score.layers.soundObject.SoundObjectView;
import blue.ui.core.soundObject.renderer.GenericRenderer;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Collections;

public class PianoRollRenderer
extends GenericRenderer {
    @Override
    public void render(Graphics graphics, SoundObjectView sObjView, int pixelSeconds) {
        super.render(graphics, sObjView, pixelSeconds);
        if (sObjView.getHeight() <= 22) {
            return;
        }
        PianoRoll pianoRoll = (PianoRoll)sObjView.getSoundObject();
        PianoRollValueCache cache = this.generateCache(pianoRoll);
        if (cache.range == 0) {
            return;
        }
    }

    protected PianoRollValueCache generateCache(PianoRoll pianoRoll) {
        PianoRollValueCache cache = new PianoRollValueCache();
        ArrayList notes = pianoRoll.getNotes();
        if (notes.size() == 0) {
            cache.min = 0;
            cache.max = 0;
            cache.range = 0;
        } else {
            Collections.sort(notes);
            int scaleDegrees = pianoRoll.getScale().getNumScaleDegrees();
            PianoNote noteMin = (PianoNote)notes.get(0);
            PianoNote noteMax = (PianoNote)notes.get(notes.size() - 1);
            cache.min = noteMin.getOctave() * scaleDegrees + noteMin.getScaleDegree();
            cache.max = noteMax.getOctave() * scaleDegrees + noteMax.getScaleDegree();
            cache.range = cache.max - cache.min;
        }
        return cache;
    }

    class PianoRollValueCache {
        int max;
        int min;
        int range;

        PianoRollValueCache() {
        }
    }
}

