/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.soundObject.renderer;

import blue.BlueSystem;
import blue.soundObject.AudioFile;
import blue.soundObject.SoundObject;
import blue.ui.core.score.layers.soundObject.SoundObjectView;
import blue.ui.core.soundObject.renderer.BarRenderer;
import blue.ui.utilities.audio.AudioWaveformCache;
import blue.ui.utilities.audio.AudioWaveformData;
import blue.ui.utilities.audio.AudioWaveformListener;
import blue.ui.utilities.audio.AudioWaveformUI;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JComponent;

public class AudioFileRenderer
implements BarRenderer {
    private static final String AUDIO_WAVEFORM_DATA = "audioWaveformData";
    protected int labelOffset = 5;
    private static Font renderFont = new Font("Dialog", 1, 12);
    protected static Color selectedBgColor = new Color(255, 255, 255, 128);
    protected static Color selectedBorder1 = selectedBgColor.brighter().brighter();
    protected static Color selectedBorder2 = selectedBgColor.darker().darker();
    protected static Color selectedFontColor = Color.darkGray;
    protected static AudioWaveformCache waveCache = AudioWaveformCache.getInstance();

    private boolean isBright(Color c) {
        return c.getRed() + c.getGreen() + c.getBlue() > 384;
    }

    @Override
    public void render(Graphics graphics, SoundObjectView sObjView, int pixelSeconds) {
        Color fontColor;
        Color border2;
        Color border1;
        Color bgColor;
        Rectangle clip = graphics.getClipBounds();
        Graphics2D g = (Graphics2D)graphics;
        int w = sObjView.getSize().width;
        int h = sObjView.getSize().height;
        SoundObject sObj = sObjView.getSoundObject();
        if (sObjView.isSelected()) {
            bgColor = selectedBgColor;
            border1 = selectedBorder1;
            border2 = selectedBorder2;
            fontColor = selectedFontColor;
        } else {
            bgColor = sObj.getBackgroundColor();
            border1 = bgColor.brighter().brighter();
            border2 = bgColor.darker().darker();
            fontColor = this.isBright(bgColor) ? Color.BLACK : Color.WHITE;
        }
        Color waveColor = this.isBright(bgColor) ? bgColor.brighter().brighter() : bgColor.darker().darker();
        g.setPaint(bgColor);
        g.fillRect(clip.x, 2, clip.width, h - 4);
        g.setPaint(waveColor);
        this.paintWaveform(g, sObjView, pixelSeconds);
        g.setColor(border1);
        g.drawLine(0, 2, w - 1, 2);
        g.drawLine(0, 2, 0, h - 4);
        g.setColor(border2);
        g.drawLine(0, h - 3, w, h - 3);
        g.drawLine(w - 1, h - 3, w - 1, 2);
        g.setPaint(fontColor);
        if (h >= 20) {
            g.setComposite(AlphaComposite.Src);
            g.setFont(renderFont);
            String[] parts = sObjView.getSoundObject().getName().split("\\\\[n]");
            for (int i = 0; i < parts.length; ++i) {
                int y = 15 + i * 22;
                g.drawString(parts[i], this.labelOffset, y);
            }
        }
    }

    private void paintWaveform(Graphics2D g, SoundObjectView sObjView, int pixelSeconds) {
        AudioFile audioFile = (AudioFile)sObjView.getSoundObject();
        String audioFilename = audioFile.getSoundFileName();
        int sObjVisibleHeight = sObjView.getHeight() - 4;
        AudioWaveformData waveData = (AudioWaveformData)sObjView.getClientProperty(AUDIO_WAVEFORM_DATA);
        if (waveData == null) {
            waveData = waveCache.getAudioWaveformData(BlueSystem.getFullPath((String)audioFilename), pixelSeconds);
            if (waveData.percentLoadingComplete < 1.0) {
                waveCache.addAudioWaveformListener(new AudioWaveformListener(audioFilename, (JComponent)sObjView));
            }
            sObjView.putClientProperty(AUDIO_WAVEFORM_DATA, waveData);
        } else if (waveData.pixelSeconds != pixelSeconds || !waveData.fileName.equals(audioFile.getSoundFileName())) {
            waveData = waveCache.getAudioWaveformData(BlueSystem.getFullPath((String)audioFilename), pixelSeconds);
            sObjView.putClientProperty(AUDIO_WAVEFORM_DATA, waveData);
            if (waveData.percentLoadingComplete < 1.0) {
                waveCache.addAudioWaveformListener(new AudioWaveformListener(audioFilename, (JComponent)sObjView));
            }
        }
        g.translate(1, 2);
        AudioWaveformUI.paintWaveForm((Graphics2D)g, (int)sObjVisibleHeight, (AudioWaveformData)waveData, (int)0);
        g.translate(-1, -2);
    }

    @Override
    public void cleanup(SoundObjectView sObjView) {
        sObjView.putClientProperty(AUDIO_WAVEFORM_DATA, null);
    }
}

