/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.soundFile;

import blue.BlueSystem;
import blue.gui.LabelledItemPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SoundFileInformationPanel
extends JComponent {
    JLabel durationText = new JLabel();
    JLabel formatTypeText = new JLabel();
    JLabel byteLengthText = new JLabel();
    JLabel encodingTypeText = new JLabel();
    JLabel sampleRateText = new JLabel();
    JLabel sampleSizeInBitsText = new JLabel();
    JLabel channelsText = new JLabel();
    JLabel isBigEndianText = new JLabel();
    JPanel ftablePanel = new JPanel();
    JTextField fTableText = new JTextField();
    JButton ftableCopyButton = new JButton();
    LabelledItemPanel itemPanel = new LabelledItemPanel();

    public SoundFileInformationPanel() {
        this.setLayout(new BorderLayout());
        this.ftablePanel.setLayout(new BorderLayout());
        this.ftablePanel.add((Component)this.fTableText, "Center");
        this.ftablePanel.add((Component)this.ftableCopyButton, "East");
        this.ftableCopyButton.addActionListener(e -> {
            this.fTableText.selectAll();
            this.fTableText.copy();
        });
        this.ftableCopyButton.setText(BlueSystem.getString((String)"soundfile.infoPanel.copy"));
        this.itemPanel.addItem(BlueSystem.getString((String)"soundfile.infoPanel.duration") + " ", this.durationText);
        this.itemPanel.addItem(BlueSystem.getString((String)"soundfile.infoPanel.formatType") + " ", this.formatTypeText);
        this.itemPanel.addItem(BlueSystem.getString((String)"soundfile.infoPanel.byteLength") + " ", this.byteLengthText);
        this.itemPanel.addItem(BlueSystem.getString((String)"soundfile.infoPanel.encodingType") + " ", this.encodingTypeText);
        this.itemPanel.addItem(BlueSystem.getString((String)"soundfile.infoPanel.sampleRate") + " ", this.sampleRateText);
        this.itemPanel.addItem(BlueSystem.getString((String)"soundfile.infoPanel.sampleSize") + " ", this.sampleSizeInBitsText);
        this.itemPanel.addItem(BlueSystem.getString((String)"soundfile.infoPanel.channels") + " ", this.channelsText);
        this.itemPanel.addItem(BlueSystem.getString((String)"soundfile.infoPanel.isBigEndian") + " ", this.isBigEndianText);
        this.itemPanel.addItem(BlueSystem.getString((String)"soundfile.infoPanel.gen01table") + " ", this.ftablePanel);
        this.add((Component)this.itemPanel, "Center");
    }

    public void setSoundFile(File soundFile) {
        try {
            AudioFileFormat aFormat = AudioSystem.getAudioFileFormat(soundFile);
            AudioFormat format = aFormat.getFormat();
            this.durationText.setText(this.getDuration(aFormat, format));
            this.formatTypeText.setText(aFormat.getType().toString());
            this.byteLengthText.setText(Integer.toString(aFormat.getByteLength()));
            this.encodingTypeText.setText(format.getEncoding().toString());
            this.sampleRateText.setText(Float.toString(format.getSampleRate()));
            this.sampleSizeInBitsText.setText(Integer.toString(format.getSampleSizeInBits()));
            this.channelsText.setText(Integer.toString(format.getChannels()));
            this.isBigEndianText.setText(this.getBooleanString(format.isBigEndian()));
            this.setFtableText(soundFile, aFormat.getByteLength());
            this.fTableText.copy();
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(null, BlueSystem.getString((String)"soundfile.infoPanel.error.couldNotOpenFile") + " " + soundFile.getAbsolutePath());
            this.clearAudioInfo();
            return;
        }
        catch (UnsupportedAudioFileException uae) {
            JOptionPane.showMessageDialog(null, BlueSystem.getString((String)"soundfile.infoPanel.error.unsupportedAudio") + " " + uae.getLocalizedMessage());
            this.clearAudioInfo();
            return;
        }
    }

    private String getDuration(AudioFileFormat aFormat, AudioFormat format) {
        float duration = (float)aFormat.getByteLength() / (format.getSampleRate() * (float)(format.getSampleSizeInBits() / 8) * (float)format.getChannels());
        int hours = (int)duration / 3600;
        int minutes = (int)(duration -= (float)(hours * 3600)) / 60;
        String h = Integer.toString(hours);
        String m = Integer.toString(minutes);
        String s = Float.toString(duration -= (float)(minutes * 60));
        if (hours < 10) {
            h = "0" + h;
        }
        if (minutes < 10) {
            m = "0" + m;
        }
        if (duration < 10.0f) {
            s = "0" + s;
        }
        return h + ":" + m + ":" + s;
    }

    void setFtableText(File f, int byteLength) {
        String fTableString = "f0 0 " + this.closestPowerOfTwo(byteLength) + " 1 \"" + f.getAbsolutePath() + "\" 0 0 0 ";
        this.fTableText.setText(fTableString);
    }

    private int closestPowerOfTwo(int byteLength) {
        int tableSize;
        for (tableSize = 2; tableSize < byteLength; tableSize = 2 * tableSize) {
        }
        return tableSize;
    }

    void clearAudioInfo() {
    }

    private String getBooleanString(boolean val) {
        if (val) {
            return BlueSystem.getString((String)"soundfile.infoPanel.true");
        }
        return BlueSystem.getString((String)"soundfile.infoPanel.false");
    }
}

