/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.score.undo;

import blue.BlueSystem;
import blue.score.ScoreObject;
import blue.score.layers.ScoreObjectLayer;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class RemoveScoreObjectEdit
extends AbstractUndoableEdit {
    private final ScoreObject sObj;
    private final ScoreObjectLayer layer;
    RemoveScoreObjectEdit nextEdit = null;

    public RemoveScoreObjectEdit(ScoreObjectLayer layer, ScoreObject sObj) {
        this.layer = layer;
        this.sObj = sObj;
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.layer.remove(this.sObj);
        if (this.nextEdit != null) {
            this.nextEdit.redo();
        }
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.layer.add((Object)this.sObj);
        if (this.nextEdit != null) {
            this.nextEdit.undo();
        }
    }

    @Override
    public String getPresentationName() {
        if (this.nextEdit == null) {
            return BlueSystem.getString((String)"scoreGUI.action.removeSoundObject");
        }
        return BlueSystem.getString((String)"scoreGUI.action.removeSoundObjects");
    }

    public void appendNextEdit(RemoveScoreObjectEdit nextEdit) {
        if (this.nextEdit != null) {
            this.nextEdit.appendNextEdit(nextEdit);
        } else {
            this.nextEdit = nextEdit;
        }
    }
}

