/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.score.object.actions;

import blue.score.ScoreObject;
import blue.score.layers.ScoreObjectLayer;
import blue.ui.core.score.ScoreController;
import blue.ui.core.score.ScorePath;
import blue.ui.core.score.undo.AddScoreObjectEdit;
import blue.undo.BlueUndoManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.JOptionPane;
import org.openide.windows.WindowManager;

public final class RepeatScoreObjectsAction
implements ActionListener {
    @Override
    public void actionPerformed(ActionEvent e) {
        Collection<? extends ScoreObject> scoreObjects = ScoreController.getInstance().getSelectedScoreObjects();
        if (!scoreObjects.isEmpty()) {
            String retVal = JOptionPane.showInputDialog(WindowManager.getDefault().getMainWindow(), "Enter number of times to repeat:", new Integer(1));
            if (retVal == null) {
                return;
            }
            int count = -1;
            try {
                count = Integer.parseInt(retVal);
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(WindowManager.getDefault().getMainWindow(), "Entry must be an integer value.", "Error", 0);
                return;
            }
            if (count < 1) {
                JOptionPane.showMessageDialog(WindowManager.getDefault().getMainWindow(), "Value must be greater than 0.", "Error", 0);
                return;
            }
            ScorePath path = ScoreController.getInstance().getScorePath();
            AddScoreObjectEdit top = null;
            for (ScoreObject scoreObject : scoreObjects) {
                double start = scoreObject.getStartTime();
                ScoreObjectLayer layer = (ScoreObjectLayer)path.getLayerForScoreObject(scoreObject);
                for (int j = 0; j < count; ++j) {
                    ScoreObject temp = (ScoreObject)scoreObject.deepCopy();
                    temp.setStartTime(start += scoreObject.getSubjectiveDuration());
                    if (layer == null) {
                        JOptionPane.showMessageDialog(WindowManager.getDefault().getMainWindow(), "Could not find SoundLayer for SoundObject", "Error", 0);
                        return;
                    }
                    layer.add((Object)temp);
                    AddScoreObjectEdit edit = new AddScoreObjectEdit(layer, temp);
                    if (top == null) {
                        top = edit;
                        continue;
                    }
                    top.addSubEdit(edit);
                }
            }
            BlueUndoManager.setUndoManager((String)"score");
            BlueUndoManager.addEdit(top);
        }
    }
}

