/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.score.noteProcessorChain;

import blue.BlueSystem;
import blue.soundObject.editor.pianoRoll.ScaleSelectionPanel;
import blue.soundObject.pianoRoll.Scale;
import blue.ui.core.score.noteProcessorChain.ScaleSelector;
import blue.ui.utilities.FileChooserManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import java.util.Vector;
import javafx.stage.FileChooser;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class ScaleEditor
extends JComponent {
    Vector listeners = new Vector();
    ScaleSelector scaleSelector;
    JButton button;
    JLabel label;
    Scale scale;

    public ScaleEditor() {
        this.initScaleFileSelector();
        this.setLayout(new BorderLayout(0, 0));
        this.button = new JButton("...");
        this.add((Component)this.button, "East");
        this.button.setMargin(new Insets(0, 0, 0, 0));
        this.button.addActionListener(e -> this.selectScale());
        this.label = new JLabel();
        this.add((Component)this.label, "Center");
    }

    public void addActionListener(ActionListener al) {
        this.listeners.add(al);
    }

    public void removeActionListener(ActionListener al) {
        this.listeners.remove(al);
    }

    public void fireActionPerformed() {
        ActionEvent ae = new ActionEvent(this, 1001, "scale");
        for (ActionListener al : this.listeners) {
            al.actionPerformed(ae);
        }
    }

    protected void selectScale() {
        List rValue = FileChooserManager.getDefault().showOpenDialog((Object)ScaleSelectionPanel.FILE_CHOOSER_ID, null);
        if (!rValue.isEmpty()) {
            File f = (File)rValue.get(0);
            if (!f.exists()) {
                return;
            }
            Scale scale = Scale.loadScale((File)f);
            if (scale != null) {
                scale.setBaseFrequency(this.scale.getBaseFrequency());
                this.scale.copyValues(scale);
            }
        }
        this.fireActionPerformed();
    }

    public Scale getScale() {
        return this.scale;
    }

    public void setScale(Scale scale) {
        this.scale = scale;
        this.label.setText(scale.getScaleName());
    }

    private void initScaleFileSelector() {
        if (FileChooserManager.getDefault().isDialogDefined((Object)ScaleSelectionPanel.FILE_CHOOSER_ID)) {
            return;
        }
        FileChooserManager.getDefault().setDialogTitle((Object)ScaleSelectionPanel.FILE_CHOOSER_ID, BlueSystem.getString((String)"pianoRoll.selectScalaFile"));
        FileChooserManager.getDefault().addFilter((Object)ScaleSelectionPanel.FILE_CHOOSER_ID, new FileChooser.ExtensionFilter("Scala File (*.scl)", new String[]{"*.scl"}));
        String fileName = BlueSystem.getUserConfigurationDirectory();
        fileName = fileName + File.separator + "scl";
        File defaultDir = new File(fileName);
        if (defaultDir.exists() && defaultDir.isDirectory()) {
            FileChooserManager.getDefault().setSelectedFile((Object)ScaleSelectionPanel.FILE_CHOOSER_ID, defaultDir);
        }
    }
}

